/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.ReferenceFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherWriter;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FieldImpl
implements Field {
    private final ImmutableType entityType;
    private final ImmutableProp prop;
    private final FieldFilter<?> filter;
    private final int batchSize;
    private final int limit;
    private final int offset;
    @Nullable
    private final RecursionStrategy<?> recursionStrategy;
    @NotNull
    private final ReferenceFetchType fetchType;
    @Nullable
    private final FetcherImpl<?> childFetcher;
    private final boolean isSimpleField;
    private final boolean implicit;
    private final boolean rawId;
    private Fetcher<?> recursiveParent;
    private Field recursionResolved;

    FieldImpl(ImmutableType entityType, ImmutableProp prop, FieldFilter<?> filter, int batchSize, int limit, int offset, RecursionStrategy<?> recursionStrategy, ReferenceFetchType fetchType, FetcherImpl<?> childFetcher, boolean implicit, boolean rawId) {
        this.entityType = entityType;
        this.prop = prop;
        this.filter = filter;
        this.batchSize = batchSize;
        this.limit = limit;
        this.offset = offset;
        this.recursionStrategy = recursionStrategy;
        this.fetchType = fetchType;
        this.childFetcher = childFetcher;
        this.isSimpleField = this.determineIsSimpleField();
        this.implicit = implicit;
        this.rawId = rawId;
    }

    FieldImpl(FieldImpl base, @Nullable FetcherImpl<?> childFetcher) {
        this.entityType = base.entityType;
        this.prop = base.prop;
        this.filter = base.filter;
        this.batchSize = base.batchSize;
        this.limit = base.limit;
        this.offset = base.offset;
        this.recursionStrategy = base.recursionStrategy;
        this.fetchType = base.fetchType;
        this.implicit = base.implicit;
        this.rawId = base.rawId;
        this.childFetcher = childFetcher;
        this.isSimpleField = this.determineIsSimpleField();
    }

    @Override
    public ImmutableType getEntityType() {
        return this.entityType;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public FieldFilter<?> getFilter() {
        return this.filter;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    @Nullable
    public RecursionStrategy<?> getRecursionStrategy() {
        return this.recursionStrategy;
    }

    @Override
    @NotNull
    public ReferenceFetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public Fetcher<?> getChildFetcher() {
        return this.childFetcher;
    }

    @Override
    @Nullable
    public Fetcher<?> getChildFetcher(boolean resolveRecursion) {
        if (resolveRecursion && this.recursiveParent != null) {
            return this.recursiveParent;
        }
        return this.childFetcher;
    }

    @Override
    public boolean isSimpleField() {
        return this.isSimpleField;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public boolean isRawId() {
        return this.rawId;
    }

    @Override
    public Field resolveRecursion() {
        Field rr = this.recursionResolved;
        if (rr == null) {
            rr = this.recursiveParent != null ? this.recursiveParent.getFieldMap().get(this.prop.getName()) : this;
            this.recursionResolved = rr;
        }
        return rr;
    }

    public int hashCode() {
        int result = this.entityType.hashCode();
        result = 31 * result + this.prop.hashCode();
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + this.batchSize;
        result = 31 * result + this.limit;
        result = 31 * result + this.offset;
        result = 31 * result + (this.recursionStrategy != null ? this.recursionStrategy.hashCode() : 0);
        result = 31 * result + (this.childFetcher != null ? this.childFetcher.hashCode() : 0);
        result = 31 * result + (this.isSimpleField ? 1 : 0);
        result = 31 * result + (this.implicit ? 1 : 0);
        result = 31 * result + (this.rawId ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldImpl field = (FieldImpl)o;
        if (this.batchSize != field.batchSize) {
            return false;
        }
        if (this.limit != field.limit) {
            return false;
        }
        if (this.offset != field.offset) {
            return false;
        }
        if (this.isSimpleField != field.isSimpleField) {
            return false;
        }
        if (this.implicit != field.implicit) {
            return false;
        }
        if (this.rawId != field.rawId) {
            return false;
        }
        if (!this.entityType.equals((Object)field.entityType)) {
            return false;
        }
        if (!this.prop.equals((Object)field.prop)) {
            return false;
        }
        if (!Objects.equals(this.filter, field.filter)) {
            return false;
        }
        if (!Objects.equals(this.recursionStrategy, field.recursionStrategy)) {
            return false;
        }
        return Objects.equals(this.childFetcher, field.childFetcher);
    }

    public String toString() {
        FetcherWriter writer = new FetcherWriter();
        writer.write(this);
        return writer.toString();
    }

    void initializeRecursiveParent(Fetcher<?> recursiveParent) {
        if (this.recursiveParent != null) {
            throw new IllegalStateException("The recursive parent has been set");
        }
        this.recursiveParent = recursiveParent;
    }

    private boolean determineIsSimpleField() {
        if (this.prop.isColumnDefinition()) {
            return this.childFetcher == null || this.childFetcher.getFieldMap().size() == 1 && this.childFetcher.getFieldMap().values().iterator().next().getProp().isId();
        }
        return this.prop.getSqlTemplate() instanceof FormulaTemplate;
    }
}

