/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.StringJoiner;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.DefaultRecursionStrategy;

class FetcherWriter {
    private final StringBuilder builder = new StringBuilder();
    private final String indent;
    private int depth;

    public FetcherWriter() {
        this.indent = "";
    }

    public FetcherWriter(int indent) {
        if (indent > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = indent; i > 0; --i) {
                builder.append(' ');
            }
            this.indent = builder.toString();
        } else {
            this.indent = "";
        }
    }

    public void write(Fetcher<?> fetcher) {
        this.builder.append(' ');
        if (this.indent.isEmpty()) {
            this.builder.append("{ ");
            boolean first = true;
            for (Field field : fetcher.getFieldMap().values()) {
                if (!first) {
                    this.builder.append(", ");
                } else {
                    first = false;
                }
                if (field.isImplicit()) {
                    this.builder.append("@implicit ");
                }
                this.write(field);
            }
            this.builder.append(" }");
        } else {
            this.builder.append('{');
            ++this.depth;
            for (Field field : fetcher.getFieldMap().values()) {
                if (field.isImplicit()) continue;
                this.newLine();
                this.write(field);
            }
            --this.depth;
            this.newLine();
            this.builder.append('}');
        }
    }

    public void writeRoot(Fetcher<?> fetcher) {
        this.builder.append(fetcher.getImmutableType());
        this.write(fetcher);
    }

    private void newLine() {
        this.builder.append('\n');
        if (this.depth != 0 && !this.indent.isEmpty()) {
            for (int i = this.depth; i > 0; --i) {
                this.builder.append(this.indent);
            }
        }
    }

    public void write(Field field) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")").setEmptyValue("");
        int batchSize = field.getBatchSize();
        int limit = field.getLimit();
        int offset = field.getOffset();
        RecursionStrategy<?> recursionStrategy = field.getRecursionStrategy();
        FieldFilter<?> filter = field.getFilter();
        Fetcher<?> childFetcher = field.getChildFetcher();
        if (batchSize != 0) {
            joiner.add("batchSize: " + batchSize);
        }
        if (limit != Integer.MAX_VALUE) {
            joiner.add("limit: " + limit);
        }
        if (offset != 0) {
            joiner.add("offset: " + offset);
        }
        if (recursionStrategy instanceof DefaultRecursionStrategy) {
            int depth = ((DefaultRecursionStrategy)recursionStrategy).getDepth();
            if (depth == Integer.MAX_VALUE) {
                joiner.add("recursive: true");
            } else if (depth > 1) {
                joiner.add("depth: " + depth);
            }
        } else if (recursionStrategy != null) {
            joiner.add("recursive: <java-code>");
        }
        if (filter != null) {
            joiner.add("filter: <java-code>");
        }
        this.builder.append(field.getProp().getName()).append(joiner.toString());
        if (field.getRecursionStrategy() == null && childFetcher != null) {
            this.write(childFetcher);
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

