/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.ColumnAccessors;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherContext;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.TupleCreator;
import org.jetbrains.annotations.Nullable;

public class FetcherUtil {
    private FetcherUtil() {
    }

    private static void visitFetchColumns(JSqlClientImplementor sqlClient, List<Selection<?>> selections, IntFunction<Boolean> block) {
        FetcherSelection fetcherSelection;
        Fetcher<?> fetcher;
        Selection<?> selection;
        for (int i = 0; i < selections.size() && (!((selection = selections.get(i)) instanceof FetcherSelection) || ((FetcherImplementor)(fetcher = (fetcherSelection = (FetcherSelection)selection).getFetcher())).__isSimpleFetcher() && !FetcherUtil.hasReferenceFilter(fetcher.getImmutableType(), sqlClient) && fetcherSelection.getConverter() == null || !Boolean.TRUE.equals(block.apply(i))); ++i) {
        }
    }

    public static boolean hasFetchColumns(JSqlClientImplementor sqlClient, List<Selection<?>> selections) {
        boolean[] hasRef = new boolean[1];
        FetcherUtil.visitFetchColumns(sqlClient, selections, i -> {
            hasRef[0] = true;
            return true;
        });
        return hasRef[0];
    }

    public static void fetch(JSqlClientImplementor sqlClient, Connection con, List<Selection<?>> selections, TupleCreator<?> tupleCreator, List<?> rows) {
        if (rows.isEmpty()) {
            return;
        }
        LinkedHashMap columnMap = new LinkedHashMap();
        FetcherUtil.visitFetchColumns(sqlClient, selections, i -> {
            columnMap.put(i, new ArrayList());
            return false;
        });
        if (columnMap.isEmpty()) {
            return;
        }
        for (Object obj : rows) {
            for (Map.Entry e : columnMap.entrySet()) {
                int columnIndex = (Integer)e.getKey();
                List columnValues = (List)e.getValue();
                columnValues.add(ColumnAccessors.get(obj, columnIndex, tupleCreator));
            }
        }
        for (Map.Entry entry : columnMap.entrySet()) {
            Function<?, ?> converter;
            int columnIndex = (Integer)entry.getKey();
            ArrayList<Object> fetchedList = (ArrayList<Object>)entry.getValue();
            FetcherSelection selection = (FetcherSelection)selections.get(columnIndex);
            Fetcher<?> fetcher = selection.getFetcher();
            if (!((FetcherImplementor)fetcher).__isSimpleFetcher() || FetcherUtil.hasReferenceFilter(fetcher.getImmutableType(), sqlClient)) {
                fetchedList = Internal.produceList((ImmutableType)selection.getFetcher().getImmutableType(), (Collection)fetchedList, values -> FetcherUtil.fetch(sqlClient, con, selection.getPath(), selection.getFetcher(), values));
            }
            if ((converter = selection.getConverter()) != null) {
                ArrayList<Object> list = new ArrayList<Object>(fetchedList.size());
                for (Object e : fetchedList) {
                    list.add(e != null ? (Object)converter.apply(e) : null);
                }
                fetchedList = list;
            }
            entry.setValue(fetchedList);
        }
        HashMap<Integer, Object> indexValueMap = new HashMap<Integer, Object>();
        ListIterator<?> listIterator = rows.listIterator();
        int rowIndex = 0;
        while (listIterator.hasNext()) {
            for (Map.Entry e : columnMap.entrySet()) {
                int colIndex = (Integer)e.getKey();
                Object value = ((List)e.getValue()).get(rowIndex);
                indexValueMap.put(colIndex, value);
            }
            listIterator.set(ColumnAccessors.set(listIterator.next(), indexValueMap, tupleCreator));
            ++rowIndex;
        }
    }

    private static void fetch(JSqlClientImplementor sqlClient, Connection con, FetchPath path, Fetcher<?> fetcher, List<@Nullable DraftSpi> drafts) {
        FetcherContext.using(sqlClient, con, (ctx, isRoot) -> {
            ctx.addAll(path, fetcher, drafts);
            if (isRoot.booleanValue()) {
                ctx.execute();
            }
        });
    }

    private static boolean hasReferenceFilter(ImmutableType type, JSqlClientImplementor sqlClient) {
        for (ImmutableProp prop : type.getSelectableReferenceProps().values()) {
            if (sqlClient.getFilters().getTargetFilter(prop) == null) continue;
            return true;
        }
        return false;
    }
}

