/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherTask;
import org.babyfish.jimmer.sql.fetcher.impl.FetchingCache;
import org.babyfish.jimmer.sql.fetcher.impl.JoinFetchFieldVisitor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.Nullable;

class FetcherContext {
    private static final ThreadLocal<FetcherContext> FETCHER_CONTEXT_LOCAL = new ThreadLocal();
    private final JSqlClientImplementor sqlClient;
    private final Connection con;
    private final FetchingCache cache = new FetchingCache();
    private final Map<FetchedField, FetcherTask> taskMap = new LinkedHashMap<FetchedField, FetcherTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void using(JSqlClientImplementor sqlClient, Connection con, BiConsumer<FetcherContext, Boolean> block) {
        FetcherContext ctx = FETCHER_CONTEXT_LOCAL.get();
        if (ctx != null) {
            block.accept(ctx, false);
        } else {
            ctx = new FetcherContext(sqlClient, con);
            FETCHER_CONTEXT_LOCAL.set(ctx);
            try {
                block.accept(ctx, true);
            }
            finally {
                FETCHER_CONTEXT_LOCAL.remove();
            }
        }
    }

    private FetcherContext(JSqlClientImplementor sqlClient, Connection con) {
        this.sqlClient = sqlClient;
        this.con = con;
    }

    public void addAll(FetchPath path, Fetcher<?> fetcher, Collection<@Nullable DraftSpi> drafts) {
        for (DraftSpi draft : drafts) {
            if (draft == null) continue;
            new TaskAdder(path, draft).visit(fetcher);
        }
    }

    public void execute() {
        while (!this.taskMap.isEmpty()) {
            Iterator<Map.Entry<FetchedField, FetcherTask>> itr = this.taskMap.entrySet().iterator();
            Map.Entry<FetchedField, FetcherTask> e = itr.next();
            if (!e.getValue().execute()) continue;
            this.taskMap.remove(e.getKey());
        }
    }

    private class TaskAdder
    extends JoinFetchFieldVisitor {
        private final FetchPath path;
        private DraftSpi draft;

        TaskAdder(FetchPath path, DraftSpi draft) {
            super(FetcherContext.this.sqlClient);
            this.path = path;
            this.draft = draft;
        }

        @Override
        protected Object enter(Field field) {
            DraftSpi oldDraft = this.draft;
            if (oldDraft != null) {
                this.draft = (DraftSpi)oldDraft.__get(field.getProp().getId());
            }
            return oldDraft;
        }

        @Override
        protected void leave(Field field, Object enterValue) {
            this.draft = (DraftSpi)enterValue;
        }

        @Override
        protected void visit(Field field, int depth) {
            if (!this.isFetchRequired(field)) {
                return;
            }
            RecursionStrategy<?> recursionStrategy = field.getRecursionStrategy();
            if (recursionStrategy != null && !recursionStrategy.isRecursive(new RecursionStrategy.Args<DraftSpi>(this.draft, 0))) {
                return;
            }
            FetcherTask task = FetcherContext.this.taskMap.computeIfAbsent(new FetchedField(this.path, field), it -> new FetcherTask(FetcherContext.this.cache, FetcherContext.this.sqlClient, FetcherContext.this.con, this.path, field));
            task.add(this.draft);
        }

        private boolean isFetchRequired(Field field) {
            ImmutableProp prop = field.getProp();
            if (!prop.getDependencies().isEmpty()) {
                return false;
            }
            if (!prop.hasTransientResolver() && !prop.isAssociation(TargetLevel.ENTITY)) {
                return false;
            }
            return !field.isSimpleField() || !field.isRawId() && FetcherContext.this.sqlClient.getFilters().getFilter(field.getProp().getTargetType()) != null;
        }
    }

    private static class FetchedField {
        final FetchPath path;
        final Field field;

        private FetchedField(FetchPath path, Field field) {
            this.path = path;
            this.field = field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FetchedField that = (FetchedField)o;
            if (!Objects.equals(this.path, that.path)) {
                return false;
            }
            return this.field.getProp().equals((Object)that.field.getProp());
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + this.field.getProp().hashCode();
            return result;
        }

        public String toString() {
            return "Key{path='" + this.path + '\'' + ", field=" + this.field + '}';
        }
    }
}

