/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.impl;

import java.util.HashSet;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.jetbrains.annotations.Nullable;

public class EvictContext {
    private static final ThreadLocal<EvictContext> LOCAL = new ThreadLocal();
    private final Set<EvictItem> items = new HashSet<EvictItem>();
    private final Set<ImmutableProp> disabledAssociations = new HashSet<ImmutableProp>();

    public static void execute(Runnable block) {
        EvictContext ctx = LOCAL.get();
        if (ctx != null) {
            block.run();
        } else {
            ctx = new EvictContext();
            LOCAL.set(ctx);
            try {
                block.run();
            }
            finally {
                LOCAL.remove();
            }
        }
    }

    @Nullable
    public static EvictContext get() {
        return LOCAL.get();
    }

    public boolean add(ImmutableType type, Object id) {
        return this.items.add(new EvictItem(type, id));
    }

    public boolean add(ImmutableProp prop, Object id) {
        if (this.disabledAssociations.contains(prop)) {
            return false;
        }
        return this.items.add(new EvictItem(prop, id));
    }

    public void disable(ImmutableProp prop) {
        this.disabledAssociations.add(prop);
        ImmutableProp opposite = prop.getOpposite();
        if (opposite != null) {
            this.disabledAssociations.add(opposite);
        }
    }

    public boolean isAllowed(ImmutableProp prop) {
        return !this.disabledAssociations.contains(prop);
    }

    private static class EvictItem {
        final Object sourceId;
        final Object meta;

        EvictItem(ImmutableType type, Object sourceId) {
            this.meta = type;
            this.sourceId = sourceId;
        }

        EvictItem(ImmutableProp prop, Object sourceId) {
            this.meta = prop;
            this.sourceId = sourceId;
        }

        public int hashCode() {
            int result = this.sourceId.hashCode();
            result = 31 * result + this.meta.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvictItem evictItem = (EvictItem)o;
            if (!this.sourceId.equals(evictItem.sourceId)) {
                return false;
            }
            return this.meta.equals(evictItem.meta);
        }

        public String toString() {
            return "EvictItem{sourceId=" + this.sourceId + ", meta=" + this.meta + '}';
        }
    }
}

