/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import java.util.function.IntSupplier;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.query.ForUpdate;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.query.LockWait;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.jetbrains.annotations.Nullable;
import org.postgresql.util.PGobject;

public class PostgresDialect
extends DefaultDialect {
    private static final Reader<PGobject> PG_OBJECT_READER = new Reader<PGobject>(){

        @Override
        public PGobject read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getObject(ctx.col(), PGobject.class);
        }

        @Override
        public void skip(Reader.Context ctx) {
            ctx.col();
        }
    };

    @Override
    public UpdateJoin getUpdateJoin() {
        return new UpdateJoin(false, UpdateJoin.From.AS_JOIN);
    }

    @Override
    public String getSelectIdFromSequenceSql(String sequenceName) {
        return "select nextval('" + sequenceName + "')";
    }

    @Override
    public String getOverrideIdentityIdSql() {
        return "overriding system value";
    }

    @Override
    public Class<?> getJsonBaseType() {
        return PGobject.class;
    }

    @Override
    public Object jsonToBaseValue(@Nullable String json) throws SQLException {
        PGobject pgobject = new PGobject();
        pgobject.setType("jsonb");
        pgobject.setValue(json);
        return pgobject;
    }

    @Override
    @Nullable
    public String baseValueToJson(@Nullable Object baseValue) throws SQLException {
        return baseValue == null ? null : ((PGobject)baseValue).getValue();
    }

    @Override
    public Reader<?> unknownReader(Class<?> sqlType) {
        if (sqlType == PGobject.class) {
            return PG_OBJECT_READER;
        }
        return null;
    }

    @Override
    public boolean isIgnoreCaseLikeSupported() {
        return true;
    }

    @Override
    public boolean isArraySupported() {
        return true;
    }

    @Override
    public String arrayTypeSuffix() {
        return "[]";
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "text";
        }
        if (elementType == UUID.class) {
            return "uuid";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "numeric";
        }
        if (elementType == Double.TYPE) {
            return "numeric";
        }
        if (elementType == BigDecimal.class) {
            return "numeric";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "time";
        }
        if (elementType == OffsetTime.class) {
            return "time with time zone";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "timestamp";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class || elementType == Instant.class) {
            return "timestamp with time zone";
        }
        return null;
    }

    @Override
    public <T> T[] getArray(ResultSet rs, int col, Class<T[]> arrayType) throws SQLException {
        Array array = rs.getArray(col);
        if (array != null) {
            return (Object[])array.getArray();
        }
        return null;
    }

    public Reader<String> jsonReader() {
        return new Reader<String>(){

            @Override
            public String read(ResultSet rs, Reader.Context ctx) throws SQLException {
                PGobject pgObject = rs.getObject(ctx.col(), PGobject.class);
                return pgObject == null ? null : pgObject.getValue();
            }

            @Override
            public void skip(Reader.Context ctx) {
                ctx.col();
            }
        };
    }

    @Override
    public boolean isIdFetchableByKeyUpdate() {
        return true;
    }

    @Override
    public boolean isInsertedIdReturningRequired() {
        return true;
    }

    @Override
    public boolean isUpsertSupported() {
        return true;
    }

    @Override
    public boolean isUpsertWithOptimisticLockSupported() {
        return true;
    }

    @Override
    public boolean isUpsertWithNullableKeySupported() {
        return true;
    }

    @Override
    public boolean isTransactionAbortedByError() {
        return true;
    }

    @Override
    public boolean isBatchUpdateExceptionUnreliable() {
        return true;
    }

    @Override
    public void update(Dialect.UpdateContext ctx) {
        if (!ctx.isUpdatedByKey()) {
            super.update(ctx);
            return;
        }
        ctx.sql("update ").appendTableName().enter(AbstractSqlBuilder.ScopeType.SET).appendAssignments().leave().enter(AbstractSqlBuilder.ScopeType.WHERE).appendPredicates().leave().sql(" returning ").appendId();
    }

    @Override
    public void upsert(Dialect.UpsertContext ctx) {
        ctx.sql("insert into ").appendTableName().enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendInsertedColumns("").leave().sql(" values").enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendInsertingValues().leave().sql(" on conflict").enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendConflictColumns().leave();
        if (ctx.isUpdateIgnored()) {
            ctx.sql(" do nothing");
            if (ctx.hasGeneratedId()) {
                ctx.sql(" returning ").appendGeneratedId();
            }
        } else if (ctx.hasUpdatedColumns()) {
            ctx.sql(" do update").enter(AbstractSqlBuilder.ScopeType.SET).appendUpdatingAssignments("excluded.", "").leave();
            if (ctx.hasOptimisticLock()) {
                ctx.sql(" where ").appendOptimisticLockCondition("excluded.");
            }
            if (ctx.hasGeneratedId()) {
                ctx.sql(" returning ").appendGeneratedId();
            }
        } else if (ctx.hasGeneratedId()) {
            ctx.sql(" do update set ");
            List<ValueGetter> conflictGetters = ctx.getConflictGetters();
            ValueGetter cheapestGetter = conflictGetters.get(0);
            for (ValueGetter getter : conflictGetters) {
                Class type = getter.metadata().getValueProp().getReturnClass();
                if ((type = Classes.boxTypeOf((Class)type)) != Boolean.class && !Number.class.isAssignableFrom(type)) continue;
                cheapestGetter = getter;
                break;
            }
            ctx.sql("/* fake update to return all ids */").sql(" ").sql(cheapestGetter).sql(" = excluded.").sql(cheapestGetter);
            ctx.sql(" returning ").appendGeneratedId();
        } else {
            ctx.sql(" do nothing");
        }
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(\n\tID bigint generated always as identity,\n\tIMMUTABLE_TYPE text,\n\tIMMUTABLE_PROP text,\n\tCACHE_KEY text not null,\n\tREASON text\n)";
    }

    @Override
    public void renderPosition(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast subStrAst, Ast expressionAst, @Nullable Ast startAst) {
        if (startAst == null) {
            super.renderPosition(builder, currentPrecedence, subStrAst, expressionAst, null);
            return;
        }
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("case when ")).ast(startAst, currentPrecedence)).sql(" > length(")).ast(expressionAst, currentPrecedence)).sql(") then 0 else strpos(substring(")).ast(expressionAst, currentPrecedence)).sql(" from ")).ast(startAst, currentPrecedence)).sql("), ")).ast(subStrAst, currentPrecedence)).sql(") + ")).ast(startAst, currentPrecedence)).sql(" - 1 end");
    }

    @Override
    public void renderTimePlus(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast valueAst, SqlTimeUnit timeUnit) {
        builder.ast(expressionAst, 3);
        builder.sql(" + ");
        builder.ast(valueAst, 2);
        switch (timeUnit) {
            case NANOSECONDS: {
                builder.sql(" * interval '1 nanosecond");
                break;
            }
            case MICROSECONDS: {
                builder.sql(" * interval '1 microsecond'");
                break;
            }
            case MILLISECONDS: {
                builder.sql(" * interval '1 millisecond'");
                break;
            }
            case SECONDS: {
                builder.sql(" * interval '1 second'");
                break;
            }
            case MINUTES: {
                builder.sql(" * interval '1 minute'");
                break;
            }
            case HOURS: {
                builder.sql(" * interval '1 hour'");
                break;
            }
            case DAYS: {
                builder.sql(" * interval '1 day'");
                break;
            }
            case WEEKS: {
                builder.sql(" * interval '1 week'");
                break;
            }
            case MONTHS: {
                builder.sql(" * interval '1 month'");
                break;
            }
            case QUARTERS: {
                builder.sql(" * interval '3 month'");
                break;
            }
            case YEARS: {
                builder.sql(" * interval '1 year'");
                break;
            }
            case DECADES: {
                builder.sql(" * interval '10 year'");
                break;
            }
            case CENTURIES: {
                builder.sql(" * interval '100 year'");
                break;
            }
            default: {
                throw new IllegalStateException("Time plus/minus by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
    }

    @Override
    public void renderTimeDiff(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast otherAst, SqlTimeUnit timeUnit) {
        String op;
        switch (timeUnit) {
            case NANOSECONDS: {
                op = " * 1000000000";
                break;
            }
            case MICROSECONDS: {
                op = " * 1000000";
                break;
            }
            case MILLISECONDS: {
                op = "*1000";
                break;
            }
            case SECONDS: {
                op = "";
                break;
            }
            case MINUTES: {
                op = " / 60";
                break;
            }
            case HOURS: {
                op = " / 3600";
                break;
            }
            case DAYS: {
                op = " / 86400";
                break;
            }
            case WEEKS: {
                op = " / 86400 / 7.0";
                break;
            }
            case MONTHS: {
                op = " / 86400 / 30.44";
                break;
            }
            case QUARTERS: {
                op = " / 86400 / 91.31";
                break;
            }
            case YEARS: {
                op = " / 86400 / 365.24";
                break;
            }
            case DECADES: {
                op = " / 86400 / 3652.4";
                break;
            }
            case CENTURIES: {
                op = " / 86400 / 36524.0";
                break;
            }
            default: {
                throw new IllegalStateException("Time diff by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
        builder.sql("extract(epoch from ");
        builder.ast(expressionAst, 0);
        builder.sql(" - ");
        builder.ast(otherAst, 0);
        ((AbstractSqlBuilder)builder.sql(")")).sql(op);
    }

    @Override
    public void renderForUpdate(AbstractSqlBuilder<?> builder, ForUpdate forUpdate) {
        builder.sql(" for ");
        switch (forUpdate.getLockMode()) {
            case UPDATE: {
                builder.sql("update");
                break;
            }
            case SHARE: {
                builder.sql("share");
                break;
            }
            case PG_NO_KEY_UPDATE: {
                builder.sql("no key update");
                break;
            }
            case PG_KEY_SHARE: {
                builder.sql("key share");
            }
        }
        LockWait wait = forUpdate.getLockWait();
        if (wait == LockWait.NO_WAIT) {
            builder.sql(" no wait");
        } else if (wait == LockWait.SKIP_LOCKED) {
            builder.sql(" skip locked");
        } else if (wait instanceof IntSupplier) {
            IntSupplier supplier = (IntSupplier)((Object)wait);
            int seconds = supplier.getAsInt();
            ((AbstractSqlBuilder)builder.sql(" wait ")).sql(Integer.toString(seconds));
        }
    }
}

