/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.function.IntSupplier;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.query.ForUpdate;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.query.LockMode;
import org.babyfish.jimmer.sql.ast.query.LockWait;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.jetbrains.annotations.Nullable;

public class OracleDialect
extends DefaultDialect {
    public static final String OPTIMIZE_CORE_ROW_NUMBER_ALIAS = "optimize_rn__";

    @Override
    public void paginate(PaginationContext ctx) {
        long offset = ctx.getOffset();
        if (offset == 0L) {
            this.limit(ctx);
        } else {
            if (ctx.isIdOnly()) {
                ctx.sql("select limited__.*");
                if (ctx.isIdOnly()) {
                    ctx.sql(", rownum ").sql(OPTIMIZE_CORE_ROW_NUMBER_ALIAS);
                }
            } else {
                ctx.sql("select *");
            }
            ctx.sql(" from (");
            this.limit(ctx);
            ctx.sql(") limited__ where rn__ > ");
            ctx.variable(offset);
        }
    }

    private void limit(PaginationContext ctx) {
        long offset = ctx.getOffset();
        int limit = ctx.getLimit();
        String rnProjection = offset > 0L ? ", rownum rn__" : "";
        ctx.sql("select core__.*" + rnProjection + " from (").newLine().origin().newLine().sql(") core__ where rownum <= ").variable(offset + (long)limit);
    }

    @Override
    public String getSelectIdFromSequenceSql(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    @Nullable
    public String getOffsetOptimizationNumField() {
        return "ROWNUM";
    }

    @Override
    public boolean isTupleComparisonSupported() {
        return false;
    }

    @Override
    public boolean isMultiInsertionSupported() {
        return false;
    }

    @Override
    @Nullable
    public String getConstantTableName() {
        return "dual";
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar2";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "number";
        }
        if (elementType == Byte.TYPE) {
            return "number";
        }
        if (elementType == Short.TYPE) {
            return "number";
        }
        if (elementType == Integer.TYPE) {
            return "number";
        }
        if (elementType == Long.TYPE) {
            return "number";
        }
        if (elementType == Float.TYPE) {
            return "binary_float";
        }
        if (elementType == Double.TYPE) {
            return "binary_double";
        }
        if (elementType == BigDecimal.class) {
            return "number";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "timestamp with time zone";
        }
        if (elementType == OffsetTime.class) {
            return "timestamp with time zone";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "timestamp";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class) {
            return "timestamp with time zone";
        }
        return null;
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(\n\tID number generated always as identity,\n\tIMMUTABLE_TYPE varchar2(128),\n\tIMMUTABLE_PROP varchar2(128),\n\tCACHE_KEY varchar2(64) not null,\n\tREASON varchar2(32)\n)";
    }

    @Override
    public void renderPosition(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast subStrAst, Ast expressionAst, @Nullable Ast startAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("instr(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(subStrAst, currentPrecedence);
        if (startAst != null) {
            ((AbstractSqlBuilder)builder.sql(", ")).ast(startAst, currentPrecedence);
        }
        builder.sql(")");
    }

    @Override
    public void renderLeft(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast lengthAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("case when ")).ast(lengthAst, currentPrecedence)).sql(" <= 0 then '' ")).sql("when ")).ast(lengthAst, currentPrecedence)).sql(" >= length(")).ast(expressionAst, currentPrecedence)).sql(") then ")).ast(expressionAst, currentPrecedence)).sql(" else substring(1, ")).ast(lengthAst, currentPrecedence)).sql(") end");
    }

    @Override
    public void renderRight(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast lengthAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("case when ")).ast(lengthAst, currentPrecedence)).sql(" <= 0 then '' ")).sql("when ")).ast(lengthAst, currentPrecedence)).sql(" >= length(")).ast(expressionAst, currentPrecedence)).sql(") then ")).ast(expressionAst, currentPrecedence)).sql(" else substring(1, -")).ast(lengthAst, currentPrecedence)).sql(") end");
    }

    @Override
    public void renderSubString(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast startAst, @Nullable Ast lengthAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("substr(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(startAst, currentPrecedence);
        if (lengthAst != null) {
            ((AbstractSqlBuilder)builder.sql(", ")).ast(lengthAst, currentPrecedence);
        }
        builder.sql(")");
    }

    @Override
    public void renderTimePlus(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast valueAst, SqlTimeUnit timeUnit) {
        builder.ast(expressionAst, currentPrecedence);
        builder.sql(" + ");
        switch (timeUnit) {
            case NANOSECONDS: {
                builder.sql("numtodsinterval(");
                builder.ast(valueAst, 0);
                builder.sql(" / 1000000000, 'second')");
                break;
            }
            case MICROSECONDS: {
                builder.sql("numtodsinterval(");
                builder.ast(valueAst, 0);
                builder.sql(" / 1000000, 'second')");
                break;
            }
            case MILLISECONDS: {
                builder.sql("numtodsinterval(");
                builder.ast(valueAst, 0);
                builder.sql(" / 1000, 'second')");
                break;
            }
            case SECONDS: {
                builder.sql("numtodsinterval(");
                builder.ast(valueAst, 0);
                builder.sql(", 'second')");
                break;
            }
            case MINUTES: {
                builder.sql("numtodsinterval(");
                builder.ast(valueAst, 0);
                builder.sql(", 'minute')");
                break;
            }
            case HOURS: {
                builder.sql("numtodsinterval(");
                builder.ast(valueAst, 0);
                builder.sql(", 'hour')");
                break;
            }
            case DAYS: {
                builder.ast(valueAst, 0);
                break;
            }
            case WEEKS: {
                builder.ast(valueAst, 0);
                builder.sql(" * 7");
                break;
            }
            case MONTHS: {
                builder.sql("numtoyminterval(");
                builder.ast(valueAst, 0);
                builder.sql(", 'month')");
                break;
            }
            case QUARTERS: {
                builder.sql("numtoyminterval(");
                builder.ast(valueAst, 0);
                builder.sql(" * 3, 'month')");
                break;
            }
            case YEARS: {
                builder.sql("numtoyminterval(");
                builder.ast(valueAst, 0);
                builder.sql(", 'year')");
                break;
            }
            case DECADES: {
                builder.sql("numtoyminterval(");
                builder.ast(valueAst, 0);
                builder.sql(" * 10, 'year')");
                break;
            }
            case CENTURIES: {
                builder.sql("numtoyminterval(");
                builder.ast(valueAst, 0);
                builder.sql(" * 100, 'year')");
                break;
            }
            default: {
                throw new IllegalStateException("Time plus/minus by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
    }

    @Override
    public void renderForUpdate(AbstractSqlBuilder<?> builder, ForUpdate forUpdate) {
        if (forUpdate.getLockMode() != LockMode.UPDATE) {
            throw new IllegalArgumentException("Oracle only supports LockMode.UPDATE");
        }
        builder.sql(" for update ");
        LockWait wait = forUpdate.getLockWait();
        if (wait == LockWait.NO_WAIT) {
            builder.sql(" no wait");
        } else if (wait == LockWait.SKIP_LOCKED) {
            builder.sql(" skip locked");
        } else if (wait instanceof IntSupplier) {
            IntSupplier supplier = (IntSupplier)((Object)wait);
            int seconds = supplier.getAsInt();
            ((AbstractSqlBuilder)builder.sql(" wait ")).sql(Integer.toString(seconds));
        }
    }
}

