/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.jetbrains.annotations.Nullable;

public abstract class MySqlStyleDialect
extends DefaultDialect {
    @Override
    public void paginate(PaginationContext ctx) {
        ctx.origin().space().sql("limit ").variable(ctx.getOffset()).sql(", ").variable(ctx.getLimit());
    }

    @Override
    public UpdateJoin getUpdateJoin() {
        return new UpdateJoin(true, UpdateJoin.From.UNNECESSARY);
    }

    @Override
    public boolean isDeletedAliasRequired() {
        return true;
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float";
        }
        if (elementType == Double.TYPE) {
            return "double";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType != Date.class && elementType != LocalDate.class) {
            if (elementType != Time.class && elementType != LocalTime.class) {
                if (elementType == OffsetTime.class) {
                    return "datetime";
                }
                if (elementType != java.util.Date.class && elementType != Timestamp.class) {
                    if (elementType == LocalDateTime.class) {
                        return "timestamp";
                    }
                    return elementType != OffsetDateTime.class && elementType != ZonedDateTime.class ? null : "timestamp";
                }
                return "timestamp";
            }
            return "datetime";
        }
        return "date";
    }

    @Override
    public boolean isUpsertWithMultipleUniqueConstraintSupported() {
        return false;
    }

    @Override
    public boolean isIdFetchableByKeyUpdate() {
        return true;
    }

    @Override
    public boolean isUpsertSupported() {
        return false;
    }

    @Override
    public boolean isTableOfSubQueryMutable() {
        return false;
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(\n\tID bigint unsigned not null auto_increment primary key,\n\tIMMUTABLE_TYPE varchar(128),\n\tIMMUTABLE_PROP varchar(128),\n\tCACHE_KEY varchar(64) not null,\n\tREASON varchar(32)\n) engine=innodb";
    }

    @Override
    public void renderPosition(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast subStrAst, Ast expressionAst, @Nullable Ast startAst) {
        if (startAst != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("locate(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(subStrAst, currentPrecedence)).sql(", ")).ast(startAst, currentPrecedence)).sql(")");
        } else {
            super.renderPosition(builder, currentPrecedence, subStrAst, expressionAst, startAst);
        }
    }

    @Override
    public void renderTimePlus(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast valueAst, SqlTimeUnit timeUnit) {
        builder.sql("date_add(");
        builder.ast(expressionAst, currentPrecedence);
        builder.sql(", interval ");
        switch (timeUnit) {
            case NANOSECONDS: {
                builder.ast(valueAst, 3);
                builder.sql(" / 1000 microsecond");
            }
            case MICROSECONDS: {
                builder.ast(valueAst, 3);
                builder.sql(" microsecond");
                break;
            }
            case MILLISECONDS: {
                builder.ast(valueAst, 3);
                builder.sql(" * 1000 microsecond");
                break;
            }
            case SECONDS: {
                builder.ast(valueAst, 0);
                builder.sql(" second");
                break;
            }
            case MINUTES: {
                builder.ast(valueAst, 0);
                builder.sql(" minute");
                break;
            }
            case HOURS: {
                builder.ast(valueAst, 0);
                builder.sql(" hour");
                break;
            }
            case DAYS: {
                builder.ast(valueAst, 0);
                builder.sql(" day");
                break;
            }
            case WEEKS: {
                builder.ast(valueAst, 0);
                builder.sql(" week");
                break;
            }
            case MONTHS: {
                builder.ast(valueAst, 0);
                builder.sql(" month");
                break;
            }
            case QUARTERS: {
                builder.ast(valueAst, 0);
                builder.sql(" * 3 month");
                break;
            }
            case YEARS: {
                builder.ast(valueAst, 0);
                builder.sql(" year");
                break;
            }
            case DECADES: {
                builder.ast(valueAst, 0);
                builder.sql(" * 10 year");
                break;
            }
            case CENTURIES: {
                builder.ast(valueAst, 0);
                builder.sql(" * 100 year");
                break;
            }
            default: {
                throw new IllegalStateException("Time plus/minus by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
        builder.sql(")");
    }

    @Override
    public void renderTimeDiff(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast otherAst, SqlTimeUnit timeUnit) {
        String op;
        switch (timeUnit) {
            case NANOSECONDS: {
                op = " * 1000";
                break;
            }
            case MICROSECONDS: {
                op = "";
                break;
            }
            case MILLISECONDS: {
                op = " / 1000";
                break;
            }
            case SECONDS: {
                op = " / 1000000";
                break;
            }
            case MINUTES: {
                op = " / 60000000";
                break;
            }
            case HOURS: {
                op = " / 3600000000";
                break;
            }
            case DAYS: {
                op = " / 86400000000";
                break;
            }
            case WEEKS: {
                op = " / 86400000000 / 7.0";
                break;
            }
            case MONTHS: {
                op = " / 86400000000 / 30.44";
                break;
            }
            case QUARTERS: {
                op = " / 86400000000 / 91.31";
                break;
            }
            case YEARS: {
                op = " / 86400000000 / 365.24";
                break;
            }
            case DECADES: {
                op = " / 86400000000 / 3652.4";
                break;
            }
            case CENTURIES: {
                op = " / 86400000000 / 36524.0";
                break;
            }
            default: {
                throw new IllegalStateException("Time diff by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
        builder.sql("timestampdiff(microsecond, ");
        builder.ast(otherAst, 0);
        builder.sql(", ");
        builder.ast(expressionAst, 0);
        ((AbstractSqlBuilder)builder.sql(")")).sql(op);
    }
}

