/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import java.util.function.IntSupplier;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.query.ForUpdate;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.query.LockWait;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.h2.value.ValueJson;
import org.jetbrains.annotations.Nullable;

public class H2Dialect
extends DefaultDialect {
    @Override
    public String jdbcParameter(Class<?> sqlType) {
        if (sqlType == byte[].class) {
            return "?::varbinary";
        }
        return "?";
    }

    @Override
    public boolean isIgnoreCaseLikeSupported() {
        return true;
    }

    @Override
    public boolean isArraySupported() {
        return true;
    }

    @Override
    public String arrayTypeSuffix() {
        return " array";
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float(24)";
        }
        if (elementType == Double.TYPE) {
            return "float(53)";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "time without time zone";
        }
        if (elementType == OffsetTime.class) {
            return "time";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "timestamp";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class || elementType == Instant.class) {
            return "timestamp with time zone";
        }
        return null;
    }

    @Override
    public <T> T[] getArray(ResultSet rs, int col, Class<T[]> arrayType) throws SQLException {
        return rs.getObject(col, arrayType);
    }

    @Override
    public boolean isTupleCountSupported() {
        return true;
    }

    @Override
    public String getSelectIdFromSequenceSql(String sequenceName) {
        return "select nextval('" + sequenceName + "')";
    }

    @Override
    @Nullable
    public Object jsonToBaseValue(@Nullable String json) throws SQLException {
        return json == null ? null : ValueJson.fromJson((String)json);
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(ID identity not null primary key,IMMUTABLE_TYPE varchar,IMMUTABLE_PROP varchar,CACHE_KEY varchar not null,REASON varchar)";
    }

    @Override
    public boolean isIdFetchableByKeyUpdate() {
        return true;
    }

    @Override
    public boolean isUpsertSupported() {
        return true;
    }

    @Override
    public void upsert(Dialect.UpsertContext ctx) {
        if (!ctx.isUpdateIgnored() && ctx.isComplete()) {
            ctx.sql("merge into ").appendTableName().enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendInsertedColumns("").leave().sql(" key").enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendConflictColumns().leave().sql(" values").enter(AbstractSqlBuilder.ScopeType.LIST).appendInsertingValues().leave();
            return;
        }
        ctx.sql("merge into ").appendTableName().sql(" tb_1_ using").enter(AbstractSqlBuilder.ScopeType.LIST).sql("values").enter(AbstractSqlBuilder.ScopeType.LIST).appendInsertingValues().leave().leave().sql(" tb_2_").enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendInsertedColumns("").leave().sql(" on ");
        ctx.enter(AbstractSqlBuilder.ScopeType.AND);
        for (ValueGetter getter : ctx.getConflictGetters()) {
            ctx.separator().sql("tb_1_.").sql(getter).sql(" = tb_2_.").sql(getter);
        }
        ctx.leave();
        if (!ctx.isUpdateIgnored() && ctx.hasGeneratedId() || ctx.hasUpdatedColumns()) {
            ctx.sql(" when matched then update").enter(AbstractSqlBuilder.ScopeType.SET);
            if (ctx.hasUpdatedColumns()) {
                ctx.appendUpdatingAssignments("tb_2_.", "");
            } else {
                ctx.sql("/* fake update to return all ids */").sql(" ");
                List<ValueGetter> conflictGetters = ctx.getConflictGetters();
                ValueGetter cheapestGetter = conflictGetters.get(0);
                for (ValueGetter getter : conflictGetters) {
                    Class type = getter.metadata().getValueProp().getReturnClass();
                    if ((type = Classes.boxTypeOf((Class)type)) != Boolean.class && !Number.class.isAssignableFrom(type)) continue;
                    cheapestGetter = getter;
                    break;
                }
                ctx.sql(cheapestGetter).sql(" = tb_2_.").sql(cheapestGetter);
            }
            ctx.leave();
        }
        ctx.sql(" when not matched then insert").enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendInsertedColumns("").leave().enter(AbstractSqlBuilder.ScopeType.VALUES).enter(AbstractSqlBuilder.ScopeType.MULTIPLE_LINE_TUPLE).appendInsertedColumns("tb_2_.").leave().leave();
    }

    @Override
    public void renderPosition(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast subStrAst, Ast expressionAst, @Nullable Ast startAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("locate(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(subStrAst, currentPrecedence);
        if (startAst != null) {
            ((AbstractSqlBuilder)builder.sql(", ")).ast(startAst, currentPrecedence);
        }
        builder.sql(")");
    }

    @Override
    public void renderForUpdate(AbstractSqlBuilder<?> builder, ForUpdate forUpdate) {
        builder.sql(" for ");
        switch (forUpdate.getLockMode()) {
            case UPDATE: {
                builder.sql("update");
                break;
            }
            case SHARE: {
                builder.sql("share");
                break;
            }
            default: {
                throw new IllegalArgumentException("H2 does not support LockMode." + forUpdate.getLockMode().name());
            }
        }
        LockWait wait = forUpdate.getLockWait();
        if (wait == LockWait.NO_WAIT) {
            builder.sql(" no wait");
        } else if (wait == LockWait.SKIP_LOCKED) {
            if (forUpdate.getLockMode().isShared()) {
                throw new IllegalArgumentException("H2 does not support LockMode.SHARE and LockWait.SKIP_LOCKED");
            }
            builder.sql(" skip locked");
        } else if (wait instanceof IntSupplier) {
            throw new IllegalArgumentException("H2 does not support " + wait);
        }
    }
}

