/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.query.ForUpdate;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.meta.SqlTypeStrategy;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.jetbrains.annotations.Nullable;

public interface Dialect
extends SqlTypeStrategy {
    public static final String FAKE_UPDATE_COMMENT = "/* fake update to return all ids */";

    default public String jdbcParameter(Class<?> sqlType) {
        return "?";
    }

    public void paginate(PaginationContext var1);

    @Nullable
    default public UpdateJoin getUpdateJoin() {
        return null;
    }

    default public String getSelectIdFromSequenceSql(String sequenceName) {
        throw new ExecutionException("Sequence is not supported by '" + this.getClass().getName() + "'");
    }

    @Nullable
    default public String getOverrideIdentityIdSql() {
        return null;
    }

    default public boolean isDeletedAliasRequired() {
        return false;
    }

    default public boolean isDeleteAliasSupported() {
        return true;
    }

    default public boolean isUpdateAliasSupported() {
        return true;
    }

    @Nullable
    default public String getOffsetOptimizationNumField() {
        return null;
    }

    default public boolean isMultiInsertionSupported() {
        return true;
    }

    default public boolean isArraySupported() {
        return false;
    }

    default public boolean isAnyEqualityOfArraySupported() {
        return this.isArraySupported();
    }

    default public <T> T[] getArray(ResultSet rs, int col, Class<T[]> arrayType) throws SQLException {
        throw new UnsupportedOperationException("`Dialect.getArray` is not supported");
    }

    default public boolean isTupleSupported() {
        return true;
    }

    default public boolean isTupleComparisonSupported() {
        return this.isTupleSupported();
    }

    default public boolean isTupleCountSupported() {
        return false;
    }

    default public boolean isTableOfSubQueryMutable() {
        return true;
    }

    @Nullable
    default public String getConstantTableName() {
        return null;
    }

    default public Class<?> getJsonBaseType() {
        return String.class;
    }

    @Nullable
    default public Object jsonToBaseValue(@Nullable String json) throws SQLException {
        return json;
    }

    @Nullable
    default public String baseValueToJson(@Nullable Object baseValue) throws SQLException {
        return (String)baseValue;
    }

    default public boolean isForeignKeySupported() {
        return true;
    }

    default public boolean isIgnoreCaseLikeSupported() {
        return false;
    }

    default public int resolveJdbcType(Class<?> sqlType) {
        return 1111;
    }

    default public Reader<?> unknownReader(Class<?> sqlType) {
        return null;
    }

    default public String transCacheOperatorTableDDL() {
        throw new UnsupportedOperationException("The current dialect \"" + this.getClass().getName() + "\" does not know how to create table `JIMMER_TRANS_CACHE_OPERATOR`");
    }

    default public int getMaxInListSize() {
        return 1000;
    }

    default public String arrayTypeSuffix() {
        return "[]";
    }

    default public boolean isIdFetchableByKeyUpdate() {
        return false;
    }

    default public boolean isInsertedIdReturningRequired() {
        return false;
    }

    default public boolean isExplicitBatchRequired() {
        return false;
    }

    default public boolean isBatchDumb() {
        return false;
    }

    default public boolean isUpsertSupported() {
        return false;
    }

    default public boolean isNoIdUpsertSupported() {
        return this.isUpsertSupported();
    }

    default public boolean isUpsertWithOptimisticLockSupported() {
        return false;
    }

    default public boolean isUpsertWithMultipleUniqueConstraintSupported() {
        return true;
    }

    default public boolean isUpsertWithNullableKeySupported() {
        return false;
    }

    default public boolean isTransactionAbortedByError() {
        return false;
    }

    default public boolean isBatchUpdateExceptionUnreliable() {
        return false;
    }

    public void update(UpdateContext var1);

    public void upsert(UpsertContext var1);

    default public void renderLPad(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expression, Ast length, Ast padString) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("lpad(")).ast(expression, currentPrecedence)).sql(", ")).ast(length, currentPrecedence)).sql(", ")).ast(padString, currentPrecedence)).sql(")");
    }

    default public void renderRPad(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expression, Ast length, Ast padString) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("rpad(")).ast(expression, currentPrecedence)).sql(", ")).ast(length, currentPrecedence)).sql(", ")).ast(padString, currentPrecedence)).sql(")");
    }

    default public void renderPosition(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast subStrAst, Ast expressionAst, @Nullable Ast startAst) {
        if (startAst != null) {
            throw new IllegalArgumentException("The dialect \"" + this.getClass().getName() + "\" does not support the third `start` parameter of `position`");
        }
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("position(")).ast(expressionAst, currentPrecedence)).sql(" in ")).ast(subStrAst, currentPrecedence)).sql(")");
    }

    default public void renderLeft(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast lengthAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("left(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(lengthAst, currentPrecedence)).sql(")");
    }

    default public void renderRight(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast lengthAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("right(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(lengthAst, currentPrecedence)).sql(")");
    }

    default public void renderSubString(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast startAst, @Nullable Ast lengthAst) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("substring(")).ast(expressionAst, currentPrecedence)).sql(", ")).ast(startAst, currentPrecedence);
        if (lengthAst != null) {
            ((AbstractSqlBuilder)builder.sql(", ")).ast(lengthAst, currentPrecedence);
        }
        builder.sql(")");
    }

    default public void renderTimePlus(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast valueAst, SqlTimeUnit timeUnit) {
        builder.sql("dateadd(");
        switch (timeUnit) {
            case NANOSECONDS: 
            case MICROSECONDS: 
            case MILLISECONDS: {
                builder.sql("millisecond, ");
                break;
            }
            case SECONDS: {
                builder.sql("second, ");
                break;
            }
            case MINUTES: {
                builder.sql("minute, ");
                break;
            }
            case HOURS: {
                builder.sql("hour, ");
                break;
            }
            case DAYS: {
                builder.sql("day, ");
                break;
            }
            case WEEKS: {
                builder.sql("week, ");
                break;
            }
            case MONTHS: 
            case QUARTERS: {
                builder.sql("month, ");
                break;
            }
            case YEARS: 
            case DECADES: 
            case CENTURIES: {
                builder.sql("year, ");
                break;
            }
            default: {
                throw new IllegalStateException("Time plus/minus by unit \"" + (Object)((Object)timeUnit) + "\" is not supported by \"" + this.getClass().getName() + "\"");
            }
        }
        builder.ast(valueAst, 0);
        switch (timeUnit) {
            case NANOSECONDS: {
                builder.sql(" / 1000000");
                break;
            }
            case MICROSECONDS: {
                builder.sql(" / 1000");
                break;
            }
            case QUARTERS: {
                builder.sql(" * 3");
                break;
            }
            case DECADES: {
                builder.sql(" * 10");
                break;
            }
            case CENTURIES: {
                builder.sql(" * 100");
            }
        }
        builder.sql(", ");
        builder.ast(expressionAst, 0);
        builder.sql(")");
    }

    default public void renderTimeDiff(AbstractSqlBuilder<?> builder, int currentPrecedence, Ast expressionAst, Ast otherAst, SqlTimeUnit timeUnit) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("(")).ast(expressionAst, 3)).sql(" - ")).ast(otherAst, 3)).sql(")");
        switch (timeUnit) {
            case NANOSECONDS: {
                builder.sql(" * 86400000000000");
                break;
            }
            case MICROSECONDS: {
                builder.sql(" * 86400000000");
                break;
            }
            case MILLISECONDS: {
                builder.sql(" * 86400000");
                break;
            }
            case SECONDS: {
                builder.sql(" * 86400");
                break;
            }
            case MINUTES: {
                builder.sql(" * 1440");
                break;
            }
            case HOURS: {
                builder.sql(" * 24");
                break;
            }
            case DAYS: {
                break;
            }
            case WEEKS: {
                builder.sql(" / 7");
                break;
            }
            case MONTHS: {
                builder.sql(" / 30.44");
                break;
            }
            case QUARTERS: {
                builder.sql(" / 91.31");
                break;
            }
            case YEARS: {
                builder.sql(" / 365.24");
                break;
            }
            case DECADES: {
                builder.sql(" / 3652.4");
                break;
            }
            case CENTURIES: {
                builder.sql(" / 36524");
            }
        }
    }

    default public Timestamp getTimestamp(ResultSet rs, int col) throws SQLException {
        return rs.getTimestamp(col);
    }

    public void renderForUpdate(AbstractSqlBuilder<?> var1, ForUpdate var2);

    public static interface UpsertContext {
        public boolean hasUpdatedColumns();

        public boolean hasOptimisticLock();

        public boolean hasGeneratedId();

        public boolean isUpdateIgnored();

        public boolean isComplete();

        public List<ValueGetter> getConflictGetters();

        public UpsertContext sql(String var1);

        public UpsertContext sql(ValueGetter var1);

        public UpsertContext enter(AbstractSqlBuilder.ScopeType var1);

        public UpsertContext separator();

        public UpsertContext leave();

        public UpsertContext appendTableName();

        public UpsertContext appendInsertedColumns(String var1);

        public UpsertContext appendConflictColumns();

        public UpsertContext appendInsertingValues();

        public UpsertContext appendUpdatingAssignments(String var1, String var2);

        public UpsertContext appendOptimisticLockCondition(String var1);

        public UpsertContext appendGeneratedId();
    }

    public static interface UpdateContext {
        public boolean isUpdatedByKey();

        public UpdateContext sql(String var1);

        public UpdateContext sql(ValueGetter var1);

        public UpdateContext enter(AbstractSqlBuilder.ScopeType var1);

        public UpdateContext separator();

        public UpdateContext leave();

        public UpdateContext appendTableName();

        public UpdateContext appendAssignments();

        public UpdateContext appendPredicates();

        public UpdateContext appendId();
    }
}

