/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class InvalidateMessage
implements Serializable {
    @NotNull
    UUID trackerId;
    @NotNull
    String typeName;
    @Nullable
    String propName;
    @NotNull
    Collection<?> ids;
    private transient ImmutableType type;

    InvalidateMessage(@NotNull UUID trackerId, @NotNull CacheTracker.InvalidateEvent event) {
        this.trackerId = trackerId;
        this.typeName = event.getType().toString();
        this.propName = event.getProp() != null ? event.getProp().getName() : null;
        this.ids = event.getIds();
    }

    public InvalidateMessage(@NotNull UUID trackerId, @NotNull String typeName, @Nullable String propName) {
        this.trackerId = trackerId;
        this.typeName = typeName;
        this.propName = propName;
    }

    ImmutableType getType() {
        ImmutableType type = this.type;
        if (type == null) {
            Class<?> javaType;
            try {
                javaType = Class.forName(this.typeName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot resolve the type name \"" + this.typeName + "\"");
            }
            this.type = type = ImmutableType.get(javaType);
        }
        return type;
    }

    CacheTracker.InvalidateEvent toEvent() {
        if (this.propName != null) {
            ImmutableProp prop = this.getType().getProp(this.propName);
            return new CacheTracker.InvalidateEvent(prop, this.ids);
        }
        return new CacheTracker.InvalidateEvent(this.getType(), this.ids);
    }

    static class Deserializer
    extends StdDeserializer<InvalidateMessage> {
        protected Deserializer() {
            super(InvalidateMessage.class);
        }

        public InvalidateMessage deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            UUID trackerId = UUID.fromString(node.get("trackerId").asText());
            String typeName = node.get("typeName").asText();
            String propName = node.get("propName").isNull() ? null : node.get("propName").asText();
            InvalidateMessage message = new InvalidateMessage(trackerId, typeName, propName);
            ImmutableProp idProp = message.getType().getIdProp();
            message.ids = (Collection)ctx.readTreeAsValue(node.get("ids"), (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)idProp.getReturnClass())));
            return message;
        }
    }

    static class Serializer
    extends StdSerializer<InvalidateMessage> {
        Serializer() {
            super(InvalidateMessage.class);
        }

        public void serialize(InvalidateMessage value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("trackerId", value.trackerId.toString());
            gen.writeStringField("typeName", value.typeName);
            gen.writeStringField("propName", value.propName);
            gen.writeObjectField("ids", value.ids);
            gen.writeEndObject();
        }
    }
}

