/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query.specification;

import java.util.function.Supplier;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.specification.PredicateApplier;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;

public class SpecificationArgs<E, T extends TableLike<E>> {
    private final PredicateApplier applier;
    private final T table;
    private final AbstractMutableStatementImpl query;

    public SpecificationArgs(PredicateApplier applier) {
        this.applier = applier;
        this.table = applier.getQuery().getTable();
        this.query = this.getApplier().getQuery();
    }

    public T getTable() {
        return this.table;
    }

    public SpecificationArgs<E, T> where(Predicate ... predicates) {
        this.query.where(predicates);
        return this;
    }

    public SpecificationArgs<E, T> where(boolean condition, Predicate predicate) {
        this.query.whereIf(condition, predicate);
        return this;
    }

    @Deprecated
    public SpecificationArgs<E, T> whereIf(boolean condition, Predicate predicate) {
        this.query.whereIf(condition, predicate);
        return this;
    }

    public SpecificationArgs<E, T> whereIf(boolean condition, Supplier<Predicate> block) {
        this.query.whereIf(condition, block);
        return this;
    }

    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return this.query.createSubQuery(table);
    }

    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        return this.query.createAssociationSubQuery(table);
    }

    public PredicateApplier getApplier() {
        return this.applier;
    }

    public <XE, XT extends Table<XE>> SpecificationArgs<XE, XT> child() {
        return new SpecificationArgs<E, T>(this.applier);
    }
}

