/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.impl.query.MergedTypedRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedRootQueryImplementor;
import org.babyfish.jimmer.sql.exception.EmptyResultException;
import org.babyfish.jimmer.sql.exception.TooManyResultsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypedRootQuery<R>
extends Executable<List<R>> {
    @SafeVarargs
    public static <R> TypedRootQuery<R> union(TypedRootQuery<R> ... queries) {
        return MergedTypedRootQueryImpl.of("union", queries);
    }

    @SafeVarargs
    public static <R> TypedRootQuery<R> unionAll(TypedRootQuery<R> ... queries) {
        return MergedTypedRootQueryImpl.of("union all", queries);
    }

    @SafeVarargs
    public static <R> TypedRootQuery<R> minus(TypedRootQuery<R> ... queries) {
        return MergedTypedRootQueryImpl.of("minus", queries);
    }

    @SafeVarargs
    public static <R> TypedRootQuery<R> intersect(TypedRootQuery<R> ... queries) {
        return MergedTypedRootQueryImpl.of("intersect", queries);
    }

    @Deprecated
    default public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return TypedRootQuery.union(this, other);
    }

    @Deprecated
    default public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return TypedRootQuery.unionAll(this, other);
    }

    @Deprecated
    default public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return TypedRootQuery.minus(this, other);
    }

    @Deprecated
    default public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return TypedRootQuery.intersect(this, other);
    }

    default public R fetchOne() {
        return this.fetchOne(null);
    }

    default public R fetchOne(Connection con) {
        List list;
        List list2 = list = this instanceof TypedRootQueryImplementor ? (List)((TypedRootQueryImplementor)this).withLimit(2).execute(con) : (List)this.execute(con);
        if (list.isEmpty()) {
            throw new EmptyResultException();
        }
        if (list.size() > 1) {
            throw new TooManyResultsException();
        }
        return (R)list.get(0);
    }

    @Nullable
    default public R fetchOneOrNull() {
        return this.fetchOneOrNull(null);
    }

    @Nullable
    default public R fetchOneOrNull(Connection con) {
        List list;
        List list2 = list = this instanceof TypedRootQueryImplementor ? (List)((TypedRootQueryImplementor)this).withLimit(2).execute(con) : (List)this.execute(con);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new TooManyResultsException();
        }
        return (R)list.get(0);
    }

    default public R fetchFirst() {
        return this.fetchFirst(null);
    }

    default public R fetchFirst(Connection con) {
        List list;
        List list2 = list = this instanceof TypedRootQueryImplementor ? (List)((TypedRootQueryImplementor)this).withLimit(1).execute(con) : (List)this.execute(con);
        if (list.isEmpty()) {
            throw new EmptyResultException();
        }
        return (R)list.get(0);
    }

    @Nullable
    default public R fetchFirstOrNull() {
        return this.fetchFirstOrNull(null);
    }

    @Nullable
    default public R fetchFirstOrNull(Connection con) {
        List list;
        List list2 = list = this instanceof TypedRootQueryImplementor ? (List)((TypedRootQueryImplementor)this).withLimit(1).execute(con) : (List)this.execute(con);
        if (list.isEmpty()) {
            return null;
        }
        return (R)list.get(0);
    }

    @NotNull
    default public Optional<R> fetchOptional() {
        return Optional.ofNullable(this.fetchOneOrNull());
    }

    @NotNull
    default public Optional<R> fetchOptional(Connection con) {
        return Optional.ofNullable(this.fetchOneOrNull(con));
    }

    default public <X> List<X> map(Function<R, X> mapper) {
        return this.map(null, mapper);
    }

    public <X> List<X> map(Connection var1, Function<R, X> var2);

    default public void forEach(Consumer<R> consumer) {
        this.forEach(null, -1, consumer);
    }

    default public void forEach(Connection con, Consumer<R> consumer) {
        this.forEach(con, -1, consumer);
    }

    default public void forEach(int batchSize, Consumer<R> consumer) {
        this.forEach(null, batchSize, consumer);
    }

    public void forEach(Connection var1, int var2, Consumer<R> var3);
}

