/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.sql.Connection;
import java.util.List;
import java.util.function.BiFunction;
import org.babyfish.jimmer.Page;
import org.babyfish.jimmer.Slice;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.query.LockMode;
import org.babyfish.jimmer.sql.ast.query.LockWait;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.PageFactory;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigurableRootQuery<T extends TableLike<?>, R>
extends TypedRootQuery<R> {
    default public long fetchUnlimitedCount() {
        return this.fetchUnlimitedCount(null);
    }

    default public long fetchUnlimitedCount(Connection con) {
        return (Long)((List)this.reselect((q, t) -> q.select(Expression.rowCount())).withoutSortingAndPaging().execute(con)).get(0);
    }

    default public boolean exists() {
        return this.exists(null);
    }

    default public boolean exists(Connection con) {
        return !((List)this.limit(1, 0L).reselect((q, t) -> q.select(Expression.constant(1))).execute(con)).isEmpty();
    }

    @NotNull
    default public <P> P fetchPage(int pageIndex, int pageSize, PageFactory<R, P> pageFactory) {
        return this.fetchPage(pageIndex, pageSize, null, pageFactory);
    }

    @NotNull
    public <P> P fetchPage(int var1, int var2, Connection var3, PageFactory<R, P> var4);

    @NotNull
    default public Page<R> fetchPage(int pageIndex, int pageSize) {
        return this.fetchPage(pageIndex, pageSize, null, PageFactory.standard());
    }

    @NotNull
    default public Page<R> fetchPage(int pageIndex, int pageSize, Connection con) {
        return this.fetchPage(pageIndex, pageSize, con, PageFactory.standard());
    }

    public Slice<R> fetchSlice(int var1, int var2, @Nullable Connection var3);

    default public Slice<R> fetchSlice(int limit, int offset) {
        return this.fetchSlice(limit, offset, null);
    }

    public <X> ConfigurableRootQuery<T, X> reselect(BiFunction<MutableRootQuery<T>, T, ConfigurableRootQuery<T, X>> var1);

    public ConfigurableRootQuery<T, R> distinct();

    public ConfigurableRootQuery<T, R> limit(int var1);

    public ConfigurableRootQuery<T, R> offset(long var1);

    public ConfigurableRootQuery<T, R> limit(int var1, long var2);

    public ConfigurableRootQuery<T, R> withoutSortingAndPaging();

    @Nullable
    public ConfigurableRootQuery<T, R> reverseSorting();

    public ConfigurableRootQuery<T, R> setReverseSortOptimizationEnabled(boolean var1);

    default public ConfigurableRootQuery<T, R> forUpdate() {
        return this.forUpdate(true);
    }

    public ConfigurableRootQuery<T, R> forUpdate(boolean var1);

    public ConfigurableRootQuery<T, R> forUpdate(LockMode var1, LockWait var2);

    public ConfigurableRootQuery<T, R> hint(@Nullable String var1);
}

