/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpsertMask<E> {
    private final ImmutableType type;
    private final List<List<ImmutableProp>> insertablePaths;
    private final List<List<ImmutableProp>> updatablePaths;

    private UpsertMask(ImmutableType type) {
        this.type = type;
        this.insertablePaths = null;
        this.updatablePaths = null;
    }

    private UpsertMask(ImmutableType type, List<List<ImmutableProp>> insertablePaths, List<List<ImmutableProp>> updatablePaths) {
        this.type = type;
        this.insertablePaths = insertablePaths;
        this.updatablePaths = updatablePaths;
    }

    private UpsertMask(UpsertMask<E> base, List<ImmutableProp> insertablePath, List<ImmutableProp> updatablePath) {
        this.type = base.type;
        this.insertablePaths = UpsertMask.addPath(base.insertablePaths, insertablePath);
        this.updatablePaths = UpsertMask.addPath(base.updatablePaths, updatablePath);
    }

    public static <E> UpsertMask<E> of(Class<E> type) {
        ImmutableType immutableType = ImmutableType.get(type);
        if (!immutableType.isEntity()) {
            throw new IllegalArgumentException("The type \"" + type + "\" is not entity");
        }
        return new UpsertMask<E>(immutableType);
    }

    public UpsertMask<E> forbidInsert() {
        if (this.insertablePaths != null && this.insertablePaths.isEmpty()) {
            return this;
        }
        return new UpsertMask<E>(this.type, Collections.emptyList(), this.updatablePaths);
    }

    public UpsertMask<E> forbidUpdate() {
        if (this.updatablePaths != null && this.updatablePaths.isEmpty()) {
            return this;
        }
        return new UpsertMask<E>(this.type, this.insertablePaths, Collections.emptyList());
    }

    public UpsertMask<E> addInsertableProp(ImmutableProp prop) {
        return this.addInsertablePath(prop);
    }

    public UpsertMask<E> addInsertableProp(TypedProp.Single<E, ?> prop) {
        return this.addInsertablePath(prop, new TypedProp.Single[0]);
    }

    public UpsertMask<E> addInsertablePath(ImmutableProp ... props) {
        return this.addInsertablePath0(new ArrayList<ImmutableProp>(Arrays.asList(props)));
    }

    public UpsertMask<E> addInsertablePath(TypedProp.Single<E, ?> prop, TypedProp.Single<?, ?> ... embeddedProps) {
        return this.addInsertablePath0(UpsertMask.toList(prop, embeddedProps));
    }

    public UpsertMask<E> addUpdatableProp(ImmutableProp prop) {
        return this.addUpdatablePath(prop);
    }

    public UpsertMask<E> addUpdatableProp(TypedProp.Single<E, ?> prop) {
        return this.addUpdatablePath(prop, new TypedProp.Single[0]);
    }

    public UpsertMask<E> addUpdatablePath(ImmutableProp ... props) {
        return this.addUpdatablePath0(new ArrayList<ImmutableProp>(Arrays.asList(props)));
    }

    public UpsertMask<E> addUpdatablePath(TypedProp.Single<E, ?> prop, TypedProp.Single<?, ?> ... embeddedProps) {
        return this.addUpdatablePath0(UpsertMask.toList(prop, embeddedProps));
    }

    @NotNull
    public ImmutableType getType() {
        return this.type;
    }

    @Nullable
    public List<List<ImmutableProp>> getInsertablePaths() {
        return this.insertablePaths;
    }

    @Nullable
    public List<List<ImmutableProp>> getUpdatablePaths() {
        return this.updatablePaths;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpsertMask {entityType = \"").append(this.type).append("\"");
        if (this.insertablePaths != null) {
            builder.append(", insertablePaths=[");
            this.appendPaths(builder, this.insertablePaths);
            builder.append(']');
        }
        if (this.updatablePaths != null) {
            builder.append(", updatablePaths=[");
            this.appendPaths(builder, this.updatablePaths);
            builder.append(']');
        }
        builder.append("}");
        return builder.toString();
    }

    private UpsertMask<E> addInsertablePath0(List<ImmutableProp> props) {
        this.validateProps(props);
        return new UpsertMask<E>(this, props, null);
    }

    private UpsertMask<E> addUpdatablePath0(List<ImmutableProp> props) {
        this.validateProps(props);
        return new UpsertMask<E>(this, null, props);
    }

    private void validateProps(List<ImmutableProp> props) {
        ImmutableType type = this.type;
        int len = props.size();
        if (len == 0) {
            throw new IllegalArgumentException("path cannot be empty");
        }
        for (int i = 0; i < len; ++i) {
            ImmutableProp prop = props.get(i);
            if (type == null) {
                throw new IllegalArgumentException("Cannot access the property \"" + prop + "\" based on the existing path \"" + this.path(props, i) + "\" because the path is not embeddable type");
            }
            if (prop.getDeclaringType() != type) {
                throw new IllegalArgumentException("Cannot access the property \"" + prop + "\" based on the existing path \"" + this.path(props, i) + "\", the declaring type must be \"" + type + "\"");
            }
            type = prop.getTargetType();
            if (type == null || !type.isEntity()) continue;
            type = type.getIdProp().getTargetType();
        }
    }

    private String path(List<ImmutableProp> props, int end) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        for (int i = 0; i < end; ++i) {
            ImmutableProp prop = props.get(i);
            builder.append("->").append(prop.getName());
            if (!prop.isReference(TargetLevel.ENTITY)) continue;
            builder.append("Id");
        }
        return builder.toString();
    }

    private static List<List<ImmutableProp>> addPath(List<List<ImmutableProp>> paths, List<ImmutableProp> path) {
        if (path == null) {
            return paths;
        }
        ArrayList<List<ImmutableProp>> newPaths = new ArrayList<List<ImmutableProp>>((paths != null ? paths.size() : 0) + 1);
        if (paths != null) {
            newPaths.addAll(paths);
        }
        newPaths.add(Collections.unmodifiableList(path));
        return Collections.unmodifiableList(newPaths);
    }

    private static List<ImmutableProp> toList(TypedProp.Single<?, ?> prop, TypedProp.Single<?, ?>[] embeddedProps) {
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>(1 + (embeddedProps != null ? embeddedProps.length : 0));
        props.add(prop.unwrap());
        if (embeddedProps != null) {
            for (TypedProp.Single<?, ?> embeddedProp : embeddedProps) {
                props.add(embeddedProp.unwrap());
            }
        }
        return props;
    }

    private void appendPaths(StringBuilder builder, List<List<ImmutableProp>> paths) {
        boolean addComma = false;
        for (List<ImmutableProp> path : paths) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(this.path(path, path.size()));
        }
    }
}

