/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.mutation.AbstractMutationResult;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.MutationResultItem;
import org.jetbrains.annotations.NotNull;

public class SimpleSaveResult<E>
extends AbstractMutationResult
implements MutationResultItem<E> {
    final E originalEntity;
    final E modifiedEntity;

    public SimpleSaveResult(Map<AffectedTable, Integer> affectedRowCountMap, E originalEntity, E modifiedEntity) {
        super(affectedRowCountMap);
        this.originalEntity = originalEntity;
        this.modifiedEntity = modifiedEntity;
    }

    @Override
    @NotNull
    public E getOriginalEntity() {
        return this.originalEntity;
    }

    @Override
    @NotNull
    public E getModifiedEntity() {
        return this.modifiedEntity;
    }

    public int hashCode() {
        int hash = this.affectedRowCountMap.hashCode();
        hash = hash * 31 + System.identityHashCode(this.originalEntity);
        hash = hash * 31 + System.identityHashCode(this.modifiedEntity);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSaveResult that = (SimpleSaveResult)o;
        return this.affectedRowCountMap.equals(that.affectedRowCountMap) && this.originalEntity == that.originalEntity && this.modifiedEntity == that.modifiedEntity;
    }

    public String toString() {
        return "SimpleSaveResult{totalAffectedRowCount=" + this.totalAffectedRowCount + ", affectedRowCountMap=" + this.affectedRowCountMap + ", originalEntity=" + this.originalEntity + ", modifiedEntity=" + this.modifiedEntity + '}';
    }

    public <V extends org.babyfish.jimmer.View<E>> View<E, V> toView(Function<E, V> converter) {
        return new View<E, org.babyfish.jimmer.View>(this.affectedRowCountMap, this.originalEntity, this.modifiedEntity, (org.babyfish.jimmer.View)converter.apply(this.modifiedEntity));
    }

    public static class View<E, V extends org.babyfish.jimmer.View<E>>
    extends SimpleSaveResult<E> {
        private final V modifiedView;

        View(Map<AffectedTable, Integer> affectedRowCountMap, E originalEntity, E modifiedEntity, V modifiedView) {
            super(affectedRowCountMap, originalEntity, modifiedEntity);
            this.modifiedView = modifiedView;
        }

        public V getModifiedView() {
            return this.modifiedView;
        }

        @Override
        public String toString() {
            return "SimpleSaveResult.View{totalAffectedRowCount=" + this.totalAffectedRowCount + ", affectedRowCountMap=" + this.affectedRowCountMap + ", originalEntity=" + this.originalEntity + ", modifiedView=" + this.modifiedView + '}';
        }
    }
}

