/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.mutation.AbstractMutationResult;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.MutationResultItem;
import org.jetbrains.annotations.NotNull;

public class BatchSaveResult<E>
extends AbstractMutationResult {
    final List<Item<E>> items;

    public BatchSaveResult(Map<AffectedTable, Integer> affectedRowMap, List<Item<E>> items) {
        super(affectedRowMap);
        this.items = Collections.unmodifiableList(items);
    }

    public List<Item<E>> getItems() {
        return this.items;
    }

    public int hashCode() {
        return Objects.hash(this.affectedRowCountMap, this.items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchSaveResult that = (BatchSaveResult)o;
        return this.affectedRowCountMap.equals(that.affectedRowCountMap) && this.items.equals(that.items);
    }

    public String toString() {
        return "BatchSaveResult{totalAffectedRowCount=" + this.totalAffectedRowCount + ", affectedRowCountMap=" + this.affectedRowCountMap + ", items=" + this.items + '}';
    }

    public <V extends org.babyfish.jimmer.View<E>> View<E, V> toView(Function<E, V> converter) {
        ArrayList viewItems = new ArrayList(this.items.size());
        for (Item<E> item : this.items) {
            View.ViewItem viewItem = new View.ViewItem(item.originalEntity, item.modifiedEntity, (org.babyfish.jimmer.View)converter.apply(item.modifiedEntity));
            viewItems.add(viewItem);
        }
        return new View((Map<AffectedTable, Integer>)this.affectedRowCountMap, viewItems);
    }

    public static class Item<E>
    implements MutationResultItem<E> {
        final E originalEntity;
        final E modifiedEntity;

        public Item(E originalEntity, E modifiedEntity) {
            this.originalEntity = originalEntity;
            this.modifiedEntity = modifiedEntity;
        }

        @Override
        @NotNull
        public E getOriginalEntity() {
            return this.originalEntity;
        }

        @Override
        @NotNull
        public E getModifiedEntity() {
            return this.modifiedEntity;
        }

        public String toString() {
            return "Item{originalEntity=" + this.originalEntity + ", modifiedEntity=" + this.modifiedEntity + '}';
        }
    }

    public static class View<E, V extends org.babyfish.jimmer.View<E>>
    extends BatchSaveResult<E> {
        View(Map<AffectedTable, Integer> affectedRowMap, List<ViewItem<E, V>> items) {
            super(affectedRowMap, items);
        }

        public List<ViewItem<E, V>> getViewItems() {
            return this.items;
        }

        @Override
        public String toString() {
            return "BatchSaveResult.View{, affectedRowCountMap=" + this.affectedRowCountMap + ", totalAffectedRowCount=" + this.totalAffectedRowCount + ", items=" + this.items + '}';
        }

        public static class ViewItem<E, V>
        extends Item<E> {
            private final V modifiedView;

            public ViewItem(E originalEntity, E modifiedEntity, V modifiedView) {
                super(originalEntity, modifiedEntity);
                this.modifiedView = modifiedView;
            }

            @NotNull
            public V getModifiedView() {
                return this.modifiedView;
            }

            @Override
            public String toString() {
                return "Item{originalEntity=" + this.originalEntity + ", modifiedView=" + this.modifiedView + '}';
            }
        }
    }
}

