/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.value;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.value.AbstractPropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.jetbrains.annotations.Nullable;

class ScalarPropertyGetter
extends AbstractPropertyGetter {
    private ScalarPropertyGetter(@Nullable String alias, ImmutableProp prop, ValueGetter valueGetter) {
        super(alias, prop, valueGetter);
    }

    @Override
    public Object get(Object value) {
        ImmutableSpi spi = (ImmutableSpi)value;
        PropId propId = this.prop.getId();
        if (spi.__isLoaded(propId) && !this.prop.isLogicalDeleted()) {
            return this.valueGetter.get(spi.__get(propId));
        }
        Ref valueRef = this.prop.getDefaultValueRef();
        if (valueRef != null) {
            Object v = valueRef.getValue();
            Object evaluatedValue = v instanceof Supplier ? ((Supplier)v).get() : v;
            return this.valueGetter.get(evaluatedValue);
        }
        return spi.__get(propId);
    }

    @Override
    String toStringPrefix() {
        return this.prop.getName();
    }

    static List<PropertyGetter> getters(@Nullable String alias, ImmutableProp prop, List<ValueGetter> valueGetters) {
        ArrayList<PropertyGetter> propertyGetters = new ArrayList<PropertyGetter>(valueGetters.size());
        for (ValueGetter valueGetter : valueGetters) {
            propertyGetters.add(new ScalarPropertyGetter(alias, prop, valueGetter));
        }
        return propertyGetters;
    }
}

