/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcattedIterator<E>
implements Iterator<E> {
    private final Iterator<E>[] iterators;
    private int index;
    private Iterator<E> currentItr;

    private ConcattedIterator(Iterator<E>[] iterators) {
        this.iterators = iterators;
        this.locate();
    }

    @SafeVarargs
    public static <E> Iterator<E> of(Iterator<E> ... iterators) {
        return new ConcattedIterator<E>(iterators);
    }

    @Override
    public boolean hasNext() {
        return this.currentItr != null;
    }

    @Override
    public E next() {
        Iterator<E> curItr = this.currentItr;
        if (curItr == null) {
            throw new NoSuchElementException();
        }
        E e = curItr.next();
        if (!curItr.hasNext()) {
            this.locate();
        }
        return e;
    }

    private void locate() {
        for (Iterator<E> itr : this.iterators) {
            if (!itr.hasNext()) continue;
            this.currentItr = itr;
            return;
        }
        this.currentItr = null;
    }
}

