/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import org.babyfish.jimmer.impl.org.objectweb.asm.tree.InsnList;
import org.babyfish.jimmer.sql.ast.impl.table.InsnListUtils;

public class WeakJoinLambda {
    private final InsnList instructions;
    private final Class<?> sourceType;
    private final Class<?> targetType;
    private int hashCache;

    public WeakJoinLambda(InsnList instructions, Class<?> sourceType, Class<?> targetType) {
        this.instructions = instructions;
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public Class<?> getSourceType() {
        return this.sourceType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public int hashCode() {
        int h = this.hashCache;
        if (h == 0) {
            h = this.hashCode0();
            if (h == 0) {
                h = -1;
            }
            this.hashCache = h;
        }
        return h;
    }

    private int hashCode0() {
        int result = this.sourceType.hashCode();
        result = 31 * result + this.targetType.hashCode();
        result = 31 * result + InsnListUtils.hashCode(this.instructions);
        return result;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof WeakJoinLambda)) {
            return false;
        }
        WeakJoinLambda that = (WeakJoinLambda)o;
        return this.sourceType.equals(that.sourceType) && this.targetType.equals(that.targetType) && InsnListUtils.equals(this.instructions, that.instructions);
    }

    public String toString() {
        return "WeakJoinMetadata{instructions=" + this.instructions + ", sourceType=" + this.sourceType + ", targetType=" + this.targetType + '}';
    }
}

