/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AssociatedPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExampleImpl;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbols;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.JWeakJoinLambdaFactory;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTypeMergeScope;
import org.babyfish.jimmer.sql.ast.impl.table.RealTableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableRowCountDestructive;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.fetcher.DtoMetadata;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TableImpl<E>
extends AbstractDataManager<Key, TableLikeImplementor<?>>
implements TableImplementor<E> {
    final AbstractMutableStatementImpl statement;
    final ImmutableType immutableType;
    final TableImpl<?> parent;
    final boolean isInverse;
    final ImmutableProp joinProp;
    final WeakJoinHandle weakJoinHandle;
    private final JoinType joinType;
    private final boolean fetch;
    @Nullable
    private final BaseTableOwner baseTableOwner;
    private Map<BaseTableOwner, TableImpl<E>> neighborMap;
    private RealTableImpl realTable;
    private boolean hasBaseTable;

    public TableImpl(AbstractMutableStatementImpl statement, ImmutableType immutableType, TableImpl<?> parent, boolean isInverse, ImmutableProp joinProp, WeakJoinHandle weakJoinHandle, JoinType joinType, boolean fetch) {
        if (statement == null) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent != null && immutableType instanceof AssociationType) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent == null != (joinProp == null && weakJoinHandle == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent != null && joinProp == null == (weakJoinHandle == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (weakJoinHandle != null && isInverse) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        this.statement = statement;
        this.immutableType = immutableType;
        this.parent = parent;
        this.isInverse = isInverse;
        this.joinProp = joinProp;
        this.weakJoinHandle = weakJoinHandle;
        this.joinType = joinType;
        this.fetch = fetch;
        this.baseTableOwner = parent != null ? parent.baseTableOwner : null;
    }

    private TableImpl(TableImpl<E> base, TableImpl<?> parent, @Nullable BaseTableOwner baseTableOwner) {
        this.statement = base.statement;
        this.immutableType = base.immutableType;
        this.parent = parent;
        this.isInverse = base.isInverse;
        this.joinProp = base.joinProp;
        this.weakJoinHandle = base.weakJoinHandle;
        this.joinType = base.joinType;
        this.fetch = base.fetch;
        this.neighborMap = base.neighborMap;
        this.baseTableOwner = baseTableOwner;
    }

    @Override
    public final ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public final AbstractMutableStatementImpl getStatement() {
        return this.statement;
    }

    @Override
    public final TableImplementor<?> getParent() {
        return this.parent;
    }

    @Override
    public final boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public final boolean isEmpty(java.util.function.Predicate<TableLikeImplementor<?>> filter) {
        if (this.isEmpty()) {
            return true;
        }
        if (filter == null) {
            return false;
        }
        for (TableLikeImplementor childTable : this) {
            if (!filter.test(childTable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isRemote() {
        return this.joinProp != null && this.joinProp.isRemote();
    }

    @Override
    public final ImmutableProp getJoinProp() {
        return this.joinProp;
    }

    @Override
    public final WeakJoinHandle getWeakJoinHandle() {
        return this.weakJoinHandle;
    }

    @Override
    public final JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public final RealTableImpl realTable(JoinTypeMergeScope scope) {
        return this.realTable0(scope, this.parent);
    }

    private RealTableImpl realTable0(JoinTypeMergeScope scope, TableImpl<?> parent) {
        RealTableImpl realTable = this.realTable;
        if (realTable == null) {
            realTable = parent == null ? new RealTableImpl(this) : parent.realTable(scope).child(scope, this);
            this.realTable = realTable;
        }
        return realTable;
    }

    public RealTableImpl tryGetRealTable() {
        return this.realTable;
    }

    @Override
    public Predicate eq(Table<E> other) {
        if (other.getImmutableType() != this.immutableType) {
            throw new IllegalArgumentException("Cannot compare tables of different types");
        }
        ImmutableProp idProp = this.immutableType.getIdProp();
        return this.get(idProp).eq((Object)other.get(idProp));
    }

    @Override
    public Predicate eq(Example<E> example) {
        return ((ExampleImpl)example).toPredicate(this);
    }

    @Override
    public Predicate eq(E example) {
        return this.eq((E)Example.of(example));
    }

    @Override
    public Predicate eq(View<E> view) {
        return this.eq((E)Example.of(view));
    }

    @Override
    public Predicate isNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNull();
    }

    @Override
    public Predicate isNotNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        return this.count(false);
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        if (this.immutableType instanceof AssociationType) {
            return this.get(((AssociationType)this.immutableType).getSourceProp().getName()).count();
        }
        return this.get(this.immutableType.getIdProp().getName()).count(distinct);
    }

    @Override
    public <X> PropExpression<X> get(String prop) {
        return this.get(this.immutableType.getProp(prop));
    }

    @Override
    public <X> PropExpression<X> get(ImmutableProp prop) {
        return this.get(prop, false);
    }

    @Override
    public <X> PropExpression<X> get(ImmutableProp prop, boolean rawId) {
        ImmutableProp idViewBaseProp;
        if (this.isRemote() && this.immutableType.getIdProp() != prop) {
            throw new IllegalArgumentException("The current table is remote so that only the id property \"" + this.immutableType.getIdProp() + "\" can be accessed");
        }
        if (prop.getDeclaringType() != this.immutableType) {
            if (!prop.getDeclaringType().isAssignableFrom(this.immutableType)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" does not belong to the current type \"" + this.immutableType + "\"");
            }
            prop = this.immutableType.getProp(prop.getName());
        }
        if ((idViewBaseProp = prop.getIdViewBaseProp()) != null && idViewBaseProp.isReference(TargetLevel.ENTITY)) {
            return this.joinImplementor(idViewBaseProp.getName(), idViewBaseProp.isNullable() ? JoinType.LEFT : JoinType.INNER).get(idViewBaseProp.getTargetType().getIdProp(), true);
        }
        return PropExpressionImpl.of(this, prop, rawId);
    }

    @Override
    public <X> PropExpression<X> getId() {
        return this.get(this.immutableType.getIdProp());
    }

    @Override
    public <X> PropExpression<X> getAssociatedId(String prop) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        return this.getAssociatedId(immutableProp);
    }

    @Override
    public <X> PropExpression<X> getAssociatedId(ImmutableProp prop) {
        TableImplementor<X> joinedTable = this.joinImplementor(prop, prop.isNullable() ? JoinType.LEFT : JoinType.INNER);
        return joinedTable.get(joinedTable.getImmutableType().getIdProp(), true);
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType, treatedAs));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType, treatedAs));
    }

    @Override
    public <X> PropExpression<X> inverseGetAssociatedId(ImmutableProp prop) {
        ImmutableProp oppositeProp = prop.getOpposite();
        TableImplementor<X> joinedTable = this.inverseJoinImplementor(prop, oppositeProp != null && oppositeProp.isNullable() ? JoinType.LEFT : JoinType.INNER);
        return joinedTable.get(joinedTable.getImmutableType().getIdProp(), true);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        return this.inverseJoin(ImmutableProps.join(targetTableType, backPropBlock));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        return this.inverseJoin(ImmutableProps.join(targetTableType, backPropBlock), joinType);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop) {
        return this.joinImplementor(this.immutableType.getProp(prop), JoinType.INNER, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(ImmutableProp prop) {
        return this.joinImplementor(prop, JoinType.INNER, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop, JoinType joinType) {
        return this.joinImplementor(this.immutableType.getProp(prop), joinType, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(ImmutableProp prop, JoinType joinType) {
        return this.joinImplementor(prop, joinType, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop, JoinType joinType, ImmutableType treatedAs) {
        return this.joinImplementor(this.immutableType.getProp(prop), joinType, treatedAs);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
        ImmutableProp manyToManyViewBaseProp;
        if (prop.getDeclaringType() != this.immutableType) {
            if (!prop.getDeclaringType().isAssignableFrom(this.immutableType)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" does not belong to the current type \"" + this.immutableType + "\"");
            }
            prop = this.immutableType.getProp(prop.getName());
        }
        if ((manyToManyViewBaseProp = prop.getManyToManyViewBaseProp()) != null) {
            return ((TableImpl)this.join0(false, manyToManyViewBaseProp, joinType)).join0(false, prop.getManyToManyViewBaseDeeperProp(), joinType);
        }
        if (!prop.isAssociation(TargetLevel.ENTITY)) {
            if (this.isRemote()) {
                throw new IllegalStateException("The current table is remote so that join is not supported");
            }
            if (prop.isTransient()) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be transient");
            }
            if (prop.isRemote() && prop.getMappedBy() != null) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be remote and reversed(with `mappedBy`)");
            }
            throw new IllegalArgumentException("\"" + prop + "\" is not association property of \"" + this.immutableType + "\"");
        }
        return this.join0(false, prop, joinType);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(ImmutableProp prop) {
        return this.inverseJoinImplementor(prop, JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(TypedProp.Association<?, ?> prop) {
        return this.inverseJoinImplementor(prop.unwrap(), JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return this.inverseJoinImplementor(prop.unwrap(), joinType);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(ImmutableProp backProp, JoinType joinType) {
        if (backProp.getTargetType() != this.immutableType) {
            throw new IllegalArgumentException("'" + backProp + "' is not back association property");
        }
        if (!backProp.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("'" + backProp + "' is not declared in entity");
        }
        ImmutableProp manyToManyViewBaseProp = backProp.getManyToManyViewBaseProp();
        if (manyToManyViewBaseProp != null) {
            return ((TableImpl)this.join0(true, backProp.getManyToManyViewBaseDeeperProp(), joinType)).join0(true, manyToManyViewBaseProp, joinType);
        }
        return this.join0(true, backProp, joinType);
    }

    private TableImplementor<?> join0(boolean isInverse, ImmutableProp prop, JoinType joinType) {
        if (prop.isTransient()) {
            throw new ExecutionException("Cannot join to '" + prop.getName() + "' because it's transient association");
        }
        if (isInverse && prop instanceof AssociationProp) {
            throw new ExecutionException("Cannot join to '" + prop + "' by inverse mode because it's property of association entity");
        }
        String joinName = !isInverse ? prop.getName() : (prop.getOpposite() != null ? prop.getOpposite().getName() : "inverse(" + prop + ")");
        if (prop.getMappedBy() != null) {
            return this.join1(joinName, !isInverse, prop.getMappedBy(), joinType);
        }
        return this.join1(joinName, isInverse, prop, joinType);
    }

    private TableImplementor<?> join1(String joinName, boolean isInverse, ImmutableProp prop, JoinType joinType) {
        Key key = new Key(joinName, joinType, null, false);
        TableImpl<E> joinedTable = (TableImpl<E>)this.getValue(key);
        if (joinedTable != null) {
            return joinedTable;
        }
        joinedTable = new TableImpl<E>(this.statement, isInverse ? prop.getDeclaringType() : prop.getTargetType(), this, isInverse, prop, null, joinType, false);
        this.putValue(key, joinedTable);
        return joinedTable;
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(Class<? extends WeakJoin<?, ?>> weakJoinType, JoinType joinType) {
        return this.weakJoinImplementor(WeakJoinHandle.of(weakJoinType), joinType);
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(Class<? extends Table<?>> targetTableType, JoinType joinType, WeakJoin<?, ?> weakJoinLambda) {
        return this.weakJoinImplementor(WeakJoinHandle.of(JWeakJoinLambdaFactory.get(weakJoinLambda), true, true, weakJoinLambda), joinType);
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(WeakJoinHandle handle, JoinType joinType) {
        return new TableImpl<E>(this.statement, ((WeakJoinHandle.EntityTableHandle)handle).getTargetType(), this, this.isInverse, null, handle, joinType, false);
    }

    @Override
    public <X extends BaseTable> X weakJoinImplementor(X targetBaseTable, WeakJoinHandle handle, JoinType joinType) {
        return (X)BaseTableSymbols.of((BaseTableSymbol)targetBaseTable, this, handle, joinType, null);
    }

    @Override
    public TableImplementor<?> joinFetchImplementor(ImmutableProp prop, BaseTableOwner baseTableOwner) {
        if (!prop.isAssociation(TargetLevel.PERSISTENT) || prop.isReferenceList(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("Cannot join fetch \"" + prop + "\" because it is not decorated by \"@" + ManyToOne.class.getName() + "\" or \"@" + OneToOne.class.getName() + "\"");
        }
        JoinType joinType = prop.isNullable() ? JoinType.LEFT : JoinType.INNER;
        Key key = new Key(prop.getName(), joinType, null, true);
        TableImpl<E> joinedTable = (TableImpl<E>)this.getValue(key);
        if (joinedTable != null) {
            return joinedTable;
        }
        ImmutableProp mappedBy = prop.getMappedBy();
        joinedTable = new TableImpl<E>(this.statement, prop.getTargetType(), this, mappedBy != null, mappedBy != null ? mappedBy : prop, null, joinType, true);
        this.putValue(key, joinedTable);
        return joinedTable;
    }

    @Override
    public boolean hasBaseTable() {
        return this.hasBaseTable;
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this;
        }
        if (this.immutableType != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("Illegal fetcher type, the entity type of current table is \"" + this + "\" but the fetcher type is \"" + fetcher.getImmutableType() + "\"");
        }
        return new FetcherSelectionImpl<E>(this, fetcher);
    }

    @Override
    public <V extends View<E>> Selection<V> fetch(Class<V> viewType) {
        if (viewType == null) {
            throw new IllegalArgumentException("The argument `staticType` cannot be null");
        }
        DtoMetadata metadata = DtoMetadata.of(viewType);
        Fetcher fetcher = metadata.getFetcher();
        if (this.immutableType != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("Illegal fetcher type, the entity type of current table is \"" + this + "\" but the static type is based on \"" + fetcher.getImmutableType() + "\"");
        }
        return new FetcherSelectionImpl<V>(this, fetcher, metadata.getConverter());
    }

    @Override
    public TableEx<E> asTableEx() {
        return (TableEx)TableProxies.wrap(this);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.visitTableReference(this.realTable(visitor.getAstContext()), null, false);
    }

    @Override
    public void renderJoinAsFrom(SqlBuilder builder, TableImplementor.RenderMode mode) {
        this.realTable(builder.getAstContext()).renderJoinAsFrom(builder, mode);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        AstContext astContext = builder instanceof SqlBuilder ? ((SqlBuilder)builder).getAstContext() : null;
        this.realTable(astContext).renderTo(builder, false);
    }

    @Override
    public void renderSelection(ImmutableProp prop, boolean rawId, AbstractSqlBuilder<?> builder, ColumnDefinition optionalDefinition, boolean withPrefix, Function<Integer, String> asBlock) {
        JoinTypeMergeScope scope = builder instanceof SqlBuilder ? ((SqlBuilder)builder).getAstContext().getJoinTypeMergeScope() : null;
        this.realTable(scope).renderSelection(prop, rawId, builder, optionalDefinition, withPrefix, asBlock);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.parent == null) {
            builder.append(this.immutableType.getJavaClass().getSimpleName());
        } else {
            builder.append(this.parent);
            if (this.isInverse) {
                ImmutableProp opposite = this.joinProp.getOpposite();
                if (opposite != null) {
                    builder.append('.').append(opposite.getName());
                } else {
                    builder.append("[\u2190 ").append(this.joinProp.getName()).append(']');
                }
            } else {
                if (this.joinProp != null) {
                    builder.append('.').append(this.joinProp.getName());
                }
                if (this.weakJoinHandle != null) {
                    builder.append('[').append(this.weakJoinHandle).append(']');
                }
            }
        }
        JoinType joinType = this.joinType;
        if (joinType != JoinType.INNER) {
            builder.append('(').append(joinType.name().toLowerCase()).append(')');
        }
        if (this.baseTableOwner != null) {
            builder.append(':').append(this.baseTableOwner);
        }
        return builder.toString();
    }

    @Override
    public TableRowCountDestructive getDestructive() {
        ImmutableProp prop;
        if (this.joinProp == null) {
            return TableRowCountDestructive.NONE;
        }
        if (this.isInverse) {
            prop = this.joinProp.getOpposite();
            if (prop == null) {
                return TableRowCountDestructive.BREAK_REPEATABILITY;
            }
        } else {
            prop = this.joinProp;
        }
        if (prop.isReferenceList(TargetLevel.PERSISTENT)) {
            return TableRowCountDestructive.BREAK_REPEATABILITY;
        }
        if (prop.isNullable() && this.joinType != JoinType.LEFT) {
            return TableRowCountDestructive.BREAK_ROW_COUNT;
        }
        return TableRowCountDestructive.NONE;
    }

    @Override
    public <XT extends Table<?>> Predicate exists(String prop, Function<XT, Predicate> block) {
        ImmutableProp joinProp = (ImmutableProp)this.immutableType.getProps().get(prop);
        if (joinProp == null) {
            throw new IllegalArgumentException("Illegal property name \"" + prop + "\", there is no such property \"" + this.immutableType + "\"");
        }
        return this.exists(joinProp, block);
    }

    @Override
    public <XT extends Table<?>> Predicate exists(ImmutableProp prop, Function<XT, Predicate> block) {
        return new AssociatedPredicate(this, prop, block);
    }

    @Override
    public boolean hasVirtualPredicate() {
        return false;
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        return this;
    }

    @Override
    @Nullable
    public BaseTableOwner getBaseTableOwner() {
        return this.baseTableOwner;
    }

    @Override
    public TableImpl<E> baseTableOwner(@Nullable BaseTableOwner baseTableOwner) {
        TableImpl<E> neighbor;
        if (Objects.equals(this.baseTableOwner, baseTableOwner)) {
            return this;
        }
        Map<BaseTableOwner, TableImpl<E>> neighborMap = this.neighborMap;
        if (neighborMap == null) {
            neighborMap = new HashMap<BaseTableOwner, TableImpl<E>>();
            neighborMap.put(this.baseTableOwner, this);
            this.neighborMap = neighborMap;
        }
        if ((neighbor = neighborMap.get(baseTableOwner)) != null) {
            return neighbor;
        }
        TableImplementor neighborParent = null;
        if (this.parent != null && baseTableOwner != null) {
            neighborParent = this.parent.baseTableOwner(baseTableOwner);
        }
        neighbor = new TableImpl<E>(this, (TableImpl<?>)neighborParent, baseTableOwner);
        neighborMap.put(baseTableOwner, neighbor);
        return neighbor;
    }

    public <T extends TableLikeImplementor<?>> T computedIfAbsent(Key key, Supplier<T> tableLikeSupplier) {
        TableLikeImplementor child = (TableLikeImplementor)this.getValue(key);
        if (child == null) {
            child = (TableLikeImplementor)tableLikeSupplier.get();
            this.putValue(key, child);
        }
        return (T)child;
    }

    @Override
    public void setHasBaseTable() {
        if (!this.hasBaseTable) {
            this.hasBaseTable = true;
            if (this.parent != null) {
                this.parent.setHasBaseTable();
            }
        }
    }

    static class Key {
        final String joinName;
        final JoinType joinType;
        final WeakJoinHandle weakJoinHandle;
        final boolean fetch;

        Key(String joinName, JoinType joinType, WeakJoinHandle weakJoinHandle, boolean fetch) {
            this.joinName = joinName;
            this.joinType = joinType;
            this.weakJoinHandle = weakJoinHandle;
            this.fetch = fetch;
        }

        public int hashCode() {
            int result = this.joinName.hashCode();
            result = 31 * result + this.joinType.hashCode();
            result = 32 * result + Boolean.hashCode(this.fetch);
            result = 31 * result + Objects.hashCode(this.weakJoinHandle);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key other = (Key)o;
            if (this.fetch != other.fetch) {
                return false;
            }
            if (!this.joinName.equals(other.joinName)) {
                return false;
            }
            if (this.joinType != other.joinType) {
                return false;
            }
            return Objects.equals(this.weakJoinHandle, other.weakJoinHandle);
        }

        public String toString() {
            return "Key{joinName='" + this.joinName + '\'' + ", joinType = " + this.joinType + ", weakJoinHandle=" + this.weakJoinHandle + ", fetch = " + this.fetch + "}";
        }
    }
}

