/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.BaseTableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTableFilters;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTypeMergeScope;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RealTableImpl
extends AbstractDataManager<RealTable.Key, RealTable>
implements RealTable {
    private final RealTable.Key key;
    private final TableLikeImplementor<?> owner;
    private final RealTableImpl parent;
    private final Predicate joinPredicate;
    private JoinType joinType;
    private Aliases aliases;

    RealTableImpl(TableLikeImplementor<?> owner) {
        this(new RealTable.Key(null, false, null, null), owner, null);
    }

    private RealTableImpl(RealTable.Key key, TableLikeImplementor<?> owner, RealTableImpl parent) {
        this.key = key;
        this.owner = owner;
        this.parent = parent;
        if (owner instanceof BaseTableImplementor) {
            BaseTableImplementor baseTableImpl = (BaseTableImplementor)owner;
            this.joinType = baseTableImpl.getJoinType();
            if (owner.getWeakJoinHandle() != null) {
                TableLikeImplementor<?> sourceImplementor = baseTableImpl.getParent();
                BaseTableSymbol sourceLike = sourceImplementor instanceof BaseTableImplementor ? ((BaseTableImplementor)sourceImplementor).toSymbol() : TableUtils.disableJoin(TableProxies.wrap((Table)((Object)sourceImplementor)), "For the weak join operation from a regular table to a base table, the strong join is not allowed on the regular table side (source side).");
                this.joinPredicate = owner.getWeakJoinHandle().createPredicate(sourceLike, baseTableImpl.toSymbol(), owner.getStatement());
            } else {
                this.joinPredicate = null;
            }
        } else {
            TableImpl tableImpl = (TableImpl)owner;
            this.joinType = tableImpl.getJoinType();
            this.joinPredicate = owner.getWeakJoinHandle() != null ? owner.getWeakJoinHandle().createPredicate(owner.getParent(), owner, owner.getStatement()) : null;
        }
    }

    @Override
    public final TableLikeImplementor<?> getTableLikeImplementor() {
        return this.owner;
    }

    @Override
    public final RealTable getParent() {
        return this.parent;
    }

    @Override
    public RealTable.Key getKey() {
        return this.key;
    }

    @Override
    public RealTable child(RealTable.Key key) {
        RealTableImpl child = (RealTableImpl)this.getValue(key);
        if (child != null) {
            if (child.joinType != this.owner.getJoinType()) {
                child.joinType = JoinType.INNER;
            }
            return child;
        }
        child = new RealTableImpl(key, this.owner, this);
        this.putValue(key, child);
        return child;
    }

    public RealTableImpl child(JoinTypeMergeScope scope, TableImpl<?> owner) {
        RealTable.Key key = new RealTable.Key(scope, owner.isInverse, owner.joinProp, owner.weakJoinHandle);
        RealTableImpl child = (RealTableImpl)this.getValue(key);
        if (child != null) {
            if (child.joinType != owner.getJoinType()) {
                child.joinType = JoinType.INNER;
            }
            return child;
        }
        child = new RealTableImpl(key, owner, this);
        this.putValue(key, child);
        return child;
    }

    public RealTableImpl child(JoinTypeMergeScope scope, BaseTableImplementor owner) {
        RealTable.Key key = new RealTable.Key(scope, false, null, owner.getWeakJoinHandle());
        RealTableImpl child = (RealTableImpl)this.getValue(key);
        if (child != null) {
            if (child.joinType != owner.getJoinType()) {
                child.joinType = JoinType.INNER;
            }
            return child;
        }
        child = new RealTableImpl(key, owner, this);
        this.putValue(key, child);
        return child;
    }

    @Override
    public final String getAlias() {
        return this.aliases().value;
    }

    @Override
    public final String getMiddleTableAlias() {
        return this.aliases().middleValue;
    }

    @Override
    public String getFinalAlias(ImmutableProp prop, boolean rawId, JSqlClientImplementor sqlClient) {
        if (!(this.owner instanceof TableImpl)) {
            return this.aliases().value;
        }
        TableImpl tableImpl = (TableImpl)this.owner;
        ImmutableProp joinProp = tableImpl.joinProp;
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        if (prop.isId() && joinProp != null && !(joinProp.getSqlTemplate() instanceof JoinTemplate) && (rawId || TableUtils.isRawIdAllowed(tableImpl, sqlClient))) {
            MiddleTable middleTable = joinProp.isMiddleTableDefinition() ? (MiddleTable)joinProp.getStorage(strategy) : null;
            boolean isInverse = tableImpl.isInverse;
            if (middleTable != null) {
                return this.aliases().middleValue;
            }
            if (!isInverse) {
                return this.parent.aliases().value;
            }
        }
        return this.aliases().value;
    }

    @Override
    @Nullable
    public BaseTableOwner getBaseTableOwner() {
        if (this.owner instanceof TableImplementor) {
            TableImplementor tableImplementor = (TableImplementor)this.owner;
            return tableImplementor.getBaseTableOwner();
        }
        return null;
    }

    @Override
    public void use(UseTableVisitor visitor) {
        if (this.joinPredicate != null) {
            ((Ast)((Object)this.joinPredicate)).accept(visitor);
        }
        for (RealTable childTable : this) {
            childTable.use(visitor);
        }
    }

    @Override
    public void renderJoinAsFrom(SqlBuilder builder, TableImplementor.RenderMode mode) {
        if (this.owner == null) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom can only be called base on joined tables");
        }
        if (mode == TableImplementor.RenderMode.NORMAL) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom does not accept render mode ALL");
        }
        TableUsedState usedState = builder.getAstContext().getTableUsedState(this);
        if (usedState != TableUsedState.NONE) {
            if (mode == TableImplementor.RenderMode.FROM_ONLY || mode == TableImplementor.RenderMode.WHERE_ONLY) {
                builder.separator();
            }
            this.renderSelf(builder, mode, false);
            if (mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY) {
                for (RealTable childTable : this) {
                    childTable.renderTo(builder, false);
                }
            }
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder, boolean cte) {
        TableLikeImplementor<?> owner = this.owner;
        SqlBuilder sqlBuilder = builder.assertSimple();
        TableUsedState usedState = sqlBuilder.getAstContext().getTableUsedState(this);
        if (owner.getParent() == null || usedState != TableUsedState.NONE) {
            if (owner instanceof BaseTableImplementor) {
                AstContext astContext = builder.assertSimple().getAstContext();
                astContext.pushRenderedBaseTable(this);
                this.renderSelf(sqlBuilder, TableImplementor.RenderMode.NORMAL, cte);
                astContext.popRenderedBaseTable();
            } else {
                this.renderSelf(sqlBuilder, TableImplementor.RenderMode.NORMAL, cte);
            }
            if (!cte) {
                for (RealTable childTable : this) {
                    childTable.renderTo(sqlBuilder, false);
                }
            }
        }
    }

    private void renderSelf(SqlBuilder builder, TableImplementor.RenderMode mode, boolean cte) {
        TableLikeImplementor<?> owner = this.owner;
        if (owner instanceof BaseTableImplementor) {
            if (!cte && this.parent != null) {
                builder.join(this.joinType);
            }
            this.renderBaseTableCore(builder, cte);
        } else if (owner instanceof TableImplementor) {
            Predicate filterPredicate;
            TableImplementor tableImplementor = (TableImplementor)owner;
            AbstractMutableStatementImpl statement = tableImplementor.getStatement();
            if (tableImplementor.isInverse()) {
                this.renderInverseJoin(builder, mode);
                filterPredicate = statement.getFilterPredicate(tableImplementor, builder.getAstContext());
            } else if (tableImplementor.getJoinProp() != null || tableImplementor.getWeakJoinHandle() != null) {
                this.renderJoin(builder, mode);
                filterPredicate = statement.getFilterPredicate(tableImplementor, builder.getAstContext());
            } else {
                ((SqlBuilder)((SqlBuilder)builder.from().sql(tableImplementor.getImmutableType().getTableName(builder.getAstContext().getSqlClient().getMetadataStrategy()))).sql(" ")).sql(this.aliases().value);
                filterPredicate = null;
            }
            if (filterPredicate != null) {
                builder.sql(" and ");
                ((Ast)((Object)filterPredicate)).renderTo(builder);
            }
        }
    }

    private void renderBaseTableCore(SqlBuilder builder, boolean cte) {
        boolean withScope;
        AstContext ctx = builder.getAstContext();
        BaseTableImpl baseTableImpl = (BaseTableImpl)this.owner;
        boolean aliasOnly = !cte && ((BaseTableImplementor)this.owner).isCte();
        boolean bl = withScope = !cte && this.parent != null && this.parent.owner instanceof TableImplementor && ((BaseTableImplementor)this.owner).getRecursive() == null;
        if (withScope) {
            builder.enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
        }
        if (aliasOnly) {
            builder.sql(this.aliases().value);
        } else {
            builder.enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            baseTableImpl.renderBaseQueryCore(builder);
            builder.leave();
            if (!baseTableImpl.isCte()) {
                ((SqlBuilder)builder.sql(" ")).sql(this.aliases().value);
            }
        }
        for (Selection<?> selection : baseTableImpl.getSelections()) {
            TableImplementor tableImplementor;
            BaseTableOwner baseTableOwner;
            if (!(selection instanceof Table) || (baseTableOwner = (tableImplementor = TableProxies.resolve((Table)selection, ctx)).getBaseTableOwner()) == null || baseTableOwner.getBaseTable() != baseTableImpl.toSymbol()) continue;
            RealTable realTable = tableImplementor.realTable(ctx);
            if (cte) continue;
            ctx.pushRenderedBaseTable(null);
            for (RealTable childTable : realTable) {
                childTable.renderTo(builder, false);
            }
            ctx.popRenderedBaseTable();
        }
        if (withScope) {
            builder.leave();
        }
        if (this.owner.getParent() == null || cte) {
            return;
        }
        ctx.pushRenderedBaseTable(null);
        builder.on();
        if (this.joinPredicate == null) {
            builder.sql("1 = 1");
        } else {
            ((Ast)((Object)this.joinPredicate)).renderTo(builder);
        }
        ctx.popRenderedBaseTable();
    }

    private void renderJoin(SqlBuilder builder, TableImplementor.RenderMode mode) {
        if (!(this.owner instanceof TableImplementor)) {
            return;
        }
        TableImpl owner = (TableImpl)this.owner;
        MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
        if (owner.weakJoinHandle != null) {
            if (builder.getAstContext().getTableUsedState(this) != TableUsedState.NONE) {
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.join(this.joinType).sql(owner.immutableType.getTableName(strategy))).sql(" ")).sql(this.aliases().value)).on();
                if (this.joinPredicate == null) {
                    builder.sql("1 = 1");
                } else {
                    ((Ast)((Object)this.joinPredicate)).renderTo(builder);
                }
            }
            return;
        }
        ImmutableProp joinProp = owner.joinProp;
        ImmutableType immutableType = owner.immutableType;
        if (joinProp.getSqlTemplate() instanceof JoinTemplate) {
            this.renderJoinBySql(builder, (JoinTemplate)joinProp.getSqlTemplate(), mode);
            return;
        }
        if (joinProp instanceof AssociationProp) {
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED) {
                this.renderJoinImpl(builder, this.joinType, this.parent.aliases().value, (ColumnDefinition)joinProp.getStorage(strategy), immutableType.getTableName(strategy), this.aliases().value, (ColumnDefinition)immutableType.getIdProp().getStorage(strategy), mode);
                this.renderMiddleTableFilters(((AssociationProp)joinProp).getDeclaringType().getMiddleTable(strategy), this.parent.aliases().value, builder);
            }
            return;
        }
        MiddleTable middleTable = null;
        if (joinProp.isMiddleTableDefinition()) {
            middleTable = (MiddleTable)joinProp.getStorage(strategy);
        }
        if (middleTable != null) {
            this.renderJoinImpl(builder, this.joinType, this.parent.aliases().value, (ColumnDefinition)owner.parent.immutableType.getIdProp().getStorage(strategy), middleTable.getTableName(), this.aliases().middleValue, middleTable.getColumnDefinition(), mode);
            this.renderMiddleTableFilters(middleTable, this.aliases().middleValue, builder);
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(builder, this.joinType, this.aliases().middleValue, middleTable.getTargetColumnDefinition(), immutableType.getTableName(strategy), this.aliases().value, (ColumnDefinition)immutableType.getIdProp().getStorage(strategy), TableImplementor.RenderMode.NORMAL);
            }
        } else if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED) {
            this.renderJoinImpl(builder, this.joinType, this.parent.aliases().value, (ColumnDefinition)joinProp.getStorage(strategy), immutableType.getTableName(strategy), this.aliases().value, (ColumnDefinition)immutableType.getIdProp().getStorage(strategy), mode);
        }
    }

    private void renderInverseJoin(SqlBuilder builder, TableImplementor.RenderMode mode) {
        TableImpl owner = (TableImpl)this.owner;
        MetadataStrategy strategy = builder.sqlClient().getMetadataStrategy();
        ImmutableType immutableType = owner.immutableType;
        ImmutableProp joinProp = owner.joinProp;
        if (joinProp.getSqlTemplate() instanceof JoinTemplate) {
            this.renderJoinBySql(builder, (JoinTemplate)joinProp.getSqlTemplate(), mode);
            return;
        }
        MiddleTable middleTable = null;
        if (joinProp.isMiddleTableDefinition()) {
            middleTable = (MiddleTable)joinProp.getStorage(strategy);
        }
        if (middleTable != null) {
            this.renderJoinImpl(builder, this.joinType, this.parent.aliases().value, (ColumnDefinition)owner.parent.immutableType.getIdProp().getStorage(strategy), middleTable.getTableName(), this.aliases().middleValue, middleTable.getTargetColumnDefinition(), mode);
            this.renderMiddleTableFilters(middleTable, this.aliases().middleValue, builder);
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(builder, this.joinType, this.aliases().middleValue, middleTable.getColumnDefinition(), immutableType.getTableName(strategy), this.aliases().value, (ColumnDefinition)immutableType.getIdProp().getStorage(strategy), TableImplementor.RenderMode.NORMAL);
            }
        } else {
            this.renderJoinImpl(builder, this.joinType, this.parent.aliases().value, (ColumnDefinition)owner.parent.immutableType.getIdProp().getStorage(strategy), immutableType.getTableName(strategy), this.aliases().value, (ColumnDefinition)joinProp.getStorage(strategy), mode);
        }
    }

    private void renderJoinBySql(SqlBuilder builder, JoinTemplate joinTemplate, TableImplementor.RenderMode mode) {
        TableImpl owner = (TableImpl)this.owner;
        if (builder.getAstContext().getTableUsedState(this) != TableUsedState.NONE) {
            ImmutableType immutableType = owner.getImmutableType();
            MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
            switch (mode) {
                case NORMAL: {
                    ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.join(this.joinType).sql(immutableType.getTableName(strategy))).sql(" ")).sql(this.aliases().value)).on();
                    break;
                }
                case FROM_ONLY: {
                    ((SqlBuilder)((SqlBuilder)builder.sql(immutableType.getTableName(strategy))).sql(" ")).sql(this.aliases().value);
                }
            }
            if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
                if (owner.isInverse) {
                    builder.sql(joinTemplate.toSql(this.aliases().value, this.parent.aliases().value));
                } else {
                    builder.sql(joinTemplate.toSql(this.parent.aliases().value, this.aliases().value));
                }
            }
        }
    }

    private void renderJoinImpl(SqlBuilder builder, JoinType joinType, String previousAlias, ColumnDefinition previousDefinition, String newTableName, String newAlias, ColumnDefinition newDefinition, TableImplementor.RenderMode mode) {
        if (mode != TableImplementor.RenderMode.NORMAL && joinType != JoinType.INNER) {
            throw new AssertionError((Object)"Internal bug: outer join cannot be accepted by abnormal render mode");
        }
        switch (mode) {
            case NORMAL: {
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.join(joinType).sql(newTableName)).sql(" ")).sql(newAlias)).on();
                break;
            }
            case FROM_ONLY: {
                ((SqlBuilder)((SqlBuilder)builder.sql(newTableName)).sql(" ")).sql(newAlias);
            }
        }
        if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
            BaseSelectionMapper mapper = null;
            if (this.owner instanceof TableImplementor) {
                TableImplementor tableImplementor = (TableImplementor)this.owner;
                BaseTableOwner baseTableOwner = tableImplementor.getBaseTableOwner();
                mapper = builder.getAstContext().getBaseSelectionMapper(baseTableOwner);
            }
            int size = previousDefinition.size();
            builder.enter(AbstractSqlBuilder.ScopeType.AND);
            for (int i = 0; i < size; ++i) {
                builder.separator();
                if (mapper != null) {
                    int index = mapper.columnIndex(previousAlias, previousDefinition.name(i));
                    ((SqlBuilder)((SqlBuilder)builder.sql(mapper.getAlias())).sql(".c")).sql(Integer.toString(index));
                } else {
                    ((SqlBuilder)((SqlBuilder)builder.sql(previousAlias)).sql(".")).sql(previousDefinition.name(i));
                }
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.sql(" = ")).sql(newAlias)).sql(".")).sql(newDefinition.name(i));
            }
            builder.leave();
        }
    }

    private void renderMiddleTableFilters(MiddleTable middleTable, String middleAlias, SqlBuilder builder) {
        JoinTableFilterInfo filterInfo;
        TableImpl owner = (TableImpl)this.owner;
        ImmutableProp joinProp = owner.joinProp;
        LogicalDeletedInfo deletedInfo = middleTable.getLogicalDeletedInfo();
        JSqlClientImplementor sqlClient = builder.getAstContext().getSqlClient();
        if (deletedInfo != null && sqlClient.getFilters().getBehavior(joinProp) != LogicalDeletedBehavior.IGNORED) {
            builder.sql(" and ");
            JoinTableFilters.render(sqlClient.getFilters().getBehavior(joinProp), deletedInfo, middleAlias, builder);
        }
        if ((filterInfo = middleTable.getFilterInfo()) != null) {
            builder.sql(" and ");
            JoinTableFilters.render(filterInfo, middleAlias, builder);
        }
    }

    public void renderSelection(ImmutableProp prop, boolean rawId, AbstractSqlBuilder<?> builder, ColumnDefinition optionalDefinition, boolean withPrefix, Function<Integer, String> asBlock) {
        SqlTemplate template;
        TableImpl owner = (TableImpl)this.owner;
        BaseSelectionMapper mapper = builder instanceof SqlBuilder ? ((SqlBuilder)builder).getAstContext().getBaseSelectionMapper(owner.getBaseTableOwner()) : null;
        ImmutableProp joinProp = owner.joinProp;
        MetadataStrategy strategy = builder.sqlClient().getMetadataStrategy();
        if (prop.isId() && joinProp != null && !(joinProp.getSqlTemplate() instanceof JoinTemplate) && (rawId || TableUtils.isRawIdAllowed(owner, builder.sqlClient()))) {
            MiddleTable middleTable = joinProp.isMiddleTableDefinition() ? (MiddleTable)joinProp.getStorage(strategy) : null;
            boolean isInverse = owner.isInverse;
            if (middleTable != null) {
                if (optionalDefinition == null) {
                    if (isInverse) {
                        builder.definition(withPrefix ? this.aliases().middleValue : null, middleTable.getColumnDefinition(), asBlock, null);
                    } else {
                        builder.definition(withPrefix ? this.aliases().middleValue : null, middleTable.getTargetColumnDefinition(), asBlock, null);
                    }
                } else {
                    ColumnDefinition fullDefinition = (ColumnDefinition)prop.getStorage(strategy);
                    ColumnDefinition parentDefinition = isInverse ? middleTable.getColumnDefinition() : middleTable.getTargetColumnDefinition();
                    int size = optionalDefinition.size();
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            builder.sql(", ");
                        }
                        int index = fullDefinition.index(optionalDefinition.name(i));
                        String parentColumnName = parentDefinition.name(index);
                        if (withPrefix) {
                            ((AbstractSqlBuilder)builder.sql(this.aliases().middleValue)).sql(".");
                        }
                        builder.sql(parentColumnName);
                        if (asBlock == null) continue;
                        ((AbstractSqlBuilder)builder.sql(" ")).sql(asBlock.apply(i));
                    }
                }
                return;
            }
            if (!isInverse) {
                if (optionalDefinition == null) {
                    builder.definition(withPrefix ? this.parent.aliases().value : null, (ColumnDefinition)joinProp.getStorage(strategy), asBlock, mapper);
                } else {
                    ColumnDefinition fullDefinition = (ColumnDefinition)prop.getStorage(strategy);
                    ColumnDefinition parentDefinition = (ColumnDefinition)joinProp.getStorage(strategy);
                    int size = optionalDefinition.size();
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            builder.sql(", ");
                        }
                        int index = fullDefinition.index(optionalDefinition.name(i));
                        String parentColumnName = parentDefinition.name(index);
                        if (withPrefix) {
                            ((AbstractSqlBuilder)builder.sql(this.parent.aliases().value)).sql(".");
                        }
                        builder.sql(parentColumnName);
                        if (asBlock == null) continue;
                        ((AbstractSqlBuilder)builder.sql(" ")).sql(asBlock.apply(i));
                    }
                }
                return;
            }
        }
        if ((template = prop.getSqlTemplate()) instanceof FormulaTemplate) {
            builder.sql(((FormulaTemplate)template).toSql(this.aliases().value));
            if (asBlock != null) {
                ((AbstractSqlBuilder)builder.sql(" ")).sql(asBlock.apply(0));
            }
        } else {
            ColumnDefinition definition = optionalDefinition != null ? optionalDefinition : (ColumnDefinition)prop.getStorage(strategy);
            builder.definition(withPrefix ? this.aliases().value : null, definition, asBlock, mapper);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RealTable{").append("identity=").append(System.identityHashCode(this)).append(", owner=").append(this.owner);
        if (!"".equals(this.key.joinName) && this.key.weakJoinHandle != null) {
            builder.append(", key=").append(this.key);
        }
        if (this.joinType != JoinType.INNER) {
            builder.append(", joinType=").append(this.joinType);
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public final void allocateAliases() {
        this.allocateAliasImpl();
        for (RealTable childTable : this) {
            childTable.allocateAliases();
        }
    }

    private void allocateAliasImpl() {
        ImmutableProp joinProp;
        BaseTableImplementor baseTableImplementor;
        BaseTableImplementor recursive;
        if (this.aliases != null) {
            return;
        }
        TableLikeImplementor<?> owner = this.owner;
        if (owner instanceof BaseTableImplementor && (recursive = (baseTableImplementor = (BaseTableImplementor)owner).getRecursive()) != null) {
            return;
        }
        AbstractMutableStatementImpl statement = owner.getStatement();
        StatementContext stmtCtx = statement.getContext();
        ImmutableProp immutableProp = joinProp = owner instanceof TableImplementor ? ((TableImplementor)owner).getJoinProp() : null;
        String middleAlias = joinProp != null ? (joinProp.isMiddleTableDefinition() ? stmtCtx.allocateTableAlias() : (joinProp.getSqlTemplate() == null && !joinProp.hasStorage() ? null : null)) : null;
        String alias = stmtCtx.allocateTableAlias();
        JSqlClientImplementor sqlClient = statement.getSqlClient();
        if (alias.equals("tb_1_") && sqlClient != null && (!sqlClient.getDialect().isUpdateAliasSupported() && stmtCtx.getPurpose().toString().startsWith("UPDATE") || !sqlClient.getDialect().isDeleteAliasSupported() && stmtCtx.getPurpose().toString().startsWith("DELETE"))) {
            alias = statement.getType().getTableName(sqlClient.getMetadataStrategy());
        }
        this.aliases = new Aliases(alias, middleAlias);
    }

    private Aliases allocateAliasesIfNecessary() {
        if (this.aliases != null) {
            return this.aliases;
        }
        if (this.parent != null) {
            this.parent.allocateAliasesIfNecessary();
        }
        this.allocateAliases();
        return this.aliases;
    }

    private Aliases aliases() {
        Aliases aliases = this.aliases;
        if (aliases == null) {
            BaseTableImplementor baseTableImplementor;
            BaseTableImplementor recursive;
            RealTableImpl realTableImpl = this.owner instanceof BaseTableImplementor ? (RealTableImpl)((recursive = (baseTableImplementor = (BaseTableImplementor)this.owner).getRecursive()) != null ? recursive : baseTableImplementor).realTable(this.key.scope) : (RealTableImpl)((TableImplementor)this.owner).baseTableOwner(null).realTable(this.key.scope);
            this.aliases = aliases = realTableImpl.allocateAliasesIfNecessary();
        }
        return aliases;
    }

    private static class Aliases {
        final String value;
        final String middleValue;

        Aliases(String value, String middleValue) {
            this.value = value;
            this.middleValue = middleValue;
        }

        public String toString() {
            return "Aliases{value='" + this.value + '\'' + ", middleValue='" + this.middleValue + '\'' + '}';
        }
    }
}

