/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTypeMergeScope;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RealTable
extends Iterable<RealTable> {
    public TableLikeImplementor<?> getTableLikeImplementor();

    public RealTable getParent();

    public Key getKey();

    public RealTable child(Key var1);

    public String getAlias();

    public String getMiddleTableAlias();

    public String getFinalAlias(ImmutableProp var1, boolean var2, JSqlClientImplementor var3);

    @Nullable
    public BaseTableOwner getBaseTableOwner();

    public void allocateAliases();

    public void use(UseTableVisitor var1);

    public void renderTo(@NotNull AbstractSqlBuilder<?> var1, boolean var2);

    public void renderJoinAsFrom(SqlBuilder var1, TableImplementor.RenderMode var2);

    public static final class Key {
        final JoinTypeMergeScope scope;
        final WeakJoinHandle weakJoinHandle;
        final String joinName;

        Key(JoinTypeMergeScope scope, boolean inverse, ImmutableProp joinProp, WeakJoinHandle weakJoinHandle) {
            ImmutableProp opposite;
            this.scope = scope;
            this.weakJoinHandle = weakJoinHandle;
            String joinName = joinProp == null ? "" : (inverse ? ((opposite = joinProp.getOpposite()) != null ? opposite.getName() : "\u2190" + joinProp.getName()) : joinProp.getName());
            this.joinName = joinName;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.scope);
            result = 31 * result + this.joinName.hashCode();
            result = 31 * result + Objects.hashCode(this.weakJoinHandle);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key other = (Key)o;
            if (this.scope != other.scope) {
                return false;
            }
            if (!this.joinName.equals(other.joinName)) {
                return false;
            }
            return Objects.equals(this.weakJoinHandle, other.weakJoinHandle);
        }

        public String toString() {
            return "Key{scope=" + this.scope + ", joinName=" + this.joinName + ", weakJoinHandle=" + this.weakJoinHandle + "}";
        }
    }
}

