/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.fetcher.impl.JoinFetchFieldVisitor;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetcherSelectionImpl<T>
implements FetcherSelection<T>,
Ast {
    private final FetchPath path;
    private final Table<?> table;
    private final PropExpression.Embedded<?> embeddedPropExpression;
    private final Fetcher<?> fetcher;
    @Nullable
    private final Function<?, ?> converter;

    public FetcherSelectionImpl(Table<T> table, Fetcher<T> fetcher) {
        this.path = null;
        this.table = table;
        this.embeddedPropExpression = null;
        this.fetcher = fetcher;
        this.converter = null;
    }

    public FetcherSelectionImpl(Table<T> table, FetchPath path, Fetcher<T> fetcher) {
        this.path = path;
        this.table = table;
        this.embeddedPropExpression = null;
        this.fetcher = fetcher;
        this.converter = null;
    }

    public FetcherSelectionImpl(Table<?> table, Fetcher<?> fetcher, @Nullable Function<?, T> converter) {
        this.path = null;
        this.table = table;
        this.fetcher = fetcher;
        this.embeddedPropExpression = null;
        this.converter = converter;
    }

    public FetcherSelectionImpl(PropExpression.Embedded<T> embeddedPropExpression, Fetcher<T> fetcher) {
        this.path = null;
        this.table = ((PropExpressionImplementor)((Object)embeddedPropExpression)).getTable();
        this.fetcher = fetcher;
        this.embeddedPropExpression = embeddedPropExpression;
        this.converter = null;
    }

    public FetcherSelectionImpl(PropExpression.Embedded<?> embeddedPropExpression, Fetcher<?> fetcher, @Nullable Function<?, ?> converter) {
        this.path = null;
        this.table = ((PropExpressionImplementor)((Object)embeddedPropExpression)).getTable();
        this.fetcher = fetcher;
        this.embeddedPropExpression = embeddedPropExpression;
        this.converter = converter;
    }

    public Table<?> getTable() {
        return this.table;
    }

    @Override
    public FetchPath getPath() {
        return this.path;
    }

    @Override
    public PropExpression.Embedded<?> getEmbeddedPropExpression() {
        return this.embeddedPropExpression;
    }

    @Override
    public Fetcher<?> getFetcher() {
        return this.fetcher;
    }

    @Override
    @Nullable
    public Function<?, ?> getConverter() {
        return this.converter;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        this.accept(this.table, visitor);
        BaseTableOwner baseTableOwner = BaseTableOwner.of(this.table);
        if (baseTableOwner != null) {
            int index = baseTableOwner.getIndex();
            ConfigurableBaseQueryImpl<?> query = baseTableOwner.getBaseTable().getQuery();
            MergedBaseQueryImpl<?> mergedBy = MergedBaseQueryImpl.from(query);
            if (mergedBy != null) {
                for (ConfigurableBaseQueryImpl<?> q : mergedBy.getExpandedQueries()) {
                    visitor.getAstContext().pushStatement(q.getMutableQuery());
                    this.accept((Table)mergedBy.getSelections().get(index), visitor);
                    visitor.getAstContext().popStatement();
                }
            }
        }
    }

    private void accept(Table<?> table, AstVisitor visitor) {
        ImmutableProp embeddedRawReferenceProp = this.getEmbeddedRawReferenceProp(visitor.getAstContext().getSqlClient());
        if (embeddedRawReferenceProp != null) {
            visitor.visitTableReference(TableProxies.resolve(TableUtils.parent(table), visitor.getAstContext()).realTable(visitor.getAstContext()), embeddedRawReferenceProp, true);
            return;
        }
        RealTable realTable = TableProxies.resolve(table, visitor.getAstContext()).realTable(visitor.getAstContext());
        for (Field field : this.fetcher.getFieldMap().values()) {
            ImmutableProp prop = field.getProp();
            if (!prop.isColumnDefinition() && !(prop.getSqlTemplate() instanceof FormulaTemplate) && !JoinFetchFieldVisitor.isJoinField(field, visitor.getAstContext().getSqlClient())) continue;
            visitor.visitTableReference(realTable, prop, field.isRawId());
        }
        visitor.visitTableFetcher(realTable, this.fetcher);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> abstractBuilder) {
        final SqlBuilder builder = abstractBuilder.assertSimple();
        final AstContext ctx = builder.getAstContext();
        JSqlClientImplementor sqlClient = ctx.getSqlClient();
        final MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        final ImmutableProp embeddedRawReferenceProp = this.getEmbeddedRawReferenceProp(builder.sqlClient());
        final RealTable realTable = TableProxies.resolve(this.table, builder.getAstContext()).realTable(builder.getAstContext());
        new JoinFetchFieldVisitor(builder.sqlClient()){
            private RealTable table;
            {
                super(sqlClient);
                this.table = realTable;
            }

            @Override
            protected Object enter(Field field) {
                RealTable oldTable = this.table;
                TableLikeImplementor<?> implementor = oldTable.getTableLikeImplementor();
                if (implementor instanceof TableImplementor) {
                    TableImplementor tableImplementor = (TableImplementor)implementor;
                    this.table = tableImplementor.joinFetchImplementor(field.getProp(), oldTable.getBaseTableOwner()).realTable(ctx);
                }
                return oldTable;
            }

            @Override
            protected void leave(Field field, Object enterValue) {
                this.table = (RealTable)enterValue;
            }

            @Override
            protected void visit(Field field, int depth) {
                BaseSelectionMapper mapper;
                if (field.getProp().isFormula() && field.getProp().getSqlTemplate() == null) {
                    return;
                }
                ImmutableProp prop = field.getProp();
                String alias = this.table.getAlias();
                BaseSelectionMapper baseSelectionMapper = mapper = depth == 0 ? builder.getAstContext().getBaseSelectionMapper(this.table.getBaseTableOwner()) : null;
                if (FetcherSelectionImpl.this.embeddedPropExpression != null) {
                    String path = ((PropExpressionImplementor)((Object)FetcherSelectionImpl.this.embeddedPropExpression)).getPath();
                    this.renderEmbedded(embeddedRawReferenceProp, embeddedRawReferenceProp != null ? (EmbeddedColumns)embeddedRawReferenceProp.getTargetType().getIdProp().getStorage(strategy) : (EmbeddedColumns)((PropExpressionImplementor)((Object)FetcherSelectionImpl.this.embeddedPropExpression)).getProp().getStorage(strategy), field.getChildFetcher(), path != null ? path + '.' + field.getProp().getName() : field.getProp().getName(), mapper, builder);
                } else {
                    Storage storage = prop.getStorage(strategy);
                    SqlTemplate template = prop.getSqlTemplate();
                    if (storage instanceof EmbeddedColumns) {
                        this.renderEmbedded(null, (EmbeddedColumns)storage, field.getChildFetcher(), "", mapper, builder);
                    } else if (storage instanceof ColumnDefinition) {
                        ((SqlBuilder)builder.separator()).definition(alias, (ColumnDefinition)storage, mapper);
                    } else if (template instanceof FormulaTemplate) {
                        builder.separator();
                        if (mapper != null) {
                            ((SqlBuilder)((SqlBuilder)builder.sql(mapper.getAlias())).sql(".c")).sql(Integer.toString(mapper.formulaIndex(alias, (FormulaTemplate)template)));
                        } else {
                            builder.sql(((FormulaTemplate)template).toSql(alias));
                        }
                    }
                }
            }

            private void renderEmbedded(ImmutableProp embeddedRawReferenceProp2, EmbeddedColumns columns, Fetcher<?> childFetcher, String path, BaseSelectionMapper mapper, SqlBuilder builder2) {
                MultipleJoinColumns joinColumns;
                RealTable realTable2 = embeddedRawReferenceProp2 != null ? this.table.getParent() : this.table;
                MultipleJoinColumns multipleJoinColumns = joinColumns = embeddedRawReferenceProp2 != null ? (MultipleJoinColumns)embeddedRawReferenceProp2.getStorage(builder2.sqlClient().getMetadataStrategy()) : null;
                if (childFetcher == null) {
                    for (String columnName : columns.partial(path)) {
                        if (joinColumns != null) {
                            columnName = joinColumns.name(joinColumns.referencedIndex(columnName));
                        }
                        builder2.separator();
                        if (mapper != null) {
                            ((SqlBuilder)((SqlBuilder)builder2.sql(mapper.getAlias())).sql(".c")).sql(Integer.toString(mapper.columnIndex(realTable2.getAlias(), columnName)));
                            continue;
                        }
                        ((SqlBuilder)((SqlBuilder)builder2.sql(realTable2.getAlias())).sql(".")).sql(columnName);
                    }
                } else {
                    for (Field field : childFetcher.getFieldMap().values()) {
                        ImmutableProp prop = field.getProp();
                        if (prop.isFormula() && prop.getSqlTemplate() == null) continue;
                        String propName = field.getProp().getName();
                        this.renderEmbedded(embeddedRawReferenceProp2, columns, field.getChildFetcher(), path.isEmpty() ? propName : path + '.' + propName, mapper, builder2);
                    }
                }
            }
        }.visit(this.fetcher);
    }

    private ImmutableProp getEmbeddedRawReferenceProp(JSqlClientImplementor sqlClient) {
        ImmutableProp joinProp;
        if (this.embeddedPropExpression == null) {
            return null;
        }
        PropExpressionImpl pei = (PropExpressionImpl)((Object)this.embeddedPropExpression);
        if (!pei.getProp().isId()) {
            return null;
        }
        if (this.table instanceof TableProxy) {
            TableProxy tableProxy = (TableProxy)this.table;
            joinProp = tableProxy.__prop();
            if (tableProxy.__isInverse()) {
                joinProp = joinProp.getMappedBy();
            }
        } else {
            TableImplementor tableImplementor = (TableImplementor)this.table;
            joinProp = tableImplementor.getJoinProp();
            if (tableImplementor.isInverse()) {
                joinProp = joinProp.getMappedBy();
            }
        }
        if (joinProp == null || !joinProp.isColumnDefinition()) {
            return null;
        }
        if (sqlClient.getFilters().getTargetFilter(joinProp) != null) {
            return null;
        }
        return joinProp;
    }

    @Override
    public boolean hasVirtualPredicate() {
        return false;
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        return this;
    }

    public String toString() {
        return "FetcherSelectionImpl{fetcher=" + this.fetcher + '}';
    }
}

