/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.io.IOException;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.babyfish.jimmer.impl.org.objectweb.asm.ClassReader;
import org.babyfish.jimmer.impl.org.objectweb.asm.ClassVisitor;
import org.babyfish.jimmer.impl.org.objectweb.asm.MethodVisitor;
import org.babyfish.jimmer.impl.org.objectweb.asm.tree.InsnList;
import org.babyfish.jimmer.impl.org.objectweb.asm.tree.MethodNode;
import org.babyfish.jimmer.sql.ast.impl.table.InsnListUtils;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinLambda;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;

public abstract class AbstractWeakJoinLambdaFactory {
    private static final WeakJoinLambda NIL = new WeakJoinLambda(new InsnList(), Void.TYPE, Void.TYPE);
    private final ReadWriteLock cacheRwl = new ReentrantReadWriteLock();
    private final Map<Class<?>, WeakJoinLambda> cacheMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final WeakJoinLambda getLambda(Object join) {
        WeakJoinLambda weakJoinLambda;
        Lock lock = this.cacheRwl.readLock();
        lock.lock();
        try {
            weakJoinLambda = this.cacheMap.get(join.getClass());
        }
        finally {
            lock.unlock();
        }
        if (weakJoinLambda == null) {
            lock = this.cacheRwl.writeLock();
            lock.lock();
            try {
                weakJoinLambda = this.cacheMap.get(join.getClass());
                if (weakJoinLambda == null) {
                    weakJoinLambda = this.create(join);
                    if (weakJoinLambda == null) {
                        weakJoinLambda = NIL;
                    }
                    this.cacheMap.put(join.getClass(), weakJoinLambda);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return weakJoinLambda == NIL ? null : weakJoinLambda;
    }

    private WeakJoinLambda create(Object join) {
        ClassReader classReader;
        SerializedLambda serializedLambda = AbstractWeakJoinLambdaFactory.getSerializedLambda(join);
        if (serializedLambda == null) {
            return null;
        }
        Class<?>[] types = this.getTypes(serializedLambda);
        try {
            classReader = new ClassReader(serializedLambda.getImplClass());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read the byte code of \"" + serializedLambda.getImplClass() + "\", is your application running as native code? Two choices: \n1. Use class implementation of " + WeakJoin.class.getName() + "\n2. Run application as JVM mode");
        }
        ClassVisitorImpl cv = new ClassVisitorImpl(serializedLambda.getImplMethodName());
        classReader.accept((ClassVisitor)cv, 6);
        InsnListUtils.eraseLambdaMagicNumber(cv.methodNode.instructions);
        return new WeakJoinLambda(cv.methodNode.instructions, types[0], types[1]);
    }

    protected abstract Class<?>[] getTypes(SerializedLambda var1);

    private static SerializedLambda getSerializedLambda(Object join) {
        Object serializedLambda;
        Method writeReplace;
        try {
            writeReplace = join.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        writeReplace.setAccessible(true);
        try {
            serializedLambda = writeReplace.invoke(join, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError("Internal bug", ex);
        }
        catch (InvocationTargetException ex) {
            throw new AssertionError("Cannot get writeReplace of lambda " + join, ex);
        }
        if (!(serializedLambda instanceof SerializedLambda)) {
            throw new IllegalStateException("Not a SerializedLambda: " + serializedLambda.getClass());
        }
        return (SerializedLambda)serializedLambda;
    }

    private static class ClassVisitorImpl
    extends ClassVisitor {
        private final String methodName;
        MethodNode methodNode;

        protected ClassVisitorImpl(String methodName) {
            super(327680);
            this.methodName = methodName;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals(this.methodName)) {
                this.methodNode = new MethodNode();
                return this.methodNode;
            }
            return null;
        }
    }
}

