/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.LiteralExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TupleExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.util.InList;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.collection.TypedList;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class ComparisonPredicates {
    private static final Map<String, String> REVERSED_OP_MAP;

    private ComparisonPredicates() {
    }

    public static void renderCmp(String operator, Expression<?> left, Expression<?> right, AbstractSqlBuilder<?> builder) {
        PropExpressionImplementor propExpressionImplementor;
        if (left instanceof LiteralExpressionImplementor && right instanceof PropExpressionImplementor) {
            ComparisonPredicates.renderCmp(REVERSED_OP_MAP.get(operator), right, left, builder);
            return;
        }
        if (left instanceof PropExpressionImplementor && right instanceof LiteralExpressionImplementor && (propExpressionImplementor = (PropExpressionImplementor)left).getProp().isColumnDefinition()) {
            Object value = ((LiteralExpressionImplementor)((Object)right)).getValue();
            List<ValueGetter> valueGetters = ValueGetter.valueGetters(builder.sqlClient(), left, value);
            if (builder instanceof SqlBuilder) {
                BaseTableOwner owner = BaseTableOwner.of(propExpressionImplementor.getTable());
                BaseSelectionMapper mapper = ((SqlBuilder)builder).getAstContext().getBaseSelectionMapper(owner);
                String alias = TableProxies.resolve(propExpressionImplementor.getTable(), ((SqlBuilder)builder).getAstContext()).realTable(((SqlBuilder)builder).getAstContext()).getFinalAlias(propExpressionImplementor.getProp(), propExpressionImplementor.isRawId(), builder.sqlClient());
                valueGetters = ValueGetter.alias(mapper, alias, valueGetters);
            }
            ComparisonPredicates.renderCmp(operator, valueGetters, value, builder);
            return;
        }
        ((Ast)((Object)left)).renderTo(builder);
        builder.sql(" ");
        builder.sql(operator);
        builder.sql(" ");
        ((Ast)((Object)right)).renderTo(builder);
    }

    public static void renderCmp(String operator, List<ValueGetter> getters, Object value, AbstractSqlBuilder<?> builder) {
        if (!REVERSED_OP_MAP.containsKey(operator)) {
            throw new IllegalArgumentException("Illegal operator: " + operator);
        }
        if (getters.size() > 1 && !"=".equals(operator) && !"<>".equals(operator)) {
            throw new IllegalArgumentException("The comparison predicate \"" + operator + "\" does not support multiple columns type");
        }
        boolean hasNullable = false;
        for (ValueGetter getter : getters) {
            if (!ComparisonPredicates.isNull(getter.get(value))) continue;
            hasNullable = true;
            break;
        }
        if (!hasNullable && getters.size() > 1 && builder.sqlClient().getDialect().isTupleComparisonSupported()) {
            builder.enter(AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter getter : getters) {
                ((AbstractSqlBuilder)builder.separator()).sql(getter);
            }
            builder.leave();
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(" ")).sql(operator)).sql(" ");
            builder.enter(AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter getter : getters) {
                ((AbstractSqlBuilder)builder.separator()).rawVariable(getter.get(value));
            }
            builder.leave();
            return;
        }
        boolean eq = "=".equals(operator);
        boolean ne = "<>".equals(operator);
        builder.enter(getters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : (ne ? AbstractSqlBuilder.ScopeType.SMART_OR : AbstractSqlBuilder.ScopeType.AND));
        for (ValueGetter getter : getters) {
            Object v = getter.get(value);
            ((AbstractSqlBuilder)builder.separator()).sql(getter);
            if (ComparisonPredicates.isNull(v) && (eq || ne)) {
                builder.sql(ne ? " is not null" : " is null");
                continue;
            }
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(" ")).sql(operator)).sql(" ");
            builder.rawVariable(v);
        }
        builder.leave();
    }

    public static void renderExpressionIn(boolean negative, Expression<?> expression, Collection<Expression<?>> expressions, AbstractSqlBuilder<?> builder) {
        if (expressions.isEmpty()) {
            builder.sql(negative ? "1 = 1" : "1 = 0");
            return;
        }
        ExpressionImplementor imp = (ExpressionImplementor)expression;
        Class type = imp.getType();
        for (Expression<?> expr : expressions) {
            Class actualType = ((ExpressionImplementor)expr).getType();
            if (type == actualType) continue;
            throw new IllegalArgumentException("The type of left operand is \"" + type.getName() + "\", but there is a right operand whose type is \"" + actualType.getName() + "\"");
        }
        if (expression instanceof TupleExpressionImplementor) {
            TupleExpressionImplementor tei = (TupleExpressionImplementor)expression;
            JSqlClientImplementor sqlClient = builder.sqlClient();
            Dialect dialect = sqlClient.getDialect();
            if (tei.size() > 1 && !(expressions.size() != 1 ? dialect.isTupleSupported() : dialect.isTupleComparisonSupported())) {
                builder.enter(negative ? AbstractSqlBuilder.ScopeType.AND : (expressions.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.SMART_OR));
                Collection<Expression<?>> iterable = expressions.size() > 1 && sqlClient.isExpandedInListPaddingEnabled() ? new InList(expressions, true, Integer.MAX_VALUE).iterator().next() : expressions;
                int size = tei.size();
                for (Expression expression2 : iterable) {
                    TupleExpressionImplementor teiOperand = (TupleExpressionImplementor)expression2;
                    ((AbstractSqlBuilder)builder.separator()).enter(negative ? AbstractSqlBuilder.ScopeType.SMART_OR : AbstractSqlBuilder.ScopeType.AND);
                    for (int i = 0; i < size; ++i) {
                        builder.separator();
                        ((Ast)((Object)tei.get(i))).renderTo(builder);
                        builder.sql(negative ? " <> " : " = ");
                        ((Ast)((Object)teiOperand.get(i))).renderTo(builder);
                    }
                    builder.leave();
                }
                builder.leave();
                return;
            }
        }
        ((Ast)((Object)expression)).renderTo(builder);
        if (expressions.size() == 1) {
            builder.sql(negative ? " <> " : " = ");
            Expression operand = expressions instanceof List ? (Expression)((List)expressions).get(0) : expressions.iterator().next();
            ((Ast)((Object)operand)).renderTo(builder);
        } else {
            builder.sql(negative ? " not in " : " in ");
            builder.enter(AbstractSqlBuilder.ScopeType.LIST);
            for (Expression<?> operand : expressions) {
                builder.separator();
                ((Ast)((Object)operand)).renderTo(builder);
            }
            builder.leave();
        }
    }

    public static void renderIn(boolean nullable, boolean negative, Expression<?> expression, Collection<?> values, AbstractSqlBuilder<?> builder) {
        if (values.isEmpty()) {
            builder.sql(negative ? "1 = 1" : "1 = 0");
            return;
        }
        LinkedHashMap<List, List> multiMap = new LinkedHashMap<List, List>();
        for (Object obj : values) {
            multiMap.computeIfAbsent(ValueGetter.valueGetters(builder.sqlClient(), expression, obj), it -> new ArrayList()).add(obj);
        }
        if (multiMap.size() == 1) {
            Map.Entry e = multiMap.entrySet().iterator().next();
            ComparisonPredicates.renderIn(nullable, negative, (List)e.getKey(), (Collection)e.getValue(), builder);
            return;
        }
        builder.enter(negative ? AbstractSqlBuilder.ScopeType.AND : AbstractSqlBuilder.ScopeType.SMART_OR);
        for (Map.Entry entry : multiMap.entrySet()) {
            builder.separator();
            ComparisonPredicates.renderIn(nullable, negative, (List)entry.getKey(), (Collection)entry.getValue(), builder);
        }
        builder.leave();
    }

    public static void renderIn(boolean nullable, boolean negative, List<ValueGetter> getters, Collection<?> values, AbstractSqlBuilder<?> builder) {
        if (nullable) {
            ComparisonPredicates.renderNullableIn(negative, getters, values, builder);
        } else {
            ComparisonPredicates.renderIn(negative, getters, values, builder);
        }
    }

    public static void renderIn(boolean negative, List<ValueGetter> getters, Collection<?> values, AbstractSqlBuilder<?> builder) {
        if (values.isEmpty() || getters.isEmpty()) {
            builder.sql(negative ? "1 = 1" : "1 = 0");
            return;
        }
        JSqlClientImplementor sqlClient = builder.sqlClient();
        Dialect dialect = sqlClient.getDialect();
        if (getters.size() > 1 && !(values.size() != 1 ? dialect.isTupleSupported() : dialect.isTupleComparisonSupported())) {
            builder.enter(negative ? AbstractSqlBuilder.ScopeType.AND : (values.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.SMART_OR));
            Collection<?> iterable = values.size() > 1 && sqlClient.isExpandedInListPaddingEnabled() ? new InList(values, true, Integer.MAX_VALUE).iterator().next() : values;
            for (Object value : iterable) {
                ((AbstractSqlBuilder)builder.separator()).enter(negative ? AbstractSqlBuilder.ScopeType.SMART_OR : AbstractSqlBuilder.ScopeType.AND);
                for (ValueGetter getter : getters) {
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql(getter)).sql(negative ? " <> " : " = ")).rawVariable(ComparisonPredicates.nonNull(getter.get(value)));
                }
                builder.leave();
            }
            builder.leave();
            return;
        }
        if (values.size() == 1) {
            Object value;
            Object object = value = values instanceof List ? ((List)values).get(0) : values.iterator().next();
            if (getters.size() == 1) {
                ValueGetter getter = getters.get(0);
                ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(getter)).sql(negative ? " <> " : " = ")).rawVariable(ComparisonPredicates.nonNull(getter.get(value)));
                return;
            }
            builder.enter(AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter getter : getters) {
                ((AbstractSqlBuilder)builder.separator()).sql(getter);
            }
            builder.leave();
            builder.sql(negative ? " <> " : " = ");
            builder.enter(AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter getter : getters) {
                ((AbstractSqlBuilder)builder.separator()).rawVariable(ComparisonPredicates.nonNull(getter.get(value)));
            }
            builder.leave();
            return;
        }
        if (getters.size() == 1 && dialect.isAnyEqualityOfArraySupported()) {
            ValueGetter getter = getters.get(0);
            String sqlType = getter.metadata().getSqlTypeName();
            Object[] arr = new Object[values.size()];
            int index = 0;
            for (Object value : values) {
                arr[index++] = ComparisonPredicates.nonNull(getter.get(value));
            }
            if (negative) {
                ((AbstractSqlBuilder)builder.sql("not ")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
                ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(getter)).sql(" = any(")).rawVariable(new TypedList(sqlType, arr))).sql(")");
                builder.leave();
            } else {
                ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(getter)).sql(" = any(")).rawVariable(new TypedList(sqlType, arr))).sql(")");
            }
            return;
        }
        InList inList = new InList(values, sqlClient.isInListPaddingEnabled(), dialect.getMaxInListSize());
        if (getters.size() == 1) {
            ValueGetter getter = getters.get(0);
            builder.enter(values.size() > dialect.getMaxInListSize() ? (negative ? AbstractSqlBuilder.ScopeType.AND : AbstractSqlBuilder.ScopeType.SMART_OR) : AbstractSqlBuilder.ScopeType.NULL);
            for (Iterable<?> subList : inList) {
                ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql(getter)).sql(negative ? " not in " : " in ")).enter(AbstractSqlBuilder.ScopeType.LIST);
                for (Object value : subList) {
                    ((AbstractSqlBuilder)builder.separator()).rawVariable(ComparisonPredicates.nonNull(getter.get(value)));
                }
                builder.leave();
            }
            builder.leave();
            return;
        }
        builder.enter(values.size() > dialect.getMaxInListSize() ? (negative ? AbstractSqlBuilder.ScopeType.AND : AbstractSqlBuilder.ScopeType.SMART_OR) : AbstractSqlBuilder.ScopeType.NULL);
        for (Iterable<?> subList : inList) {
            ((AbstractSqlBuilder)builder.separator()).enter(AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter getter : getters) {
                ((AbstractSqlBuilder)builder.separator()).sql(getter);
            }
            builder.leave();
            ((AbstractSqlBuilder)builder.sql(negative ? " not in " : " in ")).enter(AbstractSqlBuilder.ScopeType.LIST);
            for (ValueGetter value : subList) {
                ((AbstractSqlBuilder)builder.separator()).enter(AbstractSqlBuilder.ScopeType.TUPLE);
                for (ValueGetter getter : getters) {
                    ((AbstractSqlBuilder)builder.separator()).rawVariable(ComparisonPredicates.nonNull(getter.get(value)));
                }
                builder.leave();
            }
            builder.leave();
        }
        builder.leave();
    }

    public static void renderNullableIn(boolean negative, List<ValueGetter> getters, Collection<?> values, AbstractSqlBuilder<?> builder) {
        if (getters.isEmpty()) {
            builder.sql(negative ? "1 = 1" : "1 = 0");
            return;
        }
        int maxNullColIndex = -1;
        int preNullCount = 0;
        int columnCount = getters.size();
        for (int i = 0; i < columnCount; ++i) {
            ValueGetter getter = getters.get(i);
            int nullCount = 0;
            for (Object value : values) {
                if (!ComparisonPredicates.isNull(getter.get(value))) continue;
                ++nullCount;
            }
            if (nullCount <= preNullCount) continue;
            maxNullColIndex = i;
            preNullCount = nullCount;
        }
        if (maxNullColIndex == -1) {
            ComparisonPredicates.renderIn(negative, getters, values, builder);
            return;
        }
        ArrayList<ValueGetter> otherGetters = new ArrayList<ValueGetter>(getters.size() - 1);
        for (int i = 0; i < columnCount; ++i) {
            if (i == maxNullColIndex) continue;
            otherGetters.add(getters.get(i));
        }
        ArrayList nonNullValues = new ArrayList(values.size() - preNullCount);
        ArrayList nullValues = new ArrayList(preNullCount);
        ValueGetter nullableGetter = getters.get(maxNullColIndex);
        for (Object value : values) {
            if (!ComparisonPredicates.isNull(nullableGetter.get(value))) {
                nonNullValues.add(value);
                continue;
            }
            nullValues.add(value);
        }
        builder.enter(nonNullValues.isEmpty() ? AbstractSqlBuilder.ScopeType.NULL : (negative ? AbstractSqlBuilder.ScopeType.AND : AbstractSqlBuilder.ScopeType.SMART_OR));
        if (!nonNullValues.isEmpty()) {
            builder.separator();
            ComparisonPredicates.renderNullableIn(negative, getters, nonNullValues, builder);
        }
        builder.separator();
        builder.enter(otherGetters.isEmpty() ? AbstractSqlBuilder.ScopeType.NULL : (negative ? AbstractSqlBuilder.ScopeType.SMART_OR : AbstractSqlBuilder.ScopeType.AND));
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql(nullableGetter)).sql(negative ? " is not null" : " is null");
        if (!otherGetters.isEmpty()) {
            builder.separator();
            ComparisonPredicates.renderNullableIn(negative, otherGetters, nullValues, builder);
        }
        ((AbstractSqlBuilder)builder.leave()).leave();
    }

    private static Object nonNull(Object value) {
        if (value == null || value instanceof DbLiteral.DbNull) {
            throw new IllegalArgumentException("The \"in\" predicate does not accept nulls, please use \"nullableIn\" predicate to handle nulls");
        }
        return value;
    }

    private static boolean isNull(Object value) {
        return value == null || value instanceof DbLiteral.DbNull;
    }

    static {
        HashMap<String, String> reversedOpMap = new HashMap<String, String>();
        reversedOpMap.put("=", "=");
        reversedOpMap.put("<>", "<>");
        reversedOpMap.put("<", ">=");
        reversedOpMap.put("<=", ">");
        reversedOpMap.put(">", "<=");
        reversedOpMap.put(">=", "<");
        REVERSED_OP_MAP = reversedOpMap;
    }
}

