/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.JoinFetchFieldVisitor;
import org.jetbrains.annotations.Nullable;

public class UseTableVisitor
extends AstVisitor {
    private final List<RealTable> rootTables = new ArrayList<RealTable>();

    public UseTableVisitor(AstContext ctx) {
        super(ctx);
    }

    public void allocateAliases() {
        for (RealTable rootTable : this.rootTables) {
            rootTable.allocateAliases();
        }
    }

    @Override
    public void visitTableReference(RealTable table, @Nullable ImmutableProp prop, boolean rawId) {
        TableLikeImplementor<?> implementor = table.getTableLikeImplementor();
        if (implementor instanceof BaseTableImplementor) {
            BaseTableImplementor baseTableImplementor = (BaseTableImplementor)implementor;
            baseTableImplementor.realTable(this.getAstContext()).use(this);
        } else if (implementor instanceof TableImplementor) {
            BaseTableOwner owner;
            TableImplementor tableImplementor = (TableImplementor)implementor;
            if (prop == null) {
                if (tableImplementor.getImmutableType().getSelectableProps().size() > 1) {
                    this.use(table);
                }
            } else if (prop.isId() && (rawId || TableUtils.isRawIdAllowed(tableImplementor, this.getAstContext().getSqlClient()))) {
                this.getAstContext().useTableId(table);
                this.use(table.getParent());
            } else {
                this.use(table);
            }
            if ((owner = tableImplementor.getBaseTableOwner()) != null) {
                BaseTableImplementor baseTableImplementor = this.getAstContext().resolveBaseTable(owner.getBaseTable());
                this.use(baseTableImplementor.realTable(this.getAstContext()));
            }
        }
    }

    @Override
    public void visitTableFetcher(RealTable table, Fetcher<?> fetcher) {
        TableLikeImplementor<?> implementor = table.getTableLikeImplementor();
        if (implementor instanceof TableImplementor) {
            TableImplementor tableImplementor = (TableImplementor)implementor;
            new UseJoinFetcherVisitor(this.getAstContext(), tableImplementor).visit(fetcher);
        }
    }

    @Override
    public void visitStatement(AbstractMutableStatementImpl statement) {
        AstContext ctx = this.getAstContext();
        RealTable table = ctx.getStatement().getTableLikeImplementor().realTable(ctx);
        this.rootTables.add(table);
        table.use(this);
    }

    private void use(RealTable table) {
        if (table != null) {
            this.getAstContext().useTable(table);
            this.use(table.getParent());
        }
    }

    private static class UseJoinFetcherVisitor
    extends JoinFetchFieldVisitor {
        private final AstContext ctx;
        private TableImplementor<?> tableImplementor;

        UseJoinFetcherVisitor(AstContext ctx, TableImplementor<?> tableImplementor) {
            super(ctx.getSqlClient());
            this.ctx = ctx;
            this.tableImplementor = tableImplementor;
        }

        @Override
        protected Object enter(Field field) {
            TableImplementor<?> oldTableImplementor = this.tableImplementor;
            TableImplementor<?> newTableImplementor = oldTableImplementor.joinFetchImplementor(field.getProp(), oldTableImplementor.getBaseTableOwner());
            this.ctx.useTable(newTableImplementor.realTable(this.ctx));
            this.tableImplementor = newTableImplementor;
            return oldTableImplementor;
        }

        @Override
        protected void leave(Field field, Object enterValue) {
            this.tableImplementor = (TableImplementor)enterValue;
        }
    }
}

