/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.time.temporal.Temporal;
import java.util.Date;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ExistsPredicate;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.SubQueryFunctionExpression;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;

public class MergedTypedSubQueryImpl<R>
extends AbstractExpression<R>
implements TypedSubQuery<R>,
TypedQueryImplementor {
    private final JSqlClientImplementor sqlClient;
    private final String operator;
    private final TypedQueryImplementor[] queries;
    private final List<Selection<?>> selections;

    private MergedTypedSubQueryImpl(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<R>[] queries) {
        this.sqlClient = sqlClient;
        this.operator = operator;
        TypedQueryImplementor[] arr = new TypedQueryImplementor[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            arr[i] = (TypedQueryImplementor)((Object)queries[i]);
        }
        this.queries = arr;
        this.selections = MergedTypedSubQueryImpl.mergedSelections(this.queries);
    }

    @SafeVarargs
    public static <R> TypedSubQuery<R> of(String operator, TypedSubQuery<R> ... queries) {
        if (queries.length == 0) {
            throw new IllegalArgumentException("No queries are specified");
        }
        JSqlClientImplementor sqlClient = ((TypedQueryImplementor)((Object)queries[0])).getSqlClient();
        return MergedTypedSubQueryImpl.of(sqlClient, operator, queries);
    }

    @SafeVarargs
    public static <R> TypedSubQuery<R> of(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<R> ... queries) {
        switch (queries.length) {
            case 0: {
                throw new IllegalArgumentException("No queries are specified");
            }
            case 1: {
                return queries[0];
            }
        }
        Class type = queries[0].getType();
        if (type == String.class) {
            return new Str(sqlClient, operator, (TypedSubQuery<String>[])queries);
        }
        if (Number.class.isAssignableFrom(type)) {
            return new Num<R>(sqlClient, operator, (TypedSubQuery<N>[])queries);
        }
        if (Date.class.isAssignableFrom(type)) {
            return new Dt<R>(sqlClient, operator, (TypedSubQuery<T>[])queries);
        }
        if (Temporal.class.isAssignableFrom(type)) {
            return new Tp<R>(sqlClient, operator, (TypedSubQuery<T>[])queries);
        }
        if (Comparable.class.isAssignableFrom(type)) {
            return new Cmp<R>(sqlClient, operator, (TypedSubQuery<T>[])queries);
        }
        return new MergedTypedSubQueryImpl<R>(sqlClient, operator, queries);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        for (TypedQueryImplementor query : this.queries) {
            query.accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
        boolean addOperator = false;
        for (TypedQueryImplementor query : this.queries) {
            if (addOperator) {
                ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.space('?')).sql(this.operator)).space('?');
            } else {
                addOperator = true;
            }
            query.renderTo(builder);
        }
        builder.leave();
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        for (TypedQueryImplementor query : this.queries) {
            if (!MergedTypedSubQueryImpl.hasVirtualPredicate(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        for (TypedQueryImplementor query : this.queries) {
            ctx.resolveVirtualPredicate(query);
        }
        return this;
    }

    @Override
    public Class<R> getType() {
        return ((ExpressionImplementor)((Object)this.queries[0])).getType();
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    @Override
    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    @Override
    public Expression<R> all() {
        return new SubQueryFunctionExpression.All(this);
    }

    @Override
    public Expression<R> any() {
        return new SubQueryFunctionExpression.Any(this);
    }

    @Override
    public Predicate exists() {
        return ExistsPredicate.of(this, false);
    }

    @Override
    public Predicate notExists() {
        return ExistsPredicate.of(this, true);
    }

    private static List<Selection<?>> mergedSelections(TypedQueryImplementor[] queries) {
        List<Selection<?>> selections = queries[0].getSelections();
        int size = selections.size();
        for (int i = 0; i < queries.length; ++i) {
            List<Selection<?>> otherSelections = queries[i].getSelections();
            if (size != otherSelections.size()) {
                throw new IllegalArgumentException("Cannot merged sub queries with different selections");
            }
            for (int index = 0; index < size; ++index) {
                if (MergedTypedSubQueryImpl.isSameType(selections.get(index), otherSelections.get(index))) continue;
                throw new IllegalArgumentException("Cannot merged sub queries with different selections");
            }
        }
        return selections;
    }

    private static boolean isSameType(Selection<?> a, Selection<?> b) {
        if (a instanceof Table && b instanceof Table) {
            return ((Table)a).getImmutableType() == ((Table)b).getImmutableType();
        }
        if (a instanceof Expression && b instanceof Expression) {
            return ((ExpressionImplementor)a).getType() == ((ExpressionImplementor)b).getType();
        }
        return false;
    }

    static class Str
    extends MergedTypedSubQueryImpl<String>
    implements TypedSubQuery.Str,
    StringExpressionImplementor {
        Str(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<String>[] queries) {
            super(sqlClient, operator, queries);
        }
    }

    private static class Num<N extends Number>
    extends MergedTypedSubQueryImpl<N>
    implements TypedSubQuery.Num<N>,
    NumericExpressionImplementor<N> {
        Num(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<N>[] queries) {
            super(sqlClient, operator, queries);
        }
    }

    private static class Dt<T extends Date>
    extends MergedTypedSubQueryImpl<T>
    implements TypedSubQuery.Dt<T>,
    DateExpressionImplementor<T> {
        Dt(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<T>[] queries) {
            super(sqlClient, operator, queries);
        }
    }

    private static class Tp<T extends Temporal & Comparable<?>>
    extends MergedTypedSubQueryImpl<T>
    implements TypedSubQuery.Tp<T>,
    TemporalExpressionImplementor<T> {
        Tp(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<T>[] queries) {
            super(sqlClient, operator, queries);
        }
    }

    private static class Cmp<T extends Comparable<?>>
    extends MergedTypedSubQueryImpl<T>
    implements TypedSubQuery.Cmp<T>,
    ComparableExpressionImplementor<T> {
        Cmp(JSqlClientImplementor sqlClient, String operator, TypedSubQuery<T>[] queries) {
            super(sqlClient, operator, queries);
        }
    }
}

