/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionAliasRender;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.PaginationContextImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.query.TypedBaseQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TupleCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractConfigurableTypedQueryImpl
implements TypedQueryImplementor {
    private final TypedQueryData data;
    private AbstractMutableQueryImpl mutableQuery;

    public AbstractConfigurableTypedQueryImpl(TypedQueryData data, AbstractMutableQueryImpl mutableQuery) {
        this.data = data;
        this.mutableQuery = mutableQuery;
    }

    public AbstractMutableQueryImpl getMutableQuery() {
        return this.mutableQuery;
    }

    public TypedQueryData getData() {
        return this.data;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.data.selections;
    }

    @Override
    public TupleCreator<?> getTupleCreator() {
        return this.data.tupleCreator;
    }

    @Override
    public JSqlClientImplementor getSqlClient() {
        return this.mutableQuery.getSqlClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@NotNull AstVisitor visitor) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this.getMutableQuery());
        try {
            PropExpressionImplementor<?> idOnlySelection = this.idOnlyPropExprByOffset();
            if (idOnlySelection != null) {
                this.mutableQuery.accept(visitor, Collections.singletonList(idOnlySelection), false);
            } else {
                this.mutableQuery.accept(visitor, this.data.oldSelections, this.data.withoutSortingAndPaging);
                for (Selection<?> selection : this.data.selections) {
                    Ast.from(selection, visitor.getAstContext()).accept(visitor);
                }
                this.visitBaseTable(this.mutableQuery.getTableLikeImplementor(), visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void visitBaseTable(TableLikeImplementor<?> tableLikeImplementor, AstVisitor visitor) {
        if (tableLikeImplementor instanceof BaseTableImplementor) {
            RealTable realBaseTable = tableLikeImplementor.realTable(visitor.getAstContext());
            this.visitBaseTableImpl(realBaseTable, visitor);
        } else {
            TableImplementor tableImplementor = (TableImplementor)tableLikeImplementor;
            if (tableImplementor.hasBaseTable()) {
                Iterable children = (Iterable)((Object)tableImplementor);
                for (TableLikeImplementor child : children) {
                    this.visitBaseTable(child, visitor);
                }
            }
        }
    }

    private void visitBaseTableImpl(RealTable realBaseTable, AstVisitor visitor) {
        realBaseTable.getTableLikeImplementor().accept(visitor);
        for (RealTable childBaseTable : realBaseTable) {
            this.visitBaseTableImpl(childBaseTable, visitor);
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> abstractBuilder) {
        this.renderTo(abstractBuilder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void renderTo(@NotNull AbstractSqlBuilder<?> abstractBuilder, @Nullable BaseSelectionAliasRender render) {
        SqlBuilder builder = abstractBuilder.assertSimple();
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this.getMutableQuery());
        try {
            if (this.data.withoutSortingAndPaging || this.data.offset == 0L && this.data.limit == Integer.MAX_VALUE) {
                this.renderWithoutPaging(builder, null, render);
            } else {
                PropExpressionImplementor<?> idPropExpr = this.idOnlyPropExprByOffset();
                if (idPropExpr != null) {
                    this.renderIdOnlyQuery(idPropExpr, builder);
                } else {
                    SqlBuilder subBuilder = builder.createChildBuilder();
                    this.renderWithoutPaging(subBuilder, null, render);
                    subBuilder.build(result -> {
                        PaginationContextImpl ctx = new PaginationContextImpl(this.getMutableQuery().getSqlClient().getSqlFormatter(), this.data.limit, this.data.offset, (String)result.get_1(), (List)result.get_2(), (List)result.get_3(), false);
                        this.mutableQuery.getSqlClient().getDialect().paginate(ctx);
                        return ctx.build();
                    });
                }
            }
            if (this.data.forUpdate != null) {
                this.getSqlClient().getDialect().renderForUpdate(builder, this.data.forUpdate);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    @Override
    public boolean hasVirtualPredicate() {
        return this.mutableQuery.hasVirtualPredicate();
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        this.mutableQuery = ctx.resolveVirtualPredicate(this.mutableQuery);
        return this;
    }

    private void renderWithoutPaging(SqlBuilder builder, PropExpressionImplementor<?> idPropExpr, BaseSelectionAliasRender render) {
        List<RealTable> cteTables = this.getCteTables(builder.getAstContext());
        if (cteTables.isEmpty()) {
            this.renderWithoutPagingImpl(builder, idPropExpr, render);
        } else {
            SqlBuilder tmpBuilder = builder.createTempBuilder();
            this.renderWithoutPagingImpl(tmpBuilder, idPropExpr, render);
            builder.sql("with ");
            for (RealTable cteTable : cteTables) {
                if (!((BaseTableImplementor)cteTable.getTableLikeImplementor()).isRecursiveCte()) continue;
                builder.sql("recursive ");
                break;
            }
            builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (RealTable cteTable : cteTables) {
                builder.separator();
                BaseTableImplementor baseTableImplementor = (BaseTableImplementor)cteTable.getTableLikeImplementor();
                BaseSelectionAliasRender cteRender = builder.getAstContext().getBaseSelectionRender(baseTableImplementor.toSymbol().getQuery());
                assert (cteRender != null);
                builder.sql(cteTable.getAlias());
                cteRender.renderCteColumns(cteTable, builder);
                builder.sql(" as ");
                cteTable.renderTo(builder, true);
            }
            ((SqlBuilder)builder.leave()).sql(" ");
            builder.appendTempBuilder(tmpBuilder);
        }
    }

    private List<RealTable> getCteTables(AstContext ctx) {
        TableLikeImplementor<?> tableLikeImplementor = this.getMutableQuery().getTableLikeImplementor();
        if (!tableLikeImplementor.hasBaseTable()) {
            return Collections.emptyList();
        }
        RealTable realTable = tableLikeImplementor.realTable(ctx);
        ArrayList<RealTable> cteTables = new ArrayList<RealTable>();
        this.collectCteTables(realTable, cteTables);
        return cteTables;
    }

    private void collectCteTables(RealTable realTable, List<RealTable> cteTables) {
        BaseTableImplementor baseTableImplementor;
        if (realTable.getTableLikeImplementor() instanceof BaseTableImplementor && !(this instanceof TypedBaseQuery) && (baseTableImplementor = (BaseTableImplementor)realTable.getTableLikeImplementor()).isCte()) {
            cteTables.add(realTable);
        }
        for (RealTable child : realTable) {
            this.collectCteTables(child, cteTables);
        }
    }

    private void renderWithoutPagingImpl(SqlBuilder builder, PropExpressionImplementor<?> idPropExpr, BaseSelectionAliasRender render) {
        builder.enter(this.data.distinct ? AbstractSqlBuilder.ScopeType.SELECT_DISTINCT : AbstractSqlBuilder.ScopeType.SELECT);
        if (this.data.hint != null) {
            ((SqlBuilder)((SqlBuilder)builder.sql(" ")).sql(this.data.hint)).sql(" ");
        }
        if (render != null) {
            List<Selection<?>> selections = this.data.selections;
            int size = selections.size();
            for (int i = 0; i < size; ++i) {
                Selection<?> selection = selections.get(i);
                render.render(i, selection, builder);
            }
        } else if (idPropExpr != null) {
            TableImplementor<?> tableImplementor = TableProxies.resolve(idPropExpr.getTable(), builder.getAstContext());
            tableImplementor.renderSelection(tableImplementor.getImmutableType().getIdProp(), idPropExpr.isRawId(), builder, null, true, OffsetOptimizationWriter::idAlias);
        } else {
            this.renderSelections(builder);
            this.fakeRenderExportedForeignKeys(this.mutableQuery.getTableLikeImplementor(), builder);
        }
        builder.leave();
        this.mutableQuery.renderTo(builder, this.data.withoutSortingAndPaging, this.data.reverseSorting);
    }

    private void renderSelections(SqlBuilder builder) {
        for (Selection<?> selection : this.data.selections) {
            TableImplementor tableSelection;
            builder.separator();
            if (selection instanceof TableSelection) {
                tableSelection = (TableImplementor)selection;
                AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
                continue;
            }
            if (selection instanceof Table) {
                tableSelection = TableProxies.resolve((Table)selection, builder.getAstContext());
                AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
                continue;
            }
            Ast ast = Ast.from(selection, builder.getAstContext());
            if (ast instanceof PropExpressionImplementor) {
                ((PropExpressionImplementor)((Object)ast)).renderTo(builder, true);
                continue;
            }
            ast.renderTo(builder);
        }
    }

    private void fakeRenderExportedForeignKeys(TableLikeImplementor<?> tableLikeImplementor, SqlBuilder builder) {
        if (tableLikeImplementor instanceof BaseTableImplementor) {
            this.fakeRenderExportedForeignKeysImpl((BaseTableImplementor)tableLikeImplementor, builder);
        } else {
            TableImplementor tableImplementor = (TableImplementor)tableLikeImplementor;
            if (tableImplementor.hasBaseTable()) {
                Iterable children = (Iterable)((Object)tableImplementor);
                for (TableLikeImplementor child : children) {
                    this.fakeRenderExportedForeignKeys(child, builder);
                }
            }
        }
    }

    private void fakeRenderExportedForeignKeysImpl(BaseTableImplementor baseTableImplementor, SqlBuilder builder) {
        AstContext ctx = builder.getAstContext();
        block0: for (Selection<?> selection : baseTableImplementor.toSymbol().getSelections()) {
            if (!(selection instanceof Table)) continue;
            Table table = (Table)selection;
            TableImplementor tableImplementor = TableProxies.resolve(table, ctx);
            BaseSelectionMapper mapper = ctx.getBaseSelectionMapper(tableImplementor.getBaseTableOwner());
            assert (mapper != null);
            RealTable realTable = tableImplementor.realTable(ctx);
            for (RealTable childTable : realTable) {
                if (!(childTable.getTableLikeImplementor() instanceof TableImplementor)) continue;
                TableImplementor childTableImplementor = (TableImplementor)childTable.getTableLikeImplementor();
                ImmutableProp prop = childTableImplementor.getJoinProp();
                if (prop == null) continue block0;
                if (childTableImplementor.isInverse() && (prop = prop.getOpposite()) == null || !prop.isColumnDefinition()) continue;
                ColumnDefinition definition = (ColumnDefinition)prop.getStorage(builder.sqlClient().getMetadataStrategy());
                int size = definition.size();
                for (int i = 0; i < size; ++i) {
                    mapper.columnIndex(realTable.getAlias(), definition.name(i));
                }
            }
        }
    }

    private PropExpressionImplementor<?> idOnlyPropExprByOffset() {
        if (this.data.offset >= (long)this.mutableQuery.getSqlClient().getOffsetOptimizingThreshold()) {
            return this.data.getIdOnlyExpression();
        }
        return null;
    }

    private static void renderAllProps(TableSelection table, SqlBuilder builder) {
        Map selectableProps = table.getImmutableType().getSelectableProps();
        for (ImmutableProp prop : selectableProps.values()) {
            builder.separator();
            table.renderSelection(prop, true, builder, null);
        }
    }

    private void renderIdOnlyQuery(PropExpressionImplementor<?> idPropExpr, SqlBuilder builder) {
        MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
        OffsetOptimizationWriter writer = new OffsetOptimizationWriter(builder, strategy);
        TableImplementor<?> tableImplementor = TableProxies.resolve(idPropExpr.getTable(), builder.getAstContext());
        builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
        if (this.data.selections.get(0) instanceof FetcherSelection) {
            for (Field field : ((FetcherSelection)this.data.selections.get(0)).getFetcher().getFieldMap().values()) {
                writer.prop(field.getProp(), "optimize_", false);
            }
        } else {
            for (ImmutableProp prop : tableImplementor.getImmutableType().getSelectableProps().values()) {
                writer.prop(prop, "optimize_", false);
            }
        }
        builder.leave();
        builder.from().enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
        SqlBuilder subBuilder = builder.createChildBuilder();
        this.renderWithoutPaging(subBuilder, idPropExpr, null);
        subBuilder.build(result -> {
            PaginationContextImpl ctx = new PaginationContextImpl(this.getMutableQuery().getSqlClient().getSqlFormatter(), this.data.limit, this.data.offset, (String)result.get_1(), (List)result.get_2(), (List)result.get_3(), true);
            this.mutableQuery.getSqlClient().getDialect().paginate(ctx);
            return ctx.build();
        });
        ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.leave()).sql(" ")).sql("optimize_core_")).sql(" inner join ")).sql(tableImplementor.getImmutableType().getTableName(strategy))).sql(" ")).sql("optimize_")).on();
        writer.prop(tableImplementor.getImmutableType().getIdProp(), "optimize_", true);
        builder.sql(" = ");
        int size = ((ColumnDefinition)tableImplementor.getImmutableType().getIdProp().getStorage(strategy)).size();
        if (size == 1) {
            ((SqlBuilder)builder.sql("optimize_core_")).sql(".");
            builder.sql(OffsetOptimizationWriter.idAlias(0));
        } else {
            builder.sql("(");
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    builder.sql(", ");
                }
                ((SqlBuilder)builder.sql("optimize_core_")).sql(".");
                builder.sql(OffsetOptimizationWriter.idAlias(i));
            }
            builder.sql(")");
        }
        if (this.getMutableQuery().getSqlClient().getDialect().getOffsetOptimizationNumField() != null) {
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.enter(AbstractSqlBuilder.ScopeType.ORDER_BY)).sql("optimize_core_")).sql(".")).sql("optimize_rn__")).leave();
        }
    }

    private static class OffsetOptimizationWriter {
        private static final String ALIAS = "optimize_";
        private static final String CORE_ALIAS = "optimize_core_";
        private static final String CORE_ID_ALIAS = "optimize_core_id_";
        private static final String ROW_NUMBER_ALIAS = "optimize_rn__";
        private final SqlBuilder builder;
        private final MetadataStrategy strategy;

        OffsetOptimizationWriter(SqlBuilder builder, MetadataStrategy strategy) {
            this.builder = builder;
            this.strategy = strategy;
        }

        public void prop(ImmutableProp prop, String alias, boolean multiColumnsAsTuple) {
            SqlTemplate template = prop.getSqlTemplate();
            if (template instanceof FormulaTemplate) {
                ((SqlBuilder)this.builder.separator()).sql(((FormulaTemplate)template).toSql(alias));
                return;
            }
            Storage storage = prop.getStorage(this.strategy);
            if (storage instanceof ColumnDefinition) {
                ColumnDefinition definition = (ColumnDefinition)storage;
                int size = definition.size();
                if (size == 1) {
                    ((SqlBuilder)((SqlBuilder)((SqlBuilder)this.builder.separator()).sql(alias)).sql(".")).sql(definition.name(0));
                } else if (multiColumnsAsTuple) {
                    this.builder.enter(AbstractSqlBuilder.ScopeType.TUPLE);
                    for (int i = 0; i < size; ++i) {
                        ((SqlBuilder)((SqlBuilder)((SqlBuilder)this.builder.separator()).sql(alias)).sql(".")).sql(definition.name(i));
                    }
                    this.builder.leave();
                } else {
                    for (int i = 0; i < size; ++i) {
                        ((SqlBuilder)((SqlBuilder)((SqlBuilder)this.builder.separator()).sql(alias)).sql(".")).sql(definition.name(i));
                    }
                }
            }
        }

        public static String idAlias(int index) {
            return index == 0 ? CORE_ID_ALIAS : CORE_ID_ALIAS + index + '_';
        }
    }
}

