/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;

class Shape {
    private final ImmutableType type;
    private final List<PropertyGetter> getters;
    private final int hash;
    private Map<ImmutableProp, List<PropertyGetter>> getterMap;
    private Set<PropertyGetter> getterSet;
    private List<PropertyGetter> columnDefinitionGetters;
    private Boolean isIdOnly;

    private Shape(ImmutableType type, List<PropertyGetter> getters) {
        this.type = type;
        this.getters = getters;
        this.hash = getters.hashCode();
    }

    public static Shape of(JSqlClientImplementor sqlClient, ImmutableSpi spi, Predicate<ImmutableProp> propFilter) {
        return new Shape(spi.__type(), PropertyGetter.entityGetters(sqlClient, spi.__type(), spi, propFilter));
    }

    public static Shape fullOf(JSqlClientImplementor sqlClient, Class<?> type) {
        ImmutableType immutableType = ImmutableType.get(type);
        return new Shape(immutableType, PropertyGetter.entityGetters(sqlClient, immutableType, null, null));
    }

    @NotNull
    public ImmutableType getType() {
        return this.type;
    }

    @NotNull
    public List<PropertyGetter> getGetters() {
        return this.getters;
    }

    public boolean isIdOnly() {
        Boolean isIdOnly = this.isIdOnly;
        if (isIdOnly == null) {
            boolean hasId = false;
            boolean hasNonId = false;
            for (PropertyGetter getter : this.getters) {
                if (getter.prop().isId()) {
                    hasId = true;
                    continue;
                }
                hasNonId = true;
                break;
            }
            this.isIdOnly = isIdOnly = Boolean.valueOf(hasId && !hasNonId);
        }
        return isIdOnly;
    }

    public boolean isWild(Set<ImmutableProp> keyProps) {
        for (PropertyGetter getter : this.getters) {
            if (getter.prop().isId()) {
                return false;
            }
            if (keyProps == null || !keyProps.contains(getter.prop())) continue;
            return false;
        }
        return true;
    }

    public Map<ImmutableProp, List<PropertyGetter>> getGetterMap() {
        Map<ImmutableProp, List<PropertyGetter>> getterMap = this.getterMap;
        if (getterMap == null) {
            getterMap = new TreeMap<ImmutableProp, List<PropertyGetter>>(Comparator.comparing(ImmutableProp::getName));
            for (PropertyGetter propertyGetter : this.getters) {
                getterMap.computeIfAbsent(propertyGetter.prop(), it -> new ArrayList()).add(propertyGetter);
            }
            for (Map.Entry entry : getterMap.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
            this.getterMap = getterMap = Collections.unmodifiableMap(getterMap);
        }
        return getterMap;
    }

    public List<PropertyGetter> getColumnDefinitionGetters() {
        List<PropertyGetter> columnDefinitionGetters = this.columnDefinitionGetters;
        if (columnDefinitionGetters == null) {
            columnDefinitionGetters = new ArrayList<PropertyGetter>();
            for (PropertyGetter getter : this.getters) {
                if (!getter.prop().isColumnDefinition()) continue;
                columnDefinitionGetters.add(getter);
            }
            this.columnDefinitionGetters = columnDefinitionGetters;
        }
        return columnDefinitionGetters;
    }

    public List<PropertyGetter> getIdGetters() {
        return this.propertyGetters(this.type.getIdProp());
    }

    public PropertyGetter getVersionGetter() {
        List<PropertyGetter> items = this.propertyGetters(this.type.getVersionProp());
        return items.isEmpty() ? null : items.get(0);
    }

    public List<PropertyGetter> propertyGetters(ImmutableProp prop) {
        List<PropertyGetter> items = prop == null ? null : this.getGetterMap().get(prop);
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    public boolean contains(PropertyGetter getter) {
        Set<PropertyGetter> set = this.getterSet;
        if (set == null) {
            this.getterSet = set = new HashSet<PropertyGetter>(this.getters);
        }
        return set.contains(getter);
    }

    public KeyMatcher.Group group(KeyMatcher keyMatcher) {
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>(this.getters.size());
        for (PropertyGetter getter : this.getters) {
            props.add(getter.prop());
        }
        return keyMatcher.match(props);
    }

    public Set<ImmutableProp> keyProps(KeyMatcher keyMatcher) {
        KeyMatcher.Group group = this.group(keyMatcher);
        if (group == null) {
            return Collections.emptySet();
        }
        return group.getProps();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Shape)) {
            return false;
        }
        Shape other = (Shape)obj;
        return this.hash == other.hash && this.getters.equals(other.getters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean addComma = false;
        for (PropertyGetter getter : this.getters) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(getter);
        }
        builder.append(']');
        return builder.toString();
    }
}

