/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.Tuples;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.Nullable;

class Rows {
    private Rows() {
    }

    static Map<Object, ImmutableSpi> findMapByIds(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows) {
        List<ImmutableSpi> entities = Rows.findByIds(ctx, queryReason, fetcher, rows);
        if (entities.isEmpty()) {
            return new HashMap<Object, ImmutableSpi>();
        }
        PropId idPropId = ctx.path.getType().getIdProp().getId();
        LinkedHashMap<Object, ImmutableSpi> map = new LinkedHashMap<Object, ImmutableSpi>((entities.size() * 4 + 2) / 3);
        for (ImmutableSpi entity : entities) {
            map.put(entity.__get(idPropId), entity);
        }
        return map;
    }

    static List<ImmutableSpi> findByIds(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows) {
        PropId idPropId = ctx.path.getType().getIdProp().getId();
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>((rows.size() * 4 + 2) / 3);
        for (ImmutableSpi immutableSpi : rows) {
            if (!immutableSpi.__isLoaded(idPropId)) continue;
            ids.add(immutableSpi.__get(idPropId));
        }
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return Rows.findRows(ctx, queryReason, fetcher, (q, t) -> q.where(t.getId().in(ids)));
    }

    static Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> findMapByKeys(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows) {
        return Rows.findMapByKeys(ctx, queryReason, fetcher, rows, null);
    }

    static Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> findMapByKeys(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows, @Nullable KeyMatcher.Group fixedGroup) {
        Map<KeyMatcher.Group, List<ImmutableSpi>> entityMap = Rows.findByKeys(ctx, queryReason, fetcher, rows, fixedGroup);
        if (entityMap.isEmpty()) {
            return new HashMap<KeyMatcher.Group, Map<Object, ImmutableSpi>>();
        }
        LinkedHashMap<KeyMatcher.Group, Map<Object, ImmutableSpi>> resultMap = new LinkedHashMap<KeyMatcher.Group, Map<Object, ImmutableSpi>>((entityMap.size() * 4 + 2) / 3);
        for (Map.Entry<KeyMatcher.Group, List<ImmutableSpi>> e : entityMap.entrySet()) {
            KeyMatcher.Group group = e.getKey();
            List<ImmutableSpi> spis = e.getValue();
            LinkedHashMap<Object, ImmutableSpi> keyMap = new LinkedHashMap<Object, ImmutableSpi>((rows.size() * 4 + 2) / 3);
            for (ImmutableSpi spi : spis) {
                Object key = Keys.keyOf(spi, group.getProps());
                ImmutableSpi conflictEntity = keyMap.put(key, spi);
                if (conflictEntity == null) continue;
                throw ctx.createConflictKey(group.getProps(), key);
            }
            for (KeyMatcher.Group otherGroup : entityMap.keySet()) {
                if (group.getName().equals(otherGroup.getName())) continue;
                HashSet<Object> keys = new HashSet<Object>();
                for (ImmutableSpi spi : spis) {
                    Object key = Keys.keyOf(spi, otherGroup.getProps());
                    if (keys.add(key)) continue;
                    throw ctx.createConflictKey(otherGroup.getProps(), key);
                }
            }
            resultMap.put(group, keyMap);
        }
        return resultMap;
    }

    static Map<KeyMatcher.Group, List<ImmutableSpi>> findByKeys(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows, @Nullable KeyMatcher.Group fixedGroup) {
        if (rows.isEmpty()) {
            return Collections.emptyMap();
        }
        KeyMatcher keyMatcher = ctx.options.getKeyMatcher(ctx.path.getType());
        if (keyMatcher.toMap().size() == 1 || fixedGroup != null) {
            if (fixedGroup == null) {
                fixedGroup = keyMatcher.getGroup((String)keyMatcher.toMap().keySet().iterator().next());
            }
            Set keyProps = fixedGroup.getProps();
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>((rows.size() * 4 + 2) / 3);
            for (ImmutableSpi immutableSpi : rows) {
                boolean unloaded = false;
                for (ImmutableProp keyProp : keyProps) {
                    if (immutableSpi.__isLoaded(keyProp.getId())) continue;
                    unloaded = true;
                    break;
                }
                if (unloaded) continue;
                keys.add(Keys.keyOf(immutableSpi, keyProps));
            }
            if (keys.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(fixedGroup, Rows.findByKeys(ctx, queryReason, fetcher, keyProps, keys));
        }
        LinkedHashMap<KeyMatcher.Group, Set> keyMultiMap = new LinkedHashMap<KeyMatcher.Group, Set>();
        for (ImmutableSpi immutableSpi : rows) {
            KeyMatcher.Group group = keyMatcher.match((Object)immutableSpi);
            if (group == null) {
                ctx.throwNeitherIdNorKey(ctx.path.getType(), (Set)keyMatcher.toMap().values().iterator().next());
                continue;
            }
            keyMultiMap.computeIfAbsent(group, it -> new LinkedHashSet()).add(Keys.keyOf(immutableSpi, group.getProps()));
        }
        if (keyMultiMap.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<KeyMatcher.Group, List<ImmutableSpi>> resultMap = new LinkedHashMap<KeyMatcher.Group, List<ImmutableSpi>>();
        for (Map.Entry entry : keyMultiMap.entrySet()) {
            KeyMatcher.Group group = (KeyMatcher.Group)entry.getKey();
            List<ImmutableSpi> list = Rows.findByKeys(ctx, queryReason, fetcher, group.getProps(), (Set)entry.getValue());
            resultMap.put(group, list);
        }
        return resultMap;
    }

    static List<ImmutableSpi> findRows(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, BiConsumer<MutableQuery, Table<?>> block) {
        ImmutableType type = ctx.path.getType();
        SaveOptions options = ctx.options;
        return (List)Internal.requiresNewDraftContext(draftContext -> {
            List list = (List)Queries.createQuery(options.getSqlClient(), type, ExecutionPurpose.command(queryReason), FilterLevel.IGNORE_USER_FILTERS, (q, table) -> {
                block.accept((MutableQuery)q, (Table<?>)table);
                if (ctx.trigger != null) {
                    return q.select(table);
                }
                return q.select(table.fetch(fetcher));
            }).forUpdate(options.isPessimisticLocked(type)).execute(ctx.con);
            return draftContext.resolveList(list);
        });
    }

    static List<ImmutableSpi> findRows(JSqlClientImplementor sqlClient, Connection con, ImmutableType type, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, BiConsumer<MutableQuery, Table<?>> block) {
        return (List)Internal.requiresNewDraftContext(draftContext -> {
            List list = (List)Queries.createQuery(sqlClient, type, ExecutionPurpose.command(queryReason), FilterLevel.IGNORE_USER_FILTERS, (q, table) -> {
                block.accept((MutableQuery)q, (Table<?>)table);
                return q.select(table.fetch(fetcher));
            }).execute(con);
            return draftContext.resolveList(list);
        });
    }

    private static List<ImmutableSpi> findByKeys(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Set<ImmutableProp> keyProps, Set<Object> keys) {
        return Rows.findRows(ctx, queryReason, fetcher, (q, t) -> {
            Expression<Object> keyExpr;
            if (keyProps.size() == 1) {
                ImmutableProp prop = (ImmutableProp)keyProps.iterator().next();
                keyExpr = prop.isReference(TargetLevel.PERSISTENT) ? t.getAssociatedId(prop) : t.get(prop);
            } else {
                Expression[] arr = new Expression[keyProps.size()];
                int index = 0;
                for (ImmutableProp keyProp : keyProps) {
                    PropExpression expr = keyProp.isReference(TargetLevel.PERSISTENT) ? t.getAssociatedId(keyProp) : t.get(keyProp);
                    arr[index++] = expr;
                }
                keyExpr = Tuples.expressionOf(arr);
            }
            q.where(keyExpr.nullableIn(keys));
        });
    }
}

