/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.OptimisticLockValueFactoryFactories;
import org.babyfish.jimmer.sql.ast.impl.mutation.AffectedRows;
import org.babyfish.jimmer.sql.ast.impl.mutation.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntityCollection;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntityInvestigator;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntityList;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.UnloadedVersionBehavior;
import org.babyfish.jimmer.sql.ast.mutation.UpsertMask;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.SavepointManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Operator {
    private static final String GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON = "Joining is disabled in general optimistic lock";
    private static final int[] SIMPLE_ILLEGAL_ROW_COUNTS = new int[]{-1};
    private static final int[] EMPTY_ROW_COUNTS = new int[0];
    final SaveContext ctx;

    Operator(SaveContext ctx) {
        this.ctx = ctx;
    }

    private static int rowCount(int[] rowCounts) {
        int sumRowCount = 0;
        for (int rowCount : rowCounts) {
            if (rowCount == 0) continue;
            ++sumRowCount;
        }
        return sumRowCount;
    }

    public void insert(Batch<DraftSpi> batch) {
        MutationTrigger trigger;
        List<ImmutableProp> conflictProps;
        UpsertMask<?> upsertMask;
        if (batch.entities().isEmpty() || batch.shape().isIdOnly()) {
            return;
        }
        this.validate(batch.shape(), true);
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        ArrayList<PropertyGetter> defaultGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass()).getGetters()) {
            if (!getter.metadata().hasDefaultValue() || batch.shape().contains(getter)) continue;
            defaultGetters.add(getter);
        }
        IdentityIdGenerator identityIdGenerator = null;
        SequenceIdGenerator sequenceIdGenerator = null;
        UserIdGenerator userIdGenerator = null;
        if (batch.shape().getIdGetters().isEmpty()) {
            IdGenerator idGenerator = sqlClient.getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof SequenceIdGenerator) {
                sequenceIdGenerator = (SequenceIdGenerator)idGenerator;
            } else if (idGenerator instanceof UserIdGenerator) {
                userIdGenerator = (UserIdGenerator)idGenerator;
            } else if (idGenerator instanceof IdentityIdGenerator) {
                identityIdGenerator = (IdentityIdGenerator)idGenerator;
            } else {
                this.ctx.throwIllegalIdGenerator("In order to insert object without id, the id generator must be identity or sequence");
            }
        }
        if (userIdGenerator != null) {
            Class javaType = this.ctx.path.getType().getJavaClass();
            PropId idPropId = this.ctx.path.getType().getIdProp().getId();
            for (DraftSpi draft : batch.entities()) {
                Object id = userIdGenerator.generate(javaType);
                if (id == null || id.getClass() != this.ctx.path.getType().getIdProp().getReturnClass()) {
                    this.ctx.throwIllegalGeneratedId(id);
                }
                draft.__set(idPropId, id);
            }
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient, batch.entities().size() < 2 || this.ctx.options.isBatchForbidden());
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("insert into ")).sql(this.ctx.path.getType().getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        if (sequenceIdGenerator != null) {
            ((BatchSqlBuilder)builder.separator()).sql(((SingleColumn)this.ctx.path.getType().getIdProp().getStorage(strategy)).getName());
        }
        if (batch.originalMode() == SaveMode.UPSERT) {
            upsertMask = this.ctx.options.getUpsertMask(this.ctx.path.getType());
            if (!batch.shape().getIdGetters().isEmpty()) {
                conflictProps = Collections.singletonList(batch.shape().getType().getIdProp());
            } else {
                Set<ImmutableProp> keyProps = batch.shape().keyProps(this.ctx.options.getKeyMatcher(this.ctx.path.getType()));
                conflictProps = new ArrayList<ImmutableProp>(keyProps);
                LogicalDeletedInfo logicalDeletedInfo = batch.shape().getType().getLogicalDeletedInfo();
                if (logicalDeletedInfo != null) {
                    conflictProps.add(logicalDeletedInfo.getProp());
                }
            }
        } else {
            upsertMask = null;
            conflictProps = Collections.emptyList();
        }
        for (PropertyGetter propertyGetter : batch.shape().getGetters()) {
            if (!propertyGetter.isInsertable(conflictProps, upsertMask)) continue;
            ((BatchSqlBuilder)builder.separator()).sql(propertyGetter);
        }
        for (PropertyGetter propertyGetter : defaultGetters) {
            if (!propertyGetter.isInsertable(conflictProps, upsertMask)) continue;
            ((BatchSqlBuilder)builder.separator()).sql(propertyGetter);
        }
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.leave()).sql(" values")).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        if (sequenceIdGenerator != null) {
            ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql("(")).sql(sqlClient.getDialect().getSelectIdFromSequenceSql(sequenceIdGenerator.getSequenceName()))).sql(")");
        } else if (userIdGenerator != null) {
            Iterator fullShape = Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass());
            builder.separator();
            for (PropertyGetter getter : ((Shape)((Object)fullShape)).getIdGetters()) {
                ((BatchSqlBuilder)builder.separator()).sql(getter);
            }
        }
        for (PropertyGetter propertyGetter : batch.shape().getGetters()) {
            if (!propertyGetter.isInsertable(conflictProps, upsertMask)) continue;
            ((BatchSqlBuilder)builder.separator()).variable(propertyGetter);
        }
        for (PropertyGetter propertyGetter : defaultGetters) {
            if (!propertyGetter.isInsertable(conflictProps, upsertMask)) continue;
            ((BatchSqlBuilder)builder.separator()).defaultVariable(propertyGetter);
        }
        builder.leave();
        if ((identityIdGenerator != null || sequenceIdGenerator != null) && sqlClient.getDialect().isInsertedIdReturningRequired()) {
            ((BatchSqlBuilder)builder.sql(" returning ")).sql(((SingleColumn)batch.shape().getType().getIdProp().getStorage(sqlClient.getMetadataStrategy())).getName());
        }
        if ((trigger = this.ctx.trigger) != null) {
            for (DraftSpi draft : batch.entities()) {
                trigger.modifyEntityTable(null, draft);
            }
        }
        int n = this.execute(builder, batch, false, false);
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), n);
    }

    public void update(Map<Object, ImmutableSpi> originalIdObjMap, Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> originalKeyObjMap, Batch<DraftSpi> batch) {
        EntityList<DraftSpi> entities;
        List<ImmutableProp> conflictProps;
        UpsertMask<?> upsertMask;
        LinkedHashSet<ImmutableProp> changedProps;
        boolean hasOptimisticLock;
        Shape shape = batch.shape();
        this.validate(shape, false);
        KeyMatcher.Group group = shape.getIdGetters().isEmpty() ? shape.group(this.ctx.options.getKeyMatcher(shape.getType())) : null;
        Set keyProps = group != null ? group.getProps() : null;
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        List<PropertyGetter> idGetters = Shape.fullOf(sqlClient, shape.getType().getJavaClass()).getIdGetters();
        if (group != null && idGetters.size() > 1) {
            throw new IllegalArgumentException("Cannot update batch whose shape does not have id when id property is embeddable");
        }
        Predicate userOptimisticLockPredicate = this.userLockOptimisticPredicate();
        PropertyGetter versionGetter = shape.getVersionGetter();
        boolean bl = hasOptimisticLock = userOptimisticLockPredicate != null || versionGetter != null;
        if (hasOptimisticLock && keyProps != null) {
            throw new IllegalArgumentException("Cannot update batch whose shape does not have id when optimistic lock is required");
        }
        if (batch.entities().isEmpty()) {
            return;
        }
        if (this.ctx.options.isIdOnlyAsReference(this.ctx.path.getProp()) && this.ctx.options.getUnloadedVersionBehavior(shape.getType()) == UnloadedVersionBehavior.IGNORE && shape.isIdOnly()) {
            return;
        }
        LinkedHashSet<Object> linkedHashSet = changedProps = originalIdObjMap != null || originalKeyObjMap != null ? new LinkedHashSet<ImmutableProp>() : null;
        if (batch.originalMode() == SaveMode.UPSERT) {
            upsertMask = this.ctx.options.getUpsertMask(this.ctx.path.getType());
            if (!batch.shape().getIdGetters().isEmpty()) {
                conflictProps = Collections.singletonList(batch.shape().getType().getIdProp());
            } else {
                conflictProps = new ArrayList(keyProps);
                LogicalDeletedInfo logicalDeletedInfo = batch.shape().getType().getLogicalDeletedInfo();
                if (logicalDeletedInfo != null) {
                    conflictProps.add(logicalDeletedInfo.getProp());
                }
            }
        } else {
            upsertMask = null;
            conflictProps = Collections.emptyList();
        }
        ArrayList<PropertyGetter> updatedGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : shape.getGetters()) {
            ImmutableProp prop;
            if (!getter.isUpdatable(conflictProps, upsertMask) || (prop = getter.prop()).isId() || prop.isVersion() && userOptimisticLockPredicate == null || !prop.isColumnDefinition() || keyProps != null && keyProps.contains(prop)) continue;
            if (changedProps != null) {
                changedProps.add(prop);
            }
            updatedGetters.add(getter);
        }
        if (updatedGetters.isEmpty() && !hasOptimisticLock) {
            this.fillIds(QueryReason.GET_ID_WHEN_UPDATE_NOTHING, originalKeyObjMap, batch);
            return;
        }
        if (keyProps != null && !sqlClient.getDialect().isIdFetchableByKeyUpdate()) {
            this.fillIds(QueryReason.GET_ID_FOR_KEY_BASE_UPDATE, originalKeyObjMap, batch);
            if (batch.entities().isEmpty()) {
                return;
            }
        }
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient, batch.entities().size() < 2 || this.ctx.options.isBatchForbidden());
        UpdateContextImpl updateContext = new UpdateContextImpl(builder, shape, Shape.fullOf(sqlClient, shape.getType().getJavaClass()).getIdGetters().get(0), keyProps, updatedGetters, userOptimisticLockPredicate, versionGetter);
        sqlClient.getDialect().update(updateContext);
        MutationTrigger trigger = this.ctx.trigger;
        EntityCollection<Object> entityCollection = entities = changedProps != null ? new EntityList(batch.entities().size()) : null;
        if (entities != null || trigger != null) {
            ImmutableSpi oldRow;
            if (keyProps != null) {
                Map subMap = originalIdObjMap != null ? originalKeyObjMap.getOrDefault(group, Collections.emptyMap()) : Collections.emptyMap();
                for (DraftSpi draft : batch.entities()) {
                    oldRow = (ImmutableSpi)subMap.get(Keys.keyOf((ImmutableSpi)draft, keyProps));
                    if (!this.isChanged(changedProps, oldRow, (ImmutableSpi)draft)) continue;
                    if (trigger != null) {
                        trigger.modifyEntityTable(oldRow, draft);
                    }
                    if (entities == null) continue;
                    entities.add(draft);
                }
            } else {
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                for (DraftSpi draft : batch.entities()) {
                    ImmutableSpi immutableSpi = oldRow = originalIdObjMap != null ? originalIdObjMap.get(draft.__get(idPropId)) : null;
                    if (!this.isChanged(changedProps, oldRow, (ImmutableSpi)draft) && !hasOptimisticLock) continue;
                    if (trigger != null) {
                        trigger.modifyEntityTable(oldRow, draft);
                    }
                    if (entities == null) continue;
                    entities.add(draft);
                }
            }
        }
        if (entities == null) {
            entities = batch.entities();
        }
        int[] rowCounts = this.executeAndGetRowCounts(builder, shape, entities, true, false);
        if (versionGetter != null || userOptimisticLockPredicate != null) {
            int index = 0;
            for (DraftSpi row : entities) {
                if (rowCounts[index++] != 0) continue;
                this.ctx.throwOptimisticLockError((ImmutableSpi)row);
            }
        }
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), Operator.rowCount(rowCounts));
    }

    private void fillIds(QueryReason queryReason, Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> originalKeyObjMap, Batch<DraftSpi> batch) {
        KeyMatcher.Group group = batch.shape().group(this.ctx.options.getKeyMatcher(this.ctx.path.getType()));
        Set keyProps = group.getProps();
        Map<KeyMatcher.Group, Map<Object, ImmutableSpi>> keyMap = originalKeyObjMap;
        if (keyMap == null) {
            Fetcher<Object> fetcher = new FetcherImpl<ImmutableSpi>(this.ctx.path.getType().getJavaClass());
            for (ImmutableProp keyProp : keyProps) {
                if (keyProp.isReference(TargetLevel.ENTITY)) {
                    fetcher = fetcher.add(keyProp.getName(), IdOnlyFetchType.RAW);
                    continue;
                }
                fetcher = fetcher.add(keyProp.getName());
            }
            keyMap = Rows.findMapByKeys(this.ctx, queryReason, fetcher, batch.entities());
        }
        Map subMap = keyMap.getOrDefault(group, Collections.emptyMap());
        PropId idPropId = this.ctx.path.getType().getIdProp().getId();
        Iterator itr = batch.entities().iterator();
        while (itr.hasNext()) {
            DraftSpi draft = (DraftSpi)itr.next();
            ImmutableSpi row = (ImmutableSpi)subMap.get(Keys.keyOf((ImmutableSpi)draft, keyProps));
            if (row != null) {
                draft.__set(idPropId, row.__get(idPropId));
                continue;
            }
            itr.remove();
        }
    }

    public void upsert(Batch<DraftSpi> batch, boolean ignoreUpdate) {
        List<PropertyGetter> conflictGetters;
        List<ImmutableProp> conflictProps;
        this.validate(batch.shape(), false);
        if (batch.entities().isEmpty()) {
            return;
        }
        if (this.ctx.options.isIdOnlyAsReference(this.ctx.path.getProp()) && batch.shape().isIdOnly()) {
            return;
        }
        if (this.ctx.trigger != null) {
            throw new AssertionError((Object)"Internal bug: Upsert cannot be called if the trigger is not null");
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        Shape fullShape = Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass());
        ArrayList<PropertyGetter> defaultGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : fullShape.getColumnDefinitionGetters()) {
            if (!getter.metadata().hasDefaultValue() || batch.shape().contains(getter)) continue;
            defaultGetters.add(getter);
        }
        SequenceIdGenerator sequenceIdGenerator = null;
        if (batch.shape().getIdGetters().isEmpty()) {
            IdGenerator idGenerator = sqlClient.getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof SequenceIdGenerator) {
                sequenceIdGenerator = (SequenceIdGenerator)idGenerator;
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                this.ctx.throwIllegalIdGenerator("In order to upsert object without id, the id generator must be IdentityGenerator or Sequence");
            }
        }
        if (!batch.shape().getIdGetters().isEmpty()) {
            conflictProps = Collections.singletonList(batch.shape().getType().getIdProp());
            conflictGetters = batch.shape().getIdGetters();
        } else {
            Set<ImmutableProp> keyProps = batch.shape().keyProps(this.ctx.options.getKeyMatcher(this.ctx.path.getType()));
            conflictProps = new ArrayList<ImmutableProp>(keyProps);
            LogicalDeletedInfo logicalDeletedInfo = batch.shape().getType().getLogicalDeletedInfo();
            if (logicalDeletedInfo != null) {
                conflictProps.add(logicalDeletedInfo.getProp());
            }
            conflictGetters = new ArrayList<PropertyGetter>();
            for (PropertyGetter propertyGetter : fullShape.getGetters()) {
                if (keyProps.contains(propertyGetter.prop())) {
                    conflictGetters.add(propertyGetter);
                    continue;
                }
                if (!propertyGetter.prop().isLogicalDeleted()) continue;
                conflictGetters.add(propertyGetter);
            }
        }
        UpsertMask<?> upsertMask = this.ctx.options.getUpsertMask(batch.shape().getType());
        ArrayList<PropertyGetter> insertedGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter propertyGetter : batch.shape().getColumnDefinitionGetters()) {
            if (!propertyGetter.isInsertable(conflictProps, upsertMask)) continue;
            insertedGetters.add(propertyGetter);
        }
        for (PropertyGetter propertyGetter : defaultGetters) {
            if (!propertyGetter.isInsertable(conflictProps, upsertMask)) continue;
            insertedGetters.add(propertyGetter);
        }
        ArrayList<PropertyGetter> updatedGetters = new ArrayList<PropertyGetter>();
        if (!ignoreUpdate) {
            for (PropertyGetter getter : batch.shape().getGetters()) {
                if (!getter.isUpdatable(conflictProps, upsertMask)) continue;
                updatedGetters.add(getter);
            }
        }
        Predicate predicate = this.userLockOptimisticPredicate();
        PropertyGetter versionGetter = batch.shape().getVersionGetter();
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient, batch.entities().size() < 2 || this.ctx.options.isBatchForbidden());
        UpsertContextImpl upsertContext = new UpsertContextImpl(builder, batch.shape().getIdGetters().isEmpty() ? batch.shape().getType().getIdProp() : null, sequenceIdGenerator, insertedGetters, conflictGetters, updatedGetters, ignoreUpdate, predicate, versionGetter);
        sqlClient.getDialect().upsert(upsertContext);
        int rowCount = this.execute(builder, batch, true, ignoreUpdate);
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), rowCount);
    }

    private void validate(Shape shape, boolean insertOnly) {
        Set<ImmutableProp> keyProps = shape.keyProps(this.ctx.options.getKeyMatcher(shape.getType()));
        if (!insertOnly && shape.isWild(keyProps)) {
            this.ctx.throwNeitherIdNorKey(shape.getType(), keyProps);
        }
        MetadataStrategy strategy = this.ctx.options.getSqlClient().getMetadataStrategy();
        if (!shape.getIdGetters().isEmpty()) {
            ImmutableProp idProp = shape.getType().getIdProp();
            ColumnDefinition definition = (ColumnDefinition)shape.getType().getIdProp().getStorage(strategy);
            if (shape.getIdGetters().size() < definition.size()) {
                this.ctx.throwIncompleteProperty(idProp, "id");
            }
        }
        Map<ImmutableProp, List<PropertyGetter>> getterMap = shape.getGetterMap();
        for (Map.Entry<ImmutableProp, List<PropertyGetter>> e : getterMap.entrySet()) {
            ColumnDefinition definition;
            ImmutableProp prop = e.getKey();
            List<PropertyGetter> getter = e.getValue();
            if (prop.isReference(TargetLevel.ENTITY)) {
                definition = (ColumnDefinition)prop.getStorage(strategy);
                if (getter.size() >= definition.size()) continue;
                this.ctx.throwIncompleteProperty(prop, "associated id");
                continue;
            }
            if (!keyProps.contains(prop)) continue;
            definition = (ColumnDefinition)prop.getStorage(strategy);
            if (getter.size() >= definition.size()) continue;
            this.ctx.throwIncompleteProperty(prop, "key");
        }
    }

    private Predicate userLockOptimisticPredicate() {
        UserOptimisticLock<?, ?> userOptimisticLock = this.ctx.options.getUserOptimisticLock(this.ctx.path.getType());
        if (userOptimisticLock == null) {
            return null;
        }
        MutableRootQueryImpl fakeQuery = new MutableRootQueryImpl(this.ctx.options.getSqlClient(), this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        Table<Object> table = (Table)fakeQuery.getTable();
        table = table instanceof TableImplementor ? new UntypedJoinDisabledTableProxy((TableImplementor)table, GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON) : ((TableProxy)table).__disableJoin(GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON);
        return userOptimisticLock.predicate(table, OptimisticLockValueFactoryFactories.of());
    }

    private boolean isChanged(Set<ImmutableProp> props, ImmutableSpi oldRow, ImmutableSpi newRow) {
        if (oldRow == null) {
            return true;
        }
        boolean changed = false;
        for (ImmutableProp prop : props) {
            boolean isFrozenBackReference;
            PropId propId = prop.getId();
            boolean bl = isFrozenBackReference = this.ctx.backReferenceFrozen && prop == this.ctx.backReferenceProp;
            if (!oldRow.__isLoaded(propId)) {
                if (isFrozenBackReference) {
                    this.ctx.throwUnloadedFrozenBackReference(this.ctx.backReferenceProp);
                }
                changed = true;
                continue;
            }
            Object oldValue = oldRow.__get(propId);
            Object newValue = newRow.__get(propId);
            if (isFrozenBackReference && !Objects.equals(oldValue, newValue)) {
                this.ctx.throwTargetIsNotTransferable(newRow);
                continue;
            }
            if (changed || Objects.equals(oldValue, newValue)) continue;
            changed = true;
        }
        return changed;
    }

    private int[] executeAndGetRowCounts(BatchSqlBuilder builder, Shape shape, EntityCollection<DraftSpi> entities, boolean updatable, boolean ignoreUpdate) {
        if (entities.isEmpty()) {
            return EMPTY_ROW_COUNTS;
        }
        if (entities.size() < 2 || this.ctx.options.isBatchForbidden() || this.isForcedOneByOne(shape, entities)) {
            return this.executeAndGetRowCountsOneByOne(builder, shape, entities, updatable, ignoreUpdate);
        }
        return this.executeAndGetRowCountsByBatch(builder, shape, entities, updatable, ignoreUpdate);
    }

    private boolean isForcedOneByOne(Shape shape, EntityCollection<DraftSpi> entities) {
        if (!this.ctx.options.getSqlClient().getDialect().isBatchDumb()) {
            return false;
        }
        ImmutableProp deepestProp = this.ctx.path.getProp();
        if (deepestProp != null) {
            if (this.ctx.options.getAssociatedMode(deepestProp) == AssociatedSaveMode.REPLACE) {
                return true;
            }
            if (deepestProp.isColumnDefinition()) {
                return true;
            }
        }
        ArrayList<PropId> postAssociationPropIds = new ArrayList<PropId>();
        for (ImmutableProp prop : shape.getType().getProps().values()) {
            if (prop.isColumnDefinition() || !prop.isAssociation(TargetLevel.ENTITY)) continue;
            postAssociationPropIds.add(prop.getId());
        }
        if (postAssociationPropIds.isEmpty()) {
            return false;
        }
        PropId idPropId = shape.getType().getIdProp().getId();
        for (EntityCollection.Item<DraftSpi> item : entities.items()) {
            if (item.getEntity().__isLoaded(idPropId)) continue;
            for (DraftSpi originalEntity : item.getOriginalEntities()) {
                for (PropId postAssociationPropId : postAssociationPropIds) {
                    if (!originalEntity.__isLoaded(postAssociationPropId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int[] executeAndGetRowCountsOneByOne(BatchSqlBuilder builder, Shape shape, EntityCollection<DraftSpi> entities, boolean updatable, boolean ignoreUpdate) {
        JSqlClientImplementor sqlClient = builder.sqlClient();
        Tuple3<String, BatchSqlBuilder.VariableMapper, List<Integer>> tuple = builder.build();
        Executor executor = sqlClient.getExecutor();
        String sql = tuple.get_1();
        BatchSqlBuilder.VariableMapper mapper = tuple.get_2();
        int[] rowCounts = new int[entities.size()];
        int rowIndex = 0;
        ImmutableProp autoIdProp = shape.getIdGetters().isEmpty() ? shape.getType().getIdProp() : null;
        Reader<?> autoIdReader = autoIdProp != null ? sqlClient.getReader(autoIdProp) : null;
        for (EntityCollection.Item<DraftSpi> item : entities.items()) {
            List<Object> variables = mapper.variables(item.getEntity());
            rowCounts[rowIndex++] = executor.execute(new Executor.Args<Integer>(sqlClient, this.ctx.con, sql, variables, tuple.get_3(), ExecutionPurpose.MUTATE, this.ctx.options.getExceptionTranslator(), (con, sqlText) -> {
                if (shape.getIdGetters().isEmpty()) {
                    return con.prepareStatement(sqlText, 1);
                }
                return con.prepareStatement(sqlText);
            }, (stmt, args) -> {
                int rowCount;
                try {
                    Savepoint savepoint = SavepointManager.setIfNeeded(this.ctx.con, sqlClient);
                    try {
                        rowCount = stmt.executeUpdate();
                    }
                    catch (SQLException ex) {
                        SavepointManager.rollback(stmt::getConnection, savepoint);
                        throw ex;
                    }
                    finally {
                        SavepointManager.release(stmt::getConnection, savepoint);
                    }
                }
                catch (SQLException ex) {
                    Exception translateException = this.translateException(ex, args, shape, (DraftSpi)item.getEntity(), updatable);
                    if (translateException instanceof RuntimeException) {
                        throw (RuntimeException)translateException;
                    }
                    throw new ExecutionException("Cannot execute the DML statement", translateException);
                }
                Object id = null;
                if (autoIdReader != null) {
                    try (ResultSet rs = stmt.getGeneratedKeys();){
                        if (rs.next()) {
                            id = autoIdReader.read(rs, new Reader.Context(null, sqlClient));
                        }
                    }
                }
                this.modifyEntity(id, shape, item, updatable, ignoreUpdate, rowCount);
                return rowCount;
            }));
        }
        return rowCounts;
    }

    private int[] executeAndGetRowCountsByBatch(BatchSqlBuilder builder, Shape shape, EntityCollection<DraftSpi> entities, boolean updatable, boolean ignoreUpdate) {
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        Tuple3<String, BatchSqlBuilder.VariableMapper, List<Integer>> tuple = builder.build();
        try (Executor.BatchContext batchContext = sqlClient.getExecutor().executeBatch(this.ctx.con, tuple.get_1(), shape.getIdGetters().isEmpty() ? this.ctx.path.getType().getIdProp() : null, ExecutionPurpose.command(QueryReason.NONE), sqlClient);){
            BatchSqlBuilder.VariableMapper mapper = tuple.get_2();
            for (DraftSpi draft : entities) {
                batchContext.add(mapper.variables(draft));
            }
            int[] rowCounts = batchContext.execute((ex, args) -> {
                Executor.BatchContext ctx = (Executor.BatchContext)args;
                if (ex instanceof BatchUpdateException) {
                    this.modifyEntities(ctx.generatedIds(), shape, entities, updatable, ignoreUpdate, ((BatchUpdateException)ex).getUpdateCounts());
                }
                return this.translateException((SQLException)ex, ctx, shape, (Collection<? extends DraftSpi>)entities, updatable);
            });
            if (sqlClient.getDialect().isBatchDumb()) {
                this.modifyEntities(null, shape, entities, updatable, ignoreUpdate, rowCounts);
            } else {
                this.modifyEntities(batchContext.generatedIds(), shape, entities, updatable, ignoreUpdate, rowCounts);
            }
            int[] nArray = rowCounts;
            return nArray;
        }
    }

    private void modifyEntity(Object generatedId, Shape shape, EntityCollection.Item<DraftSpi> item, boolean updatable, boolean ignoreUpdate, int rowCount) {
        block10: {
            block9: {
                if (generatedId != null) {
                    PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                    for (DraftSpi draft : item.getOriginalEntities()) {
                        draft.__set(idPropId, generatedId);
                    }
                }
                PropertyGetter versionGetter = shape.getVersionGetter();
                if (!updatable || versionGetter == null) break block9;
                PropId versionPropId = versionGetter.prop().getId();
                Integer version = (Integer)item.getEntity().__get(versionPropId);
                if (rowCount <= 0) break block10;
                for (DraftSpi draft : item.getOriginalEntities()) {
                    draft.__set(versionPropId, (Object)(version + 1));
                }
                break block10;
            }
            if (ignoreUpdate) {
                ArrayList<PropId> unloadedPropIds = new ArrayList<PropId>();
                for (ImmutableProp prop : this.ctx.path.getType().getProps().values()) {
                    if (prop.isMiddleTableDefinition() || !prop.isAssociation(TargetLevel.PERSISTENT)) continue;
                    unloadedPropIds.add(prop.getId());
                }
                if (unloadedPropIds.isEmpty()) {
                    return;
                }
                if (rowCount <= 0) {
                    for (PropId unloadedPropId : unloadedPropIds) {
                        for (DraftSpi draft : item.getOriginalEntities()) {
                            draft.__unload(unloadedPropId);
                        }
                    }
                }
            }
        }
    }

    private void modifyEntities(Object[] generatedIds, Shape shape, EntityCollection<DraftSpi> entities, boolean updatable, boolean ignoreUpdate, int[] rowCounts) {
        int generateIdIndex = 0;
        int rowIndex = 0;
        for (EntityCollection.Item<DraftSpi> item : entities.items()) {
            this.modifyEntity(generatedIds != null && generatedIds.length != 0 && rowCounts[rowIndex] > 0 ? generatedIds[generateIdIndex++] : null, shape, item, updatable, ignoreUpdate, rowIndex < rowCounts.length ? rowCounts[rowIndex] : -1);
            ++rowIndex;
        }
    }

    private int execute(BatchSqlBuilder builder, Batch<DraftSpi> batch, boolean updatable, boolean ignoreUpdate) {
        int[] rowCounts = this.executeAndGetRowCounts(builder, batch.shape(), batch.entities(), updatable, ignoreUpdate);
        return Operator.rowCount(rowCounts);
    }

    private Exception translateException(SQLException ex, Executor.Args<?> args, Shape shape, DraftSpi entity, boolean updatable) {
        String state = ex.getSQLState();
        if (state == null || !state.startsWith("23")) {
            return this.convertFinalException(ex, args);
        }
        EntityInvestigator investigator = new EntityInvestigator(SIMPLE_ILLEGAL_ROW_COUNTS, this.ctx.investigator(this.ctx.options.getSqlClient()), shape, Collections.singletonList(entity), updatable);
        Exception investigateEx = investigator.investigate();
        if (investigateEx == null) {
            investigateEx = ex;
        }
        return this.convertFinalException(investigateEx, args);
    }

    private Exception translateException(SQLException ex, @Nullable Executor.BatchContext ctx, Shape shape, Collection<? extends DraftSpi> entities, boolean updatable) {
        String state = ex.getSQLState();
        if (state == null || !state.startsWith("23") || !(ex instanceof BatchUpdateException)) {
            return this.convertFinalException(ex, ctx);
        }
        BatchUpdateException bue = (BatchUpdateException)ex;
        EntityInvestigator investigator = new EntityInvestigator(bue.getUpdateCounts(), this.ctx.investigator(ctx), shape, entities, updatable);
        Exception investigateEx = investigator.investigate();
        if (investigateEx == null) {
            investigateEx = bue;
        }
        return this.convertFinalException(investigateEx, ctx);
    }

    private Exception convertFinalException(@NotNull Exception ex, @NotNull ExceptionTranslator.Args args) {
        ExceptionTranslator<Exception> translator = this.ctx.options.getExceptionTranslator();
        if (translator == null) {
            return ex;
        }
        return translator.translate(ex, args);
    }

    private class UpdateContextImpl
    implements Dialect.UpdateContext {
        private final BatchSqlBuilder builder;
        private final Shape shape;
        private final PropertyGetter idGetter;
        private final Set<ImmutableProp> keyProps;
        private final List<PropertyGetter> updatedGetters;
        private final Predicate userOptimisticLockPredicate;
        private final PropertyGetter versionGetter;

        UpdateContextImpl(BatchSqlBuilder builder, Shape shape, PropertyGetter idGetter, Set<ImmutableProp> keyProps, List<PropertyGetter> updatedGetters, Predicate userOptimisticLockPredicate, PropertyGetter versionGetter) {
            this.builder = builder;
            this.shape = shape;
            this.idGetter = idGetter;
            this.keyProps = keyProps;
            this.updatedGetters = updatedGetters;
            this.userOptimisticLockPredicate = userOptimisticLockPredicate;
            this.versionGetter = versionGetter;
        }

        @Override
        public boolean isUpdatedByKey() {
            return this.shape.getIdGetters().isEmpty();
        }

        @Override
        public Dialect.UpdateContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpdateContext sql(ValueGetter getter) {
            this.builder.sql(getter);
            return this;
        }

        @Override
        public Dialect.UpdateContext enter(AbstractSqlBuilder.ScopeType type) {
            this.builder.enter(type);
            return this;
        }

        @Override
        public Dialect.UpdateContext separator() {
            this.builder.separator();
            return this;
        }

        @Override
        public Dialect.UpdateContext leave() {
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpdateContext appendTableName() {
            MetadataStrategy strategy = Operator.this.ctx.options.getSqlClient().getMetadataStrategy();
            this.builder.sql(Operator.this.ctx.path.getType().getTableName(strategy));
            return this;
        }

        @Override
        public Dialect.UpdateContext appendAssignments() {
            ImmutableProp versionProp;
            for (PropertyGetter getter : this.updatedGetters) {
                if (getter == this.versionGetter) continue;
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ")).variable(getter);
            }
            PropertyGetter actualVersionGetter = this.versionGetter;
            if (actualVersionGetter == null && (versionProp = Operator.this.ctx.path.getType().getVersionProp()) != null && Operator.this.ctx.options.getUnloadedVersionBehavior(Operator.this.ctx.path.getType()) == UnloadedVersionBehavior.INCREASE) {
                actualVersionGetter = PropertyGetter.propertyGetters(Operator.this.ctx.options.getSqlClient(), versionProp).get(0);
            }
            if (actualVersionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(actualVersionGetter)).sql(" = ")).sql(actualVersionGetter)).sql(" + 1");
            }
            return this;
        }

        @Override
        public Dialect.UpdateContext appendPredicates() {
            if (this.keyProps != null) {
                Map<ImmutableProp, List<PropertyGetter>> getterMap = this.shape.getGetterMap();
                for (ImmutableProp keyProp : this.keyProps) {
                    List<PropertyGetter> getters = getterMap.get(keyProp);
                    for (PropertyGetter getter : getters) {
                        ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ")).variable(getter);
                    }
                }
            } else {
                for (PropertyGetter getter : this.shape.getIdGetters()) {
                    ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ")).variable(getter);
                }
            }
            if (this.versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(this.versionGetter)).sql(" = ")).variable(this.versionGetter);
            }
            if (this.userOptimisticLockPredicate != null) {
                this.builder.separator();
                AbstractExpression.renderChild((Ast)((Object)this.userOptimisticLockPredicate), 6, this.builder);
            }
            return this;
        }

        @Override
        public Dialect.UpdateContext appendId() {
            this.builder.sql(this.idGetter);
            return this;
        }
    }

    private class UpsertContextImpl
    implements Dialect.UpsertContext {
        private final BatchSqlBuilder builder;
        private final SequenceIdGenerator sequenceIdGenerator;
        private final PropertyGetter generatedIdGetter;
        private final List<PropertyGetter> insertedGetters;
        private final List<PropertyGetter> conflictGetters;
        private final List<PropertyGetter> updatedGetters;
        private final boolean updateIgnored;
        private final Predicate userOptimisticLockPredicate;
        private final PropertyGetter versionGetter;
        private Boolean complete;

        UpsertContextImpl(BatchSqlBuilder builder, ImmutableProp generatedIdProp, SequenceIdGenerator sequenceIdGenerator, List<PropertyGetter> insertedGetters, List<PropertyGetter> conflictGetters, List<PropertyGetter> updatedGetters, boolean updateIgnored, Predicate userOptimisticLockPredicate, PropertyGetter versionGetter) {
            if (generatedIdProp != null && generatedIdProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                throw new IllegalArgumentException("Generated id prop cannot be embeddable");
            }
            if (generatedIdProp != null && (userOptimisticLockPredicate != null || versionGetter != null)) {
                throw new IllegalArgumentException("Optimistic lock is not support by upsert statement which can generate id");
            }
            this.builder = builder;
            this.sequenceIdGenerator = sequenceIdGenerator;
            this.generatedIdGetter = generatedIdProp != null ? Shape.fullOf(builder.sqlClient(), generatedIdProp.getDeclaringType().getJavaClass()).getIdGetters().get(0) : null;
            this.insertedGetters = insertedGetters;
            this.conflictGetters = conflictGetters;
            this.updatedGetters = updatedGetters;
            this.updateIgnored = updateIgnored;
            this.userOptimisticLockPredicate = userOptimisticLockPredicate;
            this.versionGetter = versionGetter;
        }

        @Override
        public boolean hasUpdatedColumns() {
            return !this.updatedGetters.isEmpty();
        }

        @Override
        public boolean hasOptimisticLock() {
            return this.userOptimisticLockPredicate != null || this.versionGetter != null;
        }

        @Override
        public boolean hasGeneratedId() {
            return this.generatedIdGetter != null;
        }

        @Override
        public boolean isUpdateIgnored() {
            return this.updateIgnored;
        }

        @Override
        public boolean isComplete() {
            Boolean complete = this.complete;
            if (complete == null) {
                this.complete = complete = Boolean.valueOf(this.isComplete0());
            }
            return complete;
        }

        private boolean isComplete0() {
            for (PropertyGetter getter : this.insertedGetters) {
                if (this.conflictGetters.contains(getter) || this.updatedGetters.contains(getter)) continue;
                return false;
            }
            if (this.updatedGetters.isEmpty()) {
                return false;
            }
            for (PropertyGetter getter : this.updatedGetters) {
                if (this.insertedGetters.contains(getter)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<ValueGetter> getConflictGetters() {
            return Collections.unmodifiableList(this.conflictGetters);
        }

        @Override
        public Dialect.UpsertContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpsertContext sql(ValueGetter getter) {
            this.builder.sql(getter);
            return this;
        }

        @Override
        public Dialect.UpsertContext enter(AbstractSqlBuilder.ScopeType type) {
            this.builder.enter(type);
            return this;
        }

        @Override
        public Dialect.UpsertContext separator() {
            this.builder.separator();
            return this;
        }

        @Override
        public Dialect.UpsertContext leave() {
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendTableName() {
            this.builder.sql(Operator.this.ctx.path.getType().getTableName(Operator.this.ctx.options.getSqlClient().getMetadataStrategy()));
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertedColumns(String prefix) {
            if (this.sequenceIdGenerator != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql("(")).sql(this.builder.sqlClient().getDialect().getSelectIdFromSequenceSql(this.sequenceIdGenerator.getSequenceName()))).sql(")");
            }
            for (PropertyGetter getter : this.insertedGetters) {
                if (getter.prop().isId() && this.sequenceIdGenerator != null) continue;
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(prefix)).sql(getter);
            }
            return this;
        }

        @Override
        public Dialect.UpsertContext appendConflictColumns() {
            for (PropertyGetter getter : this.conflictGetters) {
                ((BatchSqlBuilder)this.builder.separator()).sql(getter);
            }
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertingValues() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.insertedGetters) {
                ((BatchSqlBuilder)this.builder.separator()).variable(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendUpdatingAssignments(String prefix, String suffix) {
            for (PropertyGetter getter : this.updatedGetters) {
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ");
                if (getter.metadata().getValueProp().isVersion() && Operator.this.ctx.options.getUserOptimisticLock(Operator.this.ctx.path.getType()) == null) {
                    ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(prefix)).sql(getter)).sql(" + 1");
                    continue;
                }
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(prefix)).sql(getter)).sql(suffix);
            }
            return this;
        }

        @Override
        public Dialect.UpsertContext appendOptimisticLockCondition(String sourceTablePrefix) {
            if (this.userOptimisticLockPredicate != null) {
                ((Ast)((Object)this.userOptimisticLockPredicate)).renderTo(this.builder);
            }
            if (this.versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(Operator.this.ctx.path.getType().getTableName(Operator.this.ctx.options.getSqlClient().getMetadataStrategy()))).sql(".")).sql(this.versionGetter)).sql(" = ")).sql(sourceTablePrefix)).sql(this.versionGetter);
            }
            return this;
        }

        @Override
        public Dialect.UpsertContext appendGeneratedId() {
            if (this.generatedIdGetter != null) {
                this.builder.sql(this.generatedIdGetter);
            }
            return this;
        }
    }
}

