/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.event.Triggers;

public class MutationTrigger {
    private final List<ChangedData> changedList = new ArrayList<ChangedData>();

    public void modifyEntityTable(Object oldEntity, Object newEntity) {
        this.changedList.add(new EntityChangedData(oldEntity, newEntity));
    }

    public void insertMiddleTable(ImmutableProp prop, Object sourceId, Object targetId) {
        this.changedList.add(new AssociationChangedData(prop, sourceId, null, targetId));
    }

    public void deleteMiddleTable(ImmutableProp prop, Object sourceId, Object targetId) {
        this.changedList.add(new AssociationChangedData(prop, sourceId, targetId, null));
    }

    public void prepareSubmit(DraftContext ctx) {
        if (!this.changedList.isEmpty()) {
            for (ChangedData changedData : this.changedList) {
                ChangedData data;
                if (changedData instanceof EntityChangedData) {
                    data = (EntityChangedData)changedData;
                    data.oldEntity = ctx.resolveObject(data.oldEntity);
                    data.newEntity = ctx.resolveObject(data.newEntity);
                }
                if (!(changedData instanceof AssociationChangedData)) continue;
                data = (AssociationChangedData)changedData;
                ((AssociationChangedData)data).sourceId = ctx.resolveObject(((AssociationChangedData)data).sourceId);
                ((AssociationChangedData)data).detachedTargetId = ctx.resolveObject(((AssociationChangedData)data).detachedTargetId);
                ((AssociationChangedData)data).attachedTargetId = ctx.resolveObject(((AssociationChangedData)data).attachedTargetId);
            }
        }
    }

    public void submit(JSqlClient sqlClient, Connection con) {
        if (!this.changedList.isEmpty()) {
            Triggers triggers = sqlClient.getTriggers(true);
            for (ChangedData changedData : this.changedList) {
                ChangedData data;
                if (changedData instanceof EntityChangedData) {
                    data = (EntityChangedData)changedData;
                    Internal.requiresNewDraftContext(arg_0 -> MutationTrigger.lambda$submit$0(triggers, (EntityChangedData)data, con, arg_0));
                    continue;
                }
                data = (AssociationChangedData)changedData;
                if (((AssociationChangedData)data).detachedTargetId == null) {
                    triggers.fireMiddleTableInsert(((AssociationChangedData)data).prop, ((AssociationChangedData)data).sourceId, ((AssociationChangedData)data).attachedTargetId, con);
                    continue;
                }
                triggers.fireMiddleTableDelete(((AssociationChangedData)data).prop, ((AssociationChangedData)data).sourceId, ((AssociationChangedData)data).detachedTargetId, con);
            }
        }
    }

    private static ImmutableSpi toLonely(ImmutableSpi spi) {
        if (spi == null) {
            return null;
        }
        ImmutableType type = spi.__type();
        return (ImmutableSpi)Internal.requiresNewDraftContext(ctx -> {
            DraftSpi draft = (DraftSpi)type.getDraftFactory().apply(ctx, null);
            for (ImmutableProp prop : type.getProps().values()) {
                PropId propId;
                if (!prop.isColumnDefinition() || !spi.__isLoaded(propId = prop.getId())) continue;
                if (prop.isReference(TargetLevel.ENTITY)) {
                    draft.__set(propId, (Object)MutationTrigger.toIdOnly((ImmutableSpi)spi.__get(propId)));
                    continue;
                }
                if (prop.isReference(TargetLevel.OBJECT)) {
                    draft.__set(propId, (Object)MutationTrigger.toLonely((ImmutableSpi)spi.__get(propId)));
                    continue;
                }
                draft.__set(propId, spi.__get(propId));
            }
            return (ImmutableSpi)ctx.resolveObject((Object)draft);
        });
    }

    private static ImmutableSpi toIdOnly(ImmutableSpi spi) {
        if (spi == null) {
            return null;
        }
        PropId idPropId = spi.__type().getIdProp().getId();
        return (ImmutableSpi)ImmutableObjects.makeIdOnly((ImmutableType)spi.__type(), (Object)spi.__get(idPropId));
    }

    private static /* synthetic */ Object lambda$submit$0(Triggers triggers, EntityChangedData data, Connection con, DraftContext ctx) {
        triggers.fireEntityTableChange(MutationTrigger.toLonely((ImmutableSpi)data.oldEntity), MutationTrigger.toLonely((ImmutableSpi)data.newEntity), con);
        return null;
    }

    private static class EntityChangedData
    implements ChangedData {
        Object oldEntity;
        Object newEntity;

        private EntityChangedData(Object oldEntity, Object newEntity) {
            this.oldEntity = oldEntity;
            this.newEntity = newEntity;
        }

        public String toString() {
            return "ChangedEntity{oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + '}';
        }
    }

    private static class AssociationChangedData
    implements ChangedData {
        final ImmutableProp prop;
        Object sourceId;
        Object detachedTargetId;
        Object attachedTargetId;

        private AssociationChangedData(ImmutableProp prop, Object sourceId, Object detachedTargetId, Object attachedTargetId) {
            this.prop = prop;
            this.sourceId = sourceId;
            this.detachedTargetId = detachedTargetId;
            this.attachedTargetId = attachedTargetId;
        }

        public String toString() {
            return "ChangedAssociation{prop=" + this.prop + ", sourceId=" + this.sourceId + ", detachedTargetId=" + this.detachedTargetId + ", attachedTargetId=" + this.attachedTargetId + '}';
        }
    }

    private static interface ChangedData {
    }
}

