/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.lang.Lazy;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.LiteralExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.Variables;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NativePredicates;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableUpdateImpl
extends AbstractMutableStatementImpl
implements MutableUpdate {
    private final StatementContext ctx;
    private final boolean triggerIgnored;
    private final Map<Target, Expression<?>> assignmentMap = new LinkedHashMap();

    public MutableUpdateImpl(JSqlClientImplementor sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE);
        this.triggerIgnored = false;
    }

    public MutableUpdateImpl(JSqlClientImplementor sqlClient, ImmutableType immutableType, boolean triggerIgnored) {
        super(sqlClient, immutableType);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE);
        this.triggerIgnored = triggerIgnored;
    }

    public MutableUpdateImpl(JSqlClientImplementor sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE);
        this.triggerIgnored = false;
    }

    private static boolean hasUsedChild(TableImplementor<?> tableImplementor, AstContext astContext) {
        for (RealTable childTable : tableImplementor.realTable(astContext)) {
            if (astContext.getTableUsedState(childTable) != TableUsedState.USED) continue;
            return true;
        }
        return false;
    }

    @Override
    public StatementContext getContext() {
        return this.ctx;
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return null;
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, X value) {
        if (value != null) {
            return this.set(path, Expression.any().value(value));
        }
        return this.set(path, Expression.nullValue(((ExpressionImplementor)((Object)path)).getType()));
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, Expression<X> value) {
        boolean joinedTableUpdatable;
        this.validateMutable();
        Target target = Target.of(path, this.getSqlClient().getMetadataStrategy());
        if (target.table != this.getTable() && target.table != this.getTableLikeImplementor() && this.getSqlClient().getTriggerType() != TriggerType.BINLOG_ONLY) {
            throw new IllegalArgumentException("Only the primary table can be deleted when transaction trigger is supported");
        }
        if (!target.prop.isColumnDefinition()) {
            throw new IllegalArgumentException("The assigned prop expression must be mapped by database columns");
        }
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean bl = joinedTableUpdatable = updateJoin != null && updateJoin.isJoinedTableUpdatable();
        if (!joinedTableUpdatable && target.table != this.getTable() && target.table != this.getTableLikeImplementor()) {
            throw new IllegalArgumentException("The current dialect '" + this.getSqlClient().getDialect().getClass().getName() + "' indicates that only the columns of current table can be updated");
        }
        if (this.assignmentMap.put(target, value) != null) {
            throw new IllegalStateException("Cannot update same column twice");
        }
        Literals.bind(value, path);
        return this;
    }

    @Override
    public MutableUpdate where(Predicate ... predicates) {
        return (MutableUpdate)super.where(predicates);
    }

    @Override
    public Integer execute(Connection con) {
        return this.getSqlClient().getConnectionManager().execute(con, this::executeImpl);
    }

    private int executeImpl(Connection con) {
        if (this.assignmentMap.isEmpty()) {
            return 0;
        }
        if (this.getSqlClient().isTargetTransferable()) {
            Executor.validateMutationConnection(con);
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.applyVirtualPredicates(builder.getAstContext());
        this.applyGlobalFilters(builder.getAstContext(), FilterLevel.DEFAULT, null);
        if (!this.triggerIgnored && this.getSqlClient().getTriggerType() != TriggerType.BINLOG_ONLY) {
            return this.executeWithTrigger(builder, con);
        }
        this.renderTo(builder);
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.getSqlClient().getExecutor().execute(new Executor.Args<Integer>(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.getPurpose(), null, null, (stmt, args) -> stmt.executeUpdate()));
    }

    private int executeWithTrigger(SqlBuilder builder, Connection con) {
        this.renderAsSelect(builder, null);
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        List<ImmutableSpi> rows = Selectors.select(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Collections.singletonList((Selection)this.getTable()), null, ExecutionPurpose.UPDATE);
        if (rows.isEmpty()) {
            return 0;
        }
        PropId idPropId = ((Table)this.getTable()).getImmutableType().getIdProp().getId();
        HashMap<Object, ImmutableSpi> rowMap = new HashMap<Object, ImmutableSpi>((rows.size() * 4 + 2) / 3);
        for (ImmutableSpi row : rows) {
            rowMap.put(row.__get(idPropId), row);
        }
        builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderTo(builder, rowMap.keySet());
        sqlResult = builder.build();
        int affectRowCount = this.getSqlClient().getExecutor().execute(new Executor.Args<Integer>(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.getPurpose(), null, null, (stmt, args) -> stmt.executeUpdate()));
        if (affectRowCount == 0) {
            return 0;
        }
        builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderAsSelect(builder, rowMap.keySet());
        sqlResult = builder.build();
        List<ImmutableSpi> changedRows = Selectors.select(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Collections.singletonList((Selection)this.getTable()), null, ExecutionPurpose.UPDATE);
        MutationTrigger trigger = new MutationTrigger();
        for (ImmutableSpi changedRow : changedRows) {
            ImmutableSpi row = (ImmutableSpi)rowMap.get(changedRow.__get(idPropId));
            if (row.__equals((Object)changedRow, true)) continue;
            trigger.modifyEntityTable(row, changedRow);
        }
        trigger.submit(this.getSqlClient(), con);
        return affectRowCount;
    }

    public void accept(@NotNull AstVisitor visitor) {
        this.accept(visitor, true);
    }

    public void renderTo(@NotNull SqlBuilder builder) {
        this.renderTo(builder, null);
    }

    public TableImplementor<?> getTableLikeImplementor() {
        return (TableImplementor)super.getTableLikeImplementor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept(@NotNull AstVisitor visitor, boolean visitAssignments) {
        AstContext astContext = visitor.getAstContext();
        this.freeze(astContext);
        astContext.pushStatement(this);
        visitor.visitStatement(this);
        try {
            if (visitAssignments) {
                for (Map.Entry entry : this.assignmentMap.entrySet()) {
                    ((Ast)((Object)((Target)entry.getKey()).expr)).accept(visitor);
                    ((Ast)entry.getValue()).accept(visitor);
                }
            }
            for (Predicate predicate : this.unfrozenPredicates()) {
                ((Ast)((Object)predicate)).accept(visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTo(@NotNull SqlBuilder builder, Collection<Object> ids) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this);
        try {
            UpdateJoin updateJoin;
            TableLikeImplementor table = this.getTableLikeImplementor();
            Dialect dialect = this.getSqlClient().getDialect();
            VisitorImpl visitor = new VisitorImpl(builder.getAstContext(), dialect);
            this.accept(visitor);
            visitor.allocateAliases();
            ((SqlBuilder)builder.sql("update ")).sql(table.getImmutableType().getTableName(this.getSqlClient().getMetadataStrategy()));
            if (this.getSqlClient().getDialect().isUpdateAliasSupported()) {
                ((SqlBuilder)builder.sql(" ")).sql(table.realTable(builder.getAstContext()).getAlias());
            }
            if ((updateJoin = dialect.getUpdateJoin()) != null && updateJoin.getFrom() == UpdateJoin.From.UNNECESSARY) {
                for (RealTable child : table.realTable(astContext)) {
                    child.renderTo(builder, false);
                }
            }
            builder.enter(AbstractSqlBuilder.ScopeType.SET);
            this.renderAssignments(builder);
            builder.leave();
            this.renderTables(builder);
            this.renderDeeperJoins(builder);
            this.renderWhereClause(builder, true, ids);
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAsSelect(SqlBuilder builder, Collection<Object> ids) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this);
        try {
            VisitorImpl visitor = new VisitorImpl(builder.getAstContext(), null);
            this.accept(visitor, false);
            visitor.allocateAliases();
            TableLikeImplementor table = this.getTableLikeImplementor();
            MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
            builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
            for (ImmutableProp prop : table.getImmutableType().getSelectableProps().values()) {
                ((SqlBuilder)builder.separator()).definition(table.realTable(astContext).getAlias(), (ColumnDefinition)prop.getStorage(strategy), null);
            }
            builder.leave();
            if (ids != null) {
                ((SqlBuilder)builder.from().sql(table.getImmutableType().getTableName(strategy))).sql(" ");
                if (this.getSqlClient().getDialect().isUpdateAliasSupported()) {
                    builder.sql(table.realTable(astContext).getAlias());
                }
                builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
                NativePredicates.renderPredicates(false, table.realTable(astContext).getAlias(), (ColumnDefinition)table.getImmutableType().getIdProp().getStorage(strategy), ids, builder);
                builder.leave();
            } else {
                table.renderTo(builder);
                this.renderWhereClause(builder, false, null);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void renderAssignments(SqlBuilder builder) {
        TableLikeImplementor table = this.getTableLikeImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean withTargetPrefix = updateJoin != null && updateJoin.isJoinedTableUpdatable() && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext());
        for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
            builder.separator();
            this.renderTarget(builder, e.getKey(), withTargetPrefix);
            builder.sql(" = ");
            this.renderAssignmentSource(e.getValue(), e.getKey().expr.getDeepestProp(), builder);
        }
    }

    private void renderAssignmentSource(Expression<?> source, ImmutableProp prop, SqlBuilder builder) {
        if (source instanceof LiteralExpressionImplementor) {
            Object value = ((LiteralExpressionImplementor)((Object)source)).getValue();
            builder.variable(Variables.process(value, prop, builder.getAstContext().getSqlClient()));
        } else {
            ((Ast)((Object)source)).renderTo(builder);
        }
    }

    private void renderTarget(SqlBuilder builder, Target target, boolean withPrefix) {
        Object definition;
        TableImplementor<?> impl = TableProxies.resolve(target.table, builder.getAstContext());
        MetadataStrategy strategy = this.getSqlClient().getMetadataStrategy();
        if (target.prop.isEmbedded(EmbeddedLevel.REFERENCE)) {
            String name = target.expr.getPartial(strategy).name(0);
            MultipleJoinColumns joinColumns = (MultipleJoinColumns)target.prop.getStorage(strategy);
            definition = new SingleColumn(joinColumns.name(joinColumns.referencedIndex(name)), joinColumns.isForeignKey(), null, null);
        } else {
            definition = target.prop.isReference(TargetLevel.ENTITY) ? (ColumnDefinition)target.prop.getStorage(strategy) : target.expr.getPartial(builder.getAstContext().getSqlClient().getMetadataStrategy());
        }
        impl.renderSelection(target.expr.getDeepestProp(), true, builder, (ColumnDefinition)definition, withPrefix);
    }

    private void renderTables(SqlBuilder builder) {
        TableLikeImplementor table = this.getTableLikeImplementor();
        if (MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            switch (this.getSqlClient().getDialect().getUpdateJoin().getFrom()) {
                case AS_ROOT: {
                    table.renderTo(builder);
                    break;
                }
                case AS_JOIN: {
                    builder.from().enter(",");
                    for (RealTable child : table.realTable(builder.getAstContext())) {
                        child.renderJoinAsFrom(builder, TableImplementor.RenderMode.FROM_ONLY);
                    }
                    builder.leave();
                }
            }
        }
    }

    private void renderDeeperJoins(SqlBuilder builder) {
        TableLikeImplementor table = this.getTableLikeImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            for (RealTable child : table.realTable(builder.getAstContext())) {
                child.renderJoinAsFrom(builder, TableImplementor.RenderMode.DEEPER_JOIN_ONLY);
            }
        }
    }

    private void renderWhereClause(SqlBuilder builder, boolean forUpdate, Collection<Object> ids) {
        Predicate predicate;
        boolean hasTableCondition;
        TableLikeImplementor table = this.getTableLikeImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean bl = hasTableCondition = forUpdate && updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext());
        if (!hasTableCondition && ids == null && !this.unfrozenPredicates().iterator().hasNext()) {
            return;
        }
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        if (ids != null) {
            NativePredicates.renderPredicates(false, table.realTable(builder.getAstContext()).getAlias(), (ColumnDefinition)table.getImmutableType().getIdProp().getStorage(this.getSqlClient().getMetadataStrategy()), ids, builder);
        }
        if (hasTableCondition) {
            for (RealTable child : table.realTable(builder.getAstContext())) {
                child.renderJoinAsFrom(builder, TableImplementor.RenderMode.WHERE_ONLY);
            }
        }
        if (ids == null && (predicate = this.getPredicate(builder.getAstContext())) != null) {
            builder.separator();
            ((Ast)((Object)predicate)).renderTo(builder);
        }
        builder.leave();
    }

    private static class Target {
        final Table<?> table;
        final ImmutableProp prop;
        final PropExpressionImplementor<?> expr;

        private Target(Table<?> table, ImmutableProp prop, PropExpression<?> expr) {
            this.table = table;
            this.prop = prop;
            this.expr = (PropExpressionImplementor)expr;
        }

        static Target of(PropExpression<?> expr, MetadataStrategy strategy) {
            ImmutableProp prop;
            TableLike<Object> parent;
            PropExpressionImplementor implementor = (PropExpressionImplementor)expr;
            EmbeddedColumns.Partial partial = implementor.getPartial(strategy);
            if (partial != null && partial.isEmbedded()) {
                throw new IllegalArgumentException("The property \"" + implementor + "\" is embedded, it cannot be used as the assignment target of update statement");
            }
            Table<?> targetTable = implementor.getTable();
            if (targetTable instanceof TableImplementor) {
                parent = ((TableImplementor)targetTable).getParent();
                prop = ((TableImplementor)targetTable).getJoinProp();
            } else {
                parent = ((TableProxy)targetTable).__parent();
                prop = ((TableProxy)targetTable).__prop();
            }
            if (parent != null && prop != null && implementor.getProp().isId()) {
                return new Target((Table<?>)parent, prop, expr);
            }
            return new Target(targetTable, implementor.getProp(), expr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return this.expr.equals(target.expr);
        }

        public int hashCode() {
            return this.expr.hashCode();
        }
    }

    private static class VisitorImpl
    extends UseTableVisitor {
        private final Dialect dialect;

        public VisitorImpl(AstContext astContext, Dialect dialect) {
            super(astContext);
            this.dialect = dialect;
        }

        @Override
        public void visitTableReference(RealTable table, @Nullable ImmutableProp prop, boolean rawId) {
            super.visitTableReference(table, prop, rawId);
            if (this.dialect != null) {
                this.validateTable(table);
            }
        }

        private void validateTable(RealTable table) {
            if (this.getAstContext().getTableUsedState(table) == TableUsedState.USED) {
                if (table.getParent() != null && this.dialect.getUpdateJoin() == null) {
                    throw new ExecutionException("Table joins for update statement is forbidden by the current dialect, but there is a join '" + table.getTableLikeImplementor() + "'.");
                }
                if (table.getParent() != null && table.getParent().getParent() == null && this.dialect.getUpdateJoin() != null && this.dialect.getUpdateJoin().getFrom() == UpdateJoin.From.AS_JOIN) {
                    Lazy reason = new Lazy(() -> "because current dialect '" + this.dialect.getClass().getName() + "' indicates that the first level table joins in update statement must be rendered as 'from' clause, but there is a first level table join whose join type is outer: '" + table.getTableLikeImplementor() + "'.");
                    TableLikeImplementor<?> implementor = table.getTableLikeImplementor();
                    if (implementor instanceof TableImplementor) {
                        TableImplementor tableImplementor = (TableImplementor)implementor;
                        if (tableImplementor.getJoinType() != JoinType.INNER) {
                            throw new ExecutionException("The first level table joins cannot be outer join " + (String)reason.get());
                        }
                        if (tableImplementor.getWeakJoinHandle() != null) {
                            throw new ExecutionException("The first level table joins cannot be weak join " + (String)reason.get());
                        }
                    }
                }
            }
            if (table.getParent() != null) {
                this.validateTable(table.getParent());
            }
        }
    }
}

