/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractPreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;

class InsertPreHandler
extends AbstractPreHandler {
    private ShapedEntityMap<DraftSpi> insertedMap;

    InsertPreHandler(SaveContext ctx) {
        super(ctx);
    }

    @Override
    public ShapedEntityMap<DraftSpi> insertedMap() {
        this.resolve();
        return this.insertedMap;
    }

    @Override
    void onResolve() {
        IdGenerator idGenerator;
        if (!this.draftsWithKey.isEmpty() && (idGenerator = this.ctx.options.getSqlClient().getIdGenerator(this.ctx.path.getType().getJavaClass())) instanceof UserIdGenerator) {
            PropId idPropId = this.ctx.path.getType().getIdProp().getId();
            for (DraftSpi draft : this.draftsWithKey) {
                Object id = this.ctx.allocateId();
                if (id == null) continue;
                draft.__set(idPropId, id);
            }
        }
        ArrayList<DraftInterceptor.Item<Object, DraftSpi>> items = new ArrayList<DraftInterceptor.Item<Object, DraftSpi>>(this.draftsWithNothing.size() + this.draftsWithId.size() + this.draftsWithKey.size());
        for (DraftSpi draft : this.draftsWithNothing) {
            items.add(this.newItem(draft, null));
        }
        for (DraftSpi draft : this.draftsWithId) {
            items.add(this.newItem(draft, null));
        }
        for (DraftSpi draft : this.draftsWithKey) {
            items.add(this.newItem(draft, null));
        }
        this.callInterceptor(items);
        this.insertedMap = this.createEntityMap(this.draftsWithNothing, this.draftsWithId, this.draftsWithKey, SaveMode.INSERT_ONLY, null);
    }

    @Override
    boolean isWildObjectAcceptable() {
        return true;
    }

    @Override
    void assignDefaultValues(DraftSpi draft) {
        for (ImmutableProp prop : draft.__type().getProps().values()) {
            Ref ref;
            PropId propId = prop.getId();
            if (draft.__isLoaded(propId) || (ref = prop.getDefaultValueRef()) == null) continue;
            Object v = ref.getValue();
            Object evaluatedValue = v instanceof Supplier ? ((Supplier)v).get() : v;
            draft.__set(propId, evaluatedValue);
        }
    }
}

