/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntityCollection;
import org.babyfish.jimmer.sql.ast.impl.mutation.EsNode;
import org.jetbrains.annotations.NotNull;

class EntitySet<E>
extends EsNode<E>
implements EntityCollection<E> {
    private static final int INIT_CAPACITY = 8;
    private final PropId[] propIds;
    private EsNode<E>[] tab;
    private int size;
    private int modCount;

    EntitySet(PropId[] propIds) {
        super(0, null, null, null, null);
        this.propIds = propIds;
        this.before = this;
        this.after = this;
    }

    @Override
    public boolean isEmpty() {
        return this.after == this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        EsNode<E> startNode;
        if (this.tab == null) {
            return false;
        }
        int h = this.h((ImmutableSpi)o);
        h ^= h >>> 16;
        int index = this.tab.length - 1 & h;
        EsNode<E> node = startNode = this.tab[index];
        while (node != null) {
            if (node.hash == h && this.eq((ImmutableSpi)node.data, (ImmutableSpi)o)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E data) {
        EsNode<E> startNode;
        if (this.tab == null) {
            this.tab = new EsNode[8];
        }
        int h = this.h((ImmutableSpi)data);
        h ^= h >>> 16;
        int index = this.tab.length - 1 & h;
        EsNode<E> node = startNode = this.tab[index];
        while (node != null) {
            if (node.hash == h && this.eq((ImmutableSpi)node.data, (ImmutableSpi)data)) {
                node.merge(data);
                ++this.modCount;
                this.grow();
                return false;
            }
            node = node.next;
        }
        EsNode last = this.before;
        EsNode<E> node2 = new EsNode<E>(h, data, startNode, last, this);
        last.after = node2;
        this.before = node2;
        this.tab[index] = node2;
        ++this.modCount;
        ++this.size;
        this.grow();
        return true;
    }

    private void grow() {
        int tabLen = this.tab.length;
        if (this.size <= tabLen) {
            return;
        }
        int newTabLen = tabLen > 4096 ? tabLen << 1 : tabLen << 3;
        EsNode[] newTab = new EsNode[newTabLen];
        EsNode node = this.after;
        while (node != this) {
            int index = newTabLen - 1 & node.hash;
            node.next = newTab[index];
            newTab[index] = node;
            node = node.after;
        }
        this.tab = newTab;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            modified |= this.add(e);
        }
        return modified;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        if (this.after == this) {
            return Collections.emptyIterator();
        }
        return new EntityItr(this);
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        Object[] arr = new Object[this.size];
        int index = 0;
        for (E e : this) {
            arr[index++] = e;
        }
        return arr;
    }

    @Override
    public <T> T @NotNull [] toArray(@NotNull T[] a) {
        T[] arr = a.length < this.size ? (Object[])Array.newInstance(a.getClass().getComponentType(), this.size) : a;
        int index = 0;
        for (E e : this) {
            arr[index++] = e;
        }
        return arr;
    }

    public E first() {
        EsNode after = this.after;
        if (after == this) {
            throw new NoSuchElementException();
        }
        return after.data;
    }

    @Override
    public Iterable<EntityCollection.Item<E>> items() {
        return new Items();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean addComma = false;
        for (E e : this) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }

    private int h(ImmutableSpi spi) {
        int hash = 1;
        for (int i = this.propIds.length - 1; i >= 0; --i) {
            Object v = spi.__get(this.propIds[i]);
            hash = hash * 31 + (v != null ? v.hashCode() : 0);
        }
        return hash;
    }

    private boolean eq(ImmutableSpi a, ImmutableSpi b) {
        for (int i = this.propIds.length - 1; i >= 0; --i) {
            Object v2;
            Object v1 = a.__get(this.propIds[i]);
            if (Objects.equals(v1, v2 = b.__get(this.propIds[i]))) continue;
            return false;
        }
        return true;
    }

    private static class EntityItr<E>
    extends AbstractItr<E>
    implements Iterator<E> {
        public EntityItr(EntitySet<E> owner) {
            super(owner);
        }

        @Override
        public E next() {
            return this.nextItem().getEntity();
        }
    }

    private class Items
    implements Iterable<EntityCollection.Item<E>> {
        private Items() {
        }

        @Override
        @NotNull
        public Iterator<EntityCollection.Item<E>> iterator() {
            return new ItemItr(EntitySet.this);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            boolean addComma = false;
            for (EntityCollection.Item item : EntitySet.this.items()) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(item);
            }
            builder.append(']');
            return builder.toString();
        }
    }

    private static class ItemItr<E>
    extends AbstractItr<E>
    implements Iterator<EntityCollection.Item<E>> {
        public ItemItr(EntitySet<E> owner) {
            super(owner);
        }

        @Override
        public EntityCollection.Item<E> next() {
            return this.nextItem();
        }
    }

    private static abstract class AbstractItr<E> {
        private final EntitySet<E> owner;
        private int modCount;
        private EsNode<E> current;
        private EsNode<E> ret;

        public AbstractItr(EntitySet<E> owner) {
            this.owner = owner;
            this.modCount = ((EntitySet)owner).modCount;
            this.current = owner.after;
        }

        public final boolean hasNext() {
            if (((EntitySet)this.owner).modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != this.owner;
        }

        protected final EntityCollection.Item<E> nextItem() {
            if (((EntitySet)this.owner).modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current == this.owner) {
                throw new NoSuchElementException();
            }
            EsNode<E> item = this.current;
            this.ret = this.current;
            this.current = this.current.after;
            return item;
        }

        public final void remove() {
            if (((EntitySet)this.owner).modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ret == null) {
                throw new IllegalStateException();
            }
            int index = ((EntitySet)this.owner).tab.length - 1 & this.ret.hash;
            EsNode prev = null;
            EsNode n = ((EntitySet)this.owner).tab[index];
            while (n != null) {
                if (n == this.ret) {
                    if (prev != null) {
                        prev.next = n.next;
                        break;
                    }
                    ((EntitySet)this.owner).tab[index] = n.next;
                    break;
                }
                prev = n;
                n = n.next;
            }
            this.ret.before.after = this.ret.after;
            this.ret.after.before = this.ret.before;
            ((EntitySet)this.owner).size--;
            this.modCount = ++((EntitySet)this.owner).modCount;
        }
    }
}

