/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntityCollection;
import org.jetbrains.annotations.NotNull;

class EntityList<E>
implements EntityCollection<E> {
    private final List<E> entities;

    public EntityList() {
        this.entities = new ArrayList();
    }

    public EntityList(int size) {
        this.entities = new ArrayList(size);
    }

    @Override
    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.entities.contains(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.entities.contains(c);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.entities.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.entities.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.entities.add(e);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        return this.entities.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<EntityCollection.Item<E>> items() {
        return new Iterable<EntityCollection.Item<E>>(){

            @Override
            @NotNull
            public Iterator<EntityCollection.Item<E>> iterator() {
                return new ItemItr(EntityList.this.entities.iterator());
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append('[');
                boolean addComma = false;
                for (EntityCollection.Item item : this) {
                    if (addComma) {
                        builder.append(", ");
                    } else {
                        addComma = true;
                    }
                    builder.append(item);
                }
                builder.append(']');
                return builder.toString();
            }
        };
    }

    private static class SingleItr<E>
    implements Iterator<E> {
        private E data;

        private SingleItr(E data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.data != null;
        }

        @Override
        public E next() {
            E e = this.data;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.data = null;
            return e;
        }
    }

    private static class ItemImpl<E>
    implements EntityCollection.Item<E> {
        private final E data;

        private ItemImpl(E data) {
            this.data = data;
        }

        @Override
        public E getEntity() {
            return this.data;
        }

        @Override
        public Iterable<E> getOriginalEntities() {
            return new Iterable<E>(){

                @Override
                @NotNull
                public Iterator<E> iterator() {
                    return new SingleItr(data);
                }
            };
        }

        public String toString() {
            return "{entity:" + this.data + "}";
        }
    }

    private static class ItemItr<E>
    implements Iterator<EntityCollection.Item<E>> {
        private final Iterator<E> itr;

        private ItemItr(Iterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public EntityCollection.Item<E> next() {
            return new ItemImpl(this.itr.next());
        }
    }
}

