/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.ast.mutation.QueryReason;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;

class EntityInvestigator {
    private final int[] rowCounts;
    private final SaveContext ctx;
    private final Shape shape;
    private final Collection<? extends DraftSpi> entities;
    private final boolean updatable;
    private final ImmutableProp idProp;
    private final KeyMatcher keyMatcher;
    private final Map<ImmutableType, Fetcher<ImmutableSpi>> idFetcherMap = new HashMap<ImmutableType, Fetcher<ImmutableSpi>>();
    private final List<ImmutableProp> missedProps;
    private final boolean isIdMissed;
    private final KeyMatcher.Group primaryGroup;
    private final String uncheckedGroupName;

    EntityInvestigator(int[] rowCounts, SaveContext ctx, Shape shape, Collection<? extends DraftSpi> entities, boolean updatable) {
        this.rowCounts = rowCounts;
        this.ctx = ctx;
        this.shape = shape;
        this.entities = entities;
        this.updatable = updatable;
        this.idProp = ctx.path.getType().getIdProp();
        this.keyMatcher = ctx.options.getKeyMatcher(ctx.path.getType());
        this.missedProps = this.keyMatcher.missedProps(shape.getGetterMap().keySet());
        this.isIdMissed = shape.getIdGetters().isEmpty() && shape.getType().getIdGenerator((SqlContext)ctx.options.getSqlClient()) instanceof IdentityIdGenerator;
        KeyMatcher.Group group = this.primaryGroup = this.isIdMissed ? this.keyMatcher.match(shape.getGetterMap().keySet()) : null;
        this.uncheckedGroupName = this.isIdMissed && updatable ? (this.primaryGroup != null ? this.primaryGroup.getName() : null) : null;
    }

    public Exception investigate() {
        Dialect dialect = this.ctx.options.getSqlClient().getDialect();
        if (dialect.isBatchDumb() || dialect.isBatchUpdateExceptionUnreliable()) {
            this.fillMissedProps(this.entities);
            Exception translated = this.translateAll();
            if (translated != null) {
                return translated;
            }
        } else {
            if (this.rowCounts.length >= 10) {
                int failedCount = 0;
                for (int rowCount : this.rowCounts) {
                    if (rowCount >= 0 || ++failedCount < 10) continue;
                    return this.translateAll();
                }
            }
            int index = 0;
            Object object = this.entities.iterator();
            while (object.hasNext()) {
                DraftSpi entity = (DraftSpi)object.next();
                if (index < this.rowCounts.length && this.rowCounts[index++] >= 0) continue;
                this.fillMissedProps(Collections.singletonList(entity));
                Exception translated = this.translateOne(entity);
                if (translated == null) continue;
                return translated;
            }
        }
        return null;
    }

    private List<ImmutableProp> fillMissedProps(Collection<? extends DraftSpi> drafts) {
        if (this.missedProps.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.isIdMissed) {
            PropId idPropId = this.idProp.getId();
            Map<Object, ImmutableSpi> rowMap = Rows.findMapByIds(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null, this.missedProps), drafts);
            for (DraftSpi draftSpi : drafts) {
                ImmutableSpi row;
                if (!draftSpi.__isLoaded(idPropId) || (row = rowMap.get(draftSpi.__get(idPropId))) == null) continue;
                for (ImmutableProp missedProp : this.missedProps) {
                    PropId missedPropId = missedProp.getId();
                    draftSpi.__set(missedPropId, row.__get(missedPropId));
                }
            }
        } else {
            KeyMatcher.Group group = this.keyMatcher.match(this.shape.getGetterMap().keySet());
            if (group == null) {
                return Collections.emptyList();
            }
            Map<Object, ImmutableSpi> rowMap = Rows.findMapByKeys(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.keyFetcher(group.getProps(), this.missedProps), drafts, this.keyMatcher.getGroup(group.getName())).values().iterator().next();
            for (DraftSpi draftSpi : drafts) {
                Object key = Keys.keyOf((ImmutableSpi)draftSpi, group.getProps());
                ImmutableSpi row = rowMap.get(key);
                if (row == null) continue;
                for (ImmutableProp missedProp : this.missedProps) {
                    PropId missedPropId = missedProp.getId();
                    draftSpi.__set(missedPropId, row.__get(missedPropId));
                }
            }
        }
        return this.missedProps;
    }

    private Exception translateOne(DraftSpi entity) {
        List<ImmutableSpi> rows;
        PropId idPropId = this.idProp.getId();
        if (!(this.updatable || this.isIdMissed || (rows = Rows.findByIds(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null), Collections.singletonList(entity))).isEmpty())) {
            return this.ctx.createConflictId(this.idProp, entity.__get(idPropId));
        }
        for (Map.Entry e : this.keyMatcher.toMap().entrySet()) {
            ImmutableSpi row;
            List<ImmutableSpi> rows2;
            Map<KeyMatcher.Group, List<ImmutableSpi>> rowsMap;
            Set keyProps;
            String groupName = (String)e.getKey();
            if (groupName.equals(this.uncheckedGroupName) || (keyProps = (Set)e.getValue()).isEmpty() || !EntityInvestigator.containsAny(this.shape.getGetterMap().keySet(), keyProps) || this.updatable && this.isIdMissed && this.primaryGroup == null || (rowsMap = Rows.findByKeys(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null, this.primaryGroup != null ? this.primaryGroup.getProps() : null), Collections.singletonList(entity), this.keyMatcher.getGroup(groupName))).isEmpty() || (rows2 = rowsMap.values().iterator().next()).isEmpty() || this.isSameIdentifier((ImmutableSpi)entity, row = rows2.iterator().next(), idPropId, this.primaryGroup)) continue;
            return this.ctx.createConflictKey(keyProps, Keys.keyOf((ImmutableSpi)entity, keyProps));
        }
        for (ImmutableProp prop : entity.__type().getProps().values()) {
            PropId associatedIdPropId;
            Object associatedObject;
            PropId propId = prop.getId();
            if (!entity.__isLoaded(propId) || !prop.isColumnDefinition() || !prop.isTargetForeignKeyReal(this.ctx.options.getSqlClient().getMetadataStrategy()) || !prop.isReference(TargetLevel.PERSISTENT) || prop.isRemote() || this.ctx.options.isAutoCheckingProp(prop) || (associatedObject = entity.__get(propId)) == null || !((ImmutableSpi)associatedObject).__isLoaded(associatedIdPropId = prop.getTargetType().getIdProp().getId())) continue;
            Object associatedId = ((ImmutableSpi)associatedObject).__get(associatedIdPropId);
            List<ImmutableSpi> rows3 = Rows.findRows(this.ctx.prop(prop), QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(prop.getTargetType()), (q, t) -> q.where(t.getId().eq(associatedId)));
            if (!rows3.isEmpty()) continue;
            return this.ctx.prop(prop).createIllegalTargetId(Collections.singleton(associatedId));
        }
        return null;
    }

    private Exception translateAll() {
        if (!this.updatable && !this.isIdMissed) {
            PropId idPropId = this.idProp.getId();
            Map<Object, ImmutableSpi> map = Rows.findMapByIds(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null), this.entities);
            for (ImmutableSpi immutableSpi : this.entities) {
                Object id = immutableSpi.__get(idPropId);
                if (map.containsKey(id)) {
                    return this.ctx.createConflictId(this.idProp, id);
                }
                map.put(id, immutableSpi);
            }
        }
        for (Map.Entry entry : this.keyMatcher.toMap().entrySet()) {
            Map<Object, ImmutableSpi> rowMap;
            Set set;
            String string = (String)entry.getKey();
            if (string.equals(this.uncheckedGroupName) || (set = (Set)entry.getValue()).isEmpty() || !EntityInvestigator.containsAny(this.shape.getGetterMap().keySet(), set) || this.updatable && this.isIdMissed && this.primaryGroup == null || (rowMap = Rows.findMapByKeys(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.keyFetcher(set, this.primaryGroup != null ? this.primaryGroup.getProps() : null), this.entities, this.keyMatcher.getGroup(string)).values().iterator().next()) == null || rowMap.isEmpty()) continue;
            PropId idPropId = this.idProp.getId();
            for (ImmutableSpi immutableSpi : this.entities) {
                Object key = Keys.keyOf(immutableSpi, set);
                ImmutableSpi row = rowMap.get(key);
                if (row != null) {
                    if (this.isSameIdentifier(immutableSpi, row, idPropId, this.primaryGroup)) continue;
                    return this.ctx.createConflictKey(set, Keys.keyOf(immutableSpi, set));
                }
                rowMap.put(key, immutableSpi);
            }
        }
        LinkedHashMap<ImmutableProp, Set> targetIdMultiMap = new LinkedHashMap<ImmutableProp, Set>();
        for (ImmutableSpi immutableSpi : this.entities) {
            for (ImmutableProp prop : immutableSpi.__type().getProps().values()) {
                PropId propId;
                Object associatedObject;
                PropId propId2 = prop.getId();
                if (!immutableSpi.__isLoaded(propId2) || !prop.isColumnDefinition() || !prop.isTargetForeignKeyReal(this.ctx.options.getSqlClient().getMetadataStrategy()) || !prop.isReference(TargetLevel.PERSISTENT) || prop.isRemote() || this.ctx.options.isAutoCheckingProp(prop) || (associatedObject = immutableSpi.__get(propId2)) == null || !((ImmutableSpi)associatedObject).__isLoaded(propId = prop.getTargetType().getIdProp().getId())) continue;
                Object associatedId = ((ImmutableSpi)associatedObject).__get(propId);
                targetIdMultiMap.computeIfAbsent(prop, it -> new LinkedHashSet()).add(associatedId);
            }
        }
        for (Map.Entry entry : targetIdMultiMap.entrySet()) {
            ImmutableProp immutableProp = (ImmutableProp)entry.getKey();
            Set associatedIds = (Set)entry.getValue();
            List<ImmutableSpi> rows = Rows.findRows(this.ctx.prop(immutableProp), QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(immutableProp.getTargetType()), (q, t) -> q.where(t.getId().in(associatedIds)));
            PropId targetIdPropId = immutableProp.getTargetType().getIdProp().getId();
            HashSet<Object> hashSet = new HashSet<Object>((rows.size() * 4 + 2) / 3);
            for (ImmutableSpi row : rows) {
                hashSet.add(row.__get(targetIdPropId));
            }
            for (Object associatedId : associatedIds) {
                if (hashSet.contains(associatedId)) continue;
                return this.ctx.prop(immutableProp).createIllegalTargetId(Collections.singleton(associatedId));
            }
        }
        return null;
    }

    private boolean isSameIdentifier(ImmutableSpi entity, ImmutableSpi row, PropId idPropId, KeyMatcher.Group primaryGroup) {
        if (!this.updatable) {
            return false;
        }
        if (primaryGroup != null) {
            return Objects.equals(Keys.keyOf(entity, primaryGroup.getProps()), Keys.keyOf(row, primaryGroup.getProps()));
        }
        return entity.__get(idPropId).equals(row.__get(idPropId));
    }

    private Fetcher<ImmutableSpi> idFetcher(ImmutableType type) {
        return this.idFetcherMap.computeIfAbsent(type, t -> {
            if (t == null) {
                t = this.ctx.path.getType();
            }
            return new FetcherImpl(t.getJavaClass());
        });
    }

    private Fetcher<ImmutableSpi> idFetcher(ImmutableType type, Iterable<ImmutableProp> missedProps) {
        Fetcher<ImmutableSpi> fetcher = this.idFetcher(type);
        if (missedProps != null) {
            for (ImmutableProp missedProp : missedProps) {
                if (missedProp.isReference(TargetLevel.ENTITY)) {
                    fetcher = fetcher.add(missedProp.getName(), IdOnlyFetchType.RAW);
                    continue;
                }
                fetcher = fetcher.add(missedProp.getName());
            }
        }
        return fetcher;
    }

    private Fetcher<ImmutableSpi> keyFetcher(Set<ImmutableProp> keyProps) {
        Fetcher<Object> fetcher = new FetcherImpl<ImmutableSpi>(this.ctx.path.getType().getJavaClass());
        for (ImmutableProp keyProp : keyProps) {
            if (keyProp.isReference(TargetLevel.ENTITY)) {
                fetcher = fetcher.add(keyProp.getName(), IdOnlyFetchType.RAW);
                continue;
            }
            fetcher = fetcher.add(keyProp.getName());
        }
        return fetcher;
    }

    private Fetcher<ImmutableSpi> keyFetcher(Set<ImmutableProp> keyProps, Iterable<ImmutableProp> missedProps) {
        Fetcher<ImmutableSpi> fetcher = this.keyFetcher(keyProps);
        if (missedProps != null) {
            for (ImmutableProp missedProp : missedProps) {
                if (missedProp.isReference(TargetLevel.ENTITY)) {
                    fetcher = fetcher.add(missedProp.getName(), IdOnlyFetchType.RAW);
                    continue;
                }
                fetcher = fetcher.add(missedProp.getName());
            }
        }
        return fetcher;
    }

    private static boolean containsAny(Collection<?> a, Collection<?> b) {
        for (Object be : b) {
            if (!a.contains(be)) continue;
            return true;
        }
        return false;
    }
}

