/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.TargetTransferMode;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.UnloadedVersionBehavior;
import org.babyfish.jimmer.sql.ast.mutation.UpsertMask;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.DtoMetadata;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class BatchEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements BatchEntitySaveCommand<E> {
    public BatchEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, Iterable<E> entities) {
        super(BatchEntitySaveCommandImpl.initialCfg(sqlClient, con, entities));
    }

    private BatchEntitySaveCommandImpl(AbstractCommandImpl.Cfg cfg) {
        super(cfg);
    }

    private static AbstractCommandImpl.Cfg initialCfg(JSqlClientImplementor sqlClient, Connection con, Iterable<?> entities) {
        ImmutableType type = null;
        for (Object entity : entities) {
            if (!(entity instanceof ImmutableSpi)) {
                throw new IllegalArgumentException("All the elements of entities must be immutable object");
            }
            if (!((ImmutableSpi)entity).__type().isEntity()) {
                throw new IllegalArgumentException("All the elements must be entity object");
            }
            if (entity instanceof DraftSpi) {
                throw new IllegalArgumentException("Each element of entity cannot be draft object");
            }
            ImmutableType entityType = ((ImmutableSpi)entity).__type();
            if (type != null && entityType != type) {
                throw new IllegalArgumentException("All the elements of entities must belong to same immutable type");
            }
            type = entityType;
        }
        AbstractCommandImpl.Cfg cfg = new AbstractCommandImpl.RootCfg(sqlClient, entities);
        if (con != null) {
            cfg = new AbstractCommandImpl.ConnectionCfg(cfg, con);
        }
        return cfg;
    }

    @Override
    public BatchEntitySaveCommand<E> setMode(SaveMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setAssociatedModeAll(AssociatedSaveMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setAssociatedMode(ImmutableProp prop, AssociatedSaveMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, prop, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setKeyProps(String group, ImmutableProp ... props) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyGroupsCfg(this.cfg, group, Arrays.asList(props)));
    }

    @Override
    public BatchEntitySaveCommand<E> setUpsertMask(UpsertMask<?> mask) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.UpsertMaskCfg(this.cfg, mask));
    }

    @Override
    public BatchEntitySaveCommand<E> setAutoIdOnlyTargetCheckingAll() {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, true));
    }

    @Override
    public BatchEntitySaveCommand<E> setAutoIdOnlyTargetChecking(ImmutableProp prop, boolean checking) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, prop, checking));
    }

    @Override
    public BatchEntitySaveCommand<E> setIdOnlyAsReferenceAll(boolean asReference) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAsReferenceCfg(this.cfg, asReference));
    }

    @Override
    public BatchEntitySaveCommand<E> setIdOnlyAsReference(ImmutableProp prop, boolean asReference) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAsReferenceCfg(this.cfg, prop, asReference));
    }

    @Override
    public BatchEntitySaveCommand<E> setKeyOnlyAsReferenceAll() {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyOnlyAsReferenceCfg(this.cfg, true));
    }

    @Override
    public BatchEntitySaveCommand<E> setKeyOnlyAsReference(ImmutableProp prop, boolean asReference) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyOnlyAsReferenceCfg(this.cfg, prop, asReference));
    }

    @Override
    public BatchEntitySaveCommand<E> setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.DissociationActionCfg(this.cfg, prop, dissociateAction));
    }

    @Override
    public BatchEntitySaveCommand<E> setTargetTransferMode(ImmutableProp prop, TargetTransferMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, prop, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setTargetTransferModeAll(TargetTransferMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setPessimisticLock(Class<?> entityType, boolean lock) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.PessimisticLockCfg(this.cfg, entityType, lock));
    }

    @Override
    public BatchEntitySaveCommand<E> setPessimisticLockAll() {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.PessimisticLockCfg(this.cfg, true));
    }

    @Override
    public <T extends Table<E>> BatchEntitySaveCommand<E> setOptimisticLock(Class<T> tableType, UnloadedVersionBehavior behavior, UserOptimisticLock<E, T> block) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, ImmutableType.get(tableType), behavior, block));
    }

    @Override
    public BatchEntitySaveCommand<E> setEntityOptimisticLock(ImmutableType type, UnloadedVersionBehavior behavior, UserOptimisticLock<Object, Table<Object>> block) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, type, behavior, block));
    }

    @Override
    public BatchEntitySaveCommand<E> setDeleteMode(DeleteMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.DeleteModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setMaxCommandJoinCount(int count) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.MaxCommandJoinCountCfg(this.cfg, count));
    }

    @Override
    public BatchEntitySaveCommand<E> setDumbBatchAcceptable(boolean acceptable) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.DumbBatchAcceptableCfg(this.cfg, acceptable));
    }

    @Override
    public BatchEntitySaveCommand<E> setConstraintViolationTranslatable(boolean transferable) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.ConstraintViolationTranslatableCfg(this.cfg, transferable));
    }

    @Override
    public BatchEntitySaveCommand<E> addExceptionTranslator(ExceptionTranslator<?> translator) {
        if (translator == null) {
            return this;
        }
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ExceptionTranslatorCfg(this.cfg, translator));
    }

    @Override
    public BatchEntitySaveCommand<E> setTransactionRequired(boolean required) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.TransactionRequiredCfg(this.cfg, required));
    }

    private static <E> Collection<E> entities(AbstractEntitySaveCommandImpl.OptionsImpl options) {
        Iterable iterable = (Iterable)options.getArument();
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        ArrayList list = new ArrayList();
        for (Object e : iterable) {
            list.add(e);
        }
        return list;
    }

    @Override
    public BatchSaveResult<E> execute(Connection con, Fetcher<E> fetcher) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        Collection<E> entities = BatchEntitySaveCommandImpl.entities(options);
        if (entities.isEmpty()) {
            return new BatchSaveResult(Collections.emptyMap(), Collections.emptyList());
        }
        return options.getSqlClient().getConnectionManager().execute(con == null ? options.getConnection() : con, (Connection c) -> this.executeImpl((Connection)c, fetcher));
    }

    @Override
    public <V extends View<E>> BatchSaveResult.View<E, V> execute(Connection con, Class<V> viewType) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        DtoMetadata metadata = DtoMetadata.of(viewType);
        Collection<E> entities = BatchEntitySaveCommandImpl.entities(options);
        if (entities.isEmpty()) {
            return new BatchSaveResult(Collections.emptyMap(), Collections.emptyList()).toView(metadata.getConverter());
        }
        BatchSaveResult result = options.getSqlClient().getConnectionManager().execute(con == null ? options.getConnection() : con, (Connection c) -> this.executeImpl((Connection)c, metadata.getFetcher()));
        return result.toView(metadata.getConverter());
    }

    private BatchSaveResult<E> executeImpl(Connection con, Fetcher<E> fetcher) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        if (options.isTransactionRequired()) {
            Executor.validateMutationConnection(con);
        }
        Collection<E> entities = BatchEntitySaveCommandImpl.entities(options);
        ImmutableType type = ImmutableType.get(entities.iterator().next().getClass());
        Saver saver = new Saver(options, con, type, fetcher);
        return saver.saveAll(entities);
    }
}

