/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.TargetTransferMode;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveCommandImplementor;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.UnloadedVersionBehavior;
import org.babyfish.jimmer.sql.ast.mutation.UpsertMask;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractEntitySaveCommandImpl
extends AbstractCommandImpl
implements AbstractEntitySaveCommand,
SaveCommandImplementor {
    AbstractEntitySaveCommandImpl(AbstractCommandImpl.Cfg cfg) {
        super(cfg);
    }

    @Override
    final SaveOptions createOptions() {
        return new OptionsImpl(this.cfg);
    }

    static final class OptionsImpl
    implements SaveOptions {
        private final JSqlClientImplementor sqlClient;
        private final Object argument;
        private final Connection con;
        private final SaveMode mode;
        private final AssociatedSaveMode associatedMode;
        private final Map<ImmutableProp, AssociatedSaveMode> associatedModeMap;
        private final DeleteMode deleteMode;
        private final int maxCommandJoinCount;
        private final Map<ImmutableType, KeyMatcher> keyMatcherMap;
        private final Map<ImmutableType, UpsertMask<?>> upsertMaskMap;
        private final Map<ImmutableProp, Boolean> autoCheckingMap;
        private final boolean autoCheckingAll;
        private final Map<ImmutableProp, Boolean> idOnlyAsReferenceMap;
        private final boolean idOnlyAsReferenceAll;
        private final Map<ImmutableProp, Boolean> keyOnlyAsReferenceMap;
        private final boolean keyOnlyAsReferenceAll;
        private final Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private final Map<ImmutableProp, TargetTransferMode> targetTransferModeMap;
        private final TargetTransferMode targetTransferModeAll;
        private final Map<ImmutableType, Boolean> pessimisticLockMap;
        private final boolean pessimisticLockAll;
        private final Map<ImmutableType, UnloadedVersionBehavior> optimisticLockBehaviorMap;
        private final Map<ImmutableType, UserOptimisticLock<Object, Table<Object>>> optimisticLockLambdaMap;
        private final boolean dumbBatchAcceptable;
        private final boolean constraintViolationTranslatable;
        private final ExceptionTranslator<Exception> exceptionTranslator;
        private final boolean transactionRequired;

        OptionsImpl(AbstractCommandImpl.Cfg cfg) {
            AbstractCommandImpl.RootCfg rootCfg = cfg.as(AbstractCommandImpl.RootCfg.class);
            AbstractCommandImpl.ConnectionCfg connectionCfg = cfg.as(AbstractCommandImpl.ConnectionCfg.class);
            ModeCfg modeCfg = cfg.as(ModeCfg.class);
            AssociatedModeCfg associatedModeCfg = cfg.as(AssociatedModeCfg.class);
            AbstractCommandImpl.DeleteModeCfg deleteModeCfg = cfg.as(AbstractCommandImpl.DeleteModeCfg.class);
            AbstractCommandImpl.MaxCommandJoinCountCfg maxCommandJoinCountCfg = cfg.as(AbstractCommandImpl.MaxCommandJoinCountCfg.class);
            KeyGroupsCfg keyPropsCfg = cfg.as(KeyGroupsCfg.class);
            UpsertMaskCfg upsertMaskCfg = cfg.as(UpsertMaskCfg.class);
            IdOnlyAutoCheckingCfg idOnlyAutoCheckingCfg = cfg.as(IdOnlyAutoCheckingCfg.class);
            IdOnlyAsReferenceCfg idOnlyAsReferenceCfg = cfg.as(IdOnlyAsReferenceCfg.class);
            KeyOnlyAsReferenceCfg keyOnlyAsReferenceCfg = cfg.as(KeyOnlyAsReferenceCfg.class);
            AbstractCommandImpl.DissociationActionCfg dissociationActionCfg = cfg.as(AbstractCommandImpl.DissociationActionCfg.class);
            TargetTransferModeCfg targetTransferModeCfg = cfg.as(TargetTransferModeCfg.class);
            PessimisticLockCfg pessimisticLockCfg = cfg.as(PessimisticLockCfg.class);
            OptimisticLockLambdaCfg optimisticLockLambdaCfg = cfg.as(OptimisticLockLambdaCfg.class);
            AbstractCommandImpl.DumbBatchAcceptableCfg dumbBatchAcceptableCfg = cfg.as(AbstractCommandImpl.DumbBatchAcceptableCfg.class);
            AbstractCommandImpl.ConstraintViolationTranslatableCfg constraintViolationTranslatableCfg = cfg.as(AbstractCommandImpl.ConstraintViolationTranslatableCfg.class);
            ExceptionTranslatorCfg exceptionTranslatorCfg = cfg.as(ExceptionTranslatorCfg.class);
            AbstractCommandImpl.TransactionRequiredCfg transactionRequiredCfg = cfg.as(AbstractCommandImpl.TransactionRequiredCfg.class);
            assert (rootCfg != null);
            this.sqlClient = rootCfg.sqlClient;
            this.argument = rootCfg.argument;
            this.con = connectionCfg != null ? connectionCfg.con : null;
            this.mode = modeCfg != null ? modeCfg.mode : SaveMode.UPSERT;
            this.associatedModeMap = AbstractCommandImpl.MapNode.toMap(associatedModeCfg, it -> it.mapNode);
            this.associatedMode = associatedModeCfg != null ? associatedModeCfg.defaultMode : AssociatedSaveMode.REPLACE;
            this.deleteMode = deleteModeCfg != null ? deleteModeCfg.mode : DeleteMode.AUTO;
            this.maxCommandJoinCount = maxCommandJoinCountCfg != null ? maxCommandJoinCountCfg.maxCommandJoinCount : this.sqlClient.getMaxCommandJoinCount();
            this.keyMatcherMap = this.keyMatcherMap(AbstractCommandImpl.MapNode.toMap(keyPropsCfg, it -> it.mapNode));
            this.upsertMaskMap = AbstractCommandImpl.MapNode.toMap(upsertMaskCfg, it -> it.mapNode);
            this.autoCheckingMap = AbstractCommandImpl.MapNode.toMap(idOnlyAutoCheckingCfg, it -> it.mapNode);
            this.autoCheckingAll = idOnlyAutoCheckingCfg != null && idOnlyAutoCheckingCfg.defaultValue;
            this.idOnlyAsReferenceMap = AbstractCommandImpl.MapNode.toMap(idOnlyAsReferenceCfg, it -> it.mapNode);
            this.idOnlyAsReferenceAll = idOnlyAsReferenceCfg == null || idOnlyAsReferenceCfg.defaultValue;
            this.keyOnlyAsReferenceMap = AbstractCommandImpl.MapNode.toMap(keyOnlyAsReferenceCfg, it -> it.mapNode);
            this.keyOnlyAsReferenceAll = keyOnlyAsReferenceCfg != null && keyOnlyAsReferenceCfg.defaultValue;
            this.dissociateActionMap = AbstractCommandImpl.MapNode.toMap(dissociationActionCfg, it -> it.mapNode);
            this.targetTransferModeMap = AbstractCommandImpl.MapNode.toMap(targetTransferModeCfg, it -> it.mapNode);
            this.targetTransferModeAll = targetTransferModeCfg != null ? targetTransferModeCfg.defaultMode : TargetTransferMode.AUTO;
            this.pessimisticLockMap = AbstractCommandImpl.MapNode.toMap(pessimisticLockCfg, it -> it.mapNode);
            this.pessimisticLockAll = pessimisticLockCfg != null ? pessimisticLockCfg.defaultValue : false;
            this.optimisticLockBehaviorMap = AbstractCommandImpl.MapNode.toMap(optimisticLockLambdaCfg, it -> it.behaviorMapNode);
            this.optimisticLockLambdaMap = AbstractCommandImpl.MapNode.toMap(optimisticLockLambdaCfg, it -> it.lamdadaMapNode);
            this.dumbBatchAcceptable = dumbBatchAcceptableCfg != null && dumbBatchAcceptableCfg.acceptable;
            boolean bl = this.constraintViolationTranslatable = constraintViolationTranslatableCfg != null ? constraintViolationTranslatableCfg.translatable : this.sqlClient.isConstraintViolationTranslatable();
            if (exceptionTranslatorCfg != null) {
                List<ExceptionTranslator<?>> translators;
                ExceptionTranslator<Exception> defaultTranslator = this.sqlClient.getExceptionTranslator();
                if (defaultTranslator == null) {
                    translators = AbstractCommandImpl.ListNode.toList(exceptionTranslatorCfg, it -> it.listNode);
                } else {
                    translators = new ArrayList();
                    translators.add(defaultTranslator);
                    translators.addAll(AbstractCommandImpl.ListNode.toList(exceptionTranslatorCfg, it -> it.listNode));
                }
                this.exceptionTranslator = ExceptionTranslator.of(translators);
            } else {
                this.exceptionTranslator = this.sqlClient.getExceptionTranslator();
            }
            this.transactionRequired = transactionRequiredCfg != null ? transactionRequiredCfg.required : this.sqlClient.isMutationTransactionRequired();
        }

        @Override
        public JSqlClientImplementor getSqlClient() {
            return this.sqlClient;
        }

        public <T> T getArument() {
            return (T)this.argument;
        }

        @Override
        public Connection getConnection() {
            return this.con;
        }

        @Override
        public Triggers getTriggers() {
            return this.sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY ? null : this.sqlClient.getTriggers();
        }

        @Override
        public SaveMode getMode() {
            return this.mode;
        }

        @Override
        public AssociatedSaveMode getAssociatedMode(ImmutableProp prop) {
            AssociatedSaveMode mode = this.associatedModeMap.get(prop);
            return mode != null ? mode : this.associatedMode;
        }

        @Override
        public DeleteMode getDeleteMode() {
            return this.deleteMode;
        }

        @Override
        public int getMaxCommandJoinCount() {
            return this.maxCommandJoinCount;
        }

        @Override
        public KeyMatcher getKeyMatcher(ImmutableType type) {
            KeyMatcher keyMatcher = this.keyMatcherMap.get(type);
            if (keyMatcher != null) {
                return keyMatcher;
            }
            return type.getKeyMatcher();
        }

        @Override
        @Nullable
        public UpsertMask<?> getUpsertMask(ImmutableType type) {
            return this.upsertMaskMap.get(type);
        }

        @Override
        public boolean isAutoCheckingProp(ImmutableProp prop) {
            if (Boolean.FALSE.equals(this.autoCheckingMap.get(prop))) {
                return false;
            }
            switch (this.sqlClient.getIdOnlyTargetCheckingLevel()) {
                case ALL: {
                    return true;
                }
                case FAKE: {
                    if (prop.isTargetForeignKeyReal(this.sqlClient.getMetadataStrategy())) break;
                    return true;
                }
            }
            return this.autoCheckingAll || Boolean.TRUE.equals(this.autoCheckingMap.get(prop));
        }

        @Override
        public boolean isIdOnlyAsReference(ImmutableProp prop) {
            Boolean value = this.idOnlyAsReferenceMap.get(prop);
            if (value != null) {
                return value;
            }
            return this.idOnlyAsReferenceAll;
        }

        @Override
        public boolean isKeyOnlyAsReference(ImmutableProp prop) {
            Boolean value = this.keyOnlyAsReferenceMap.get(prop);
            if (value != null) {
                return value;
            }
            return this.keyOnlyAsReferenceAll;
        }

        @Override
        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        @Override
        public boolean isTargetTransferable(ImmutableProp prop) {
            TargetTransferMode mode = this.targetTransferModeMap.getOrDefault(prop, this.targetTransferModeAll);
            switch (mode) {
                case ALLOWED: {
                    return true;
                }
                case NOT_ALLOWED: {
                    return false;
                }
            }
            switch (prop.getTargetTransferMode()) {
                case ALLOWED: {
                    return true;
                }
                case NOT_ALLOWED: {
                    return false;
                }
            }
            return this.sqlClient.isTargetTransferable();
        }

        @Override
        public boolean isPessimisticLocked(ImmutableType type) {
            Boolean value = this.pessimisticLockMap.get(type);
            return value != null ? value : this.pessimisticLockAll;
        }

        @Override
        @NotNull
        public UnloadedVersionBehavior getUnloadedVersionBehavior(ImmutableType type) {
            return this.optimisticLockBehaviorMap.getOrDefault(type, UnloadedVersionBehavior.IGNORE);
        }

        public UserOptimisticLock<Object, Table<Object>> getUserOptimisticLock(ImmutableType type) {
            return this.optimisticLockLambdaMap.get(type);
        }

        @Override
        public boolean isBatchForbidden() {
            return this.sqlClient.isBatchForbidden(this.dumbBatchAcceptable);
        }

        @Override
        public boolean isConstraintViolationTranslatable() {
            return this.constraintViolationTranslatable;
        }

        @Override
        @Nullable
        public ExceptionTranslator<Exception> getExceptionTranslator() {
            return this.exceptionTranslator;
        }

        @Override
        public boolean isTransactionRequired() {
            return this.transactionRequired;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sqlClient, this.argument, this.mode, this.associatedMode, this.associatedModeMap, this.targetTransferModeMap, this.targetTransferModeAll, this.pessimisticLockMap, this.pessimisticLockAll, this.deleteMode, this.keyMatcherMap, this.autoCheckingAll, this.autoCheckingMap, this.dissociateActionMap});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OptionsImpl)) {
                return false;
            }
            OptionsImpl other = (OptionsImpl)o;
            return this.sqlClient == other.sqlClient && this.autoCheckingAll == other.autoCheckingAll && this.associatedMode == other.associatedMode && this.pessimisticLockAll == other.pessimisticLockAll && this.mode == other.mode && this.deleteMode == other.deleteMode && Objects.equals(this.argument, other.argument) && this.targetTransferModeMap.equals(other.targetTransferModeMap) && this.targetTransferModeAll == other.targetTransferModeAll && this.associatedModeMap.equals(other.associatedModeMap) && this.keyMatcherMap.equals(other.keyMatcherMap) && this.autoCheckingMap.equals(other.autoCheckingMap) && this.dissociateActionMap.equals(other.dissociateActionMap) && this.pessimisticLockMap.equals(other.pessimisticLockMap);
        }

        public String toString() {
            return "SaveOptions{sqlClient=" + this.sqlClient + ", mode=" + (Object)((Object)this.mode) + ", associatedMode=" + (Object)((Object)this.associatedMode) + ", associatedModeMap=" + this.associatedModeMap + ", targetTransferableMap=" + this.targetTransferModeMap + ", targetTransferModeAll=" + this.targetTransferModeAll + ", pessimisticLockMap" + this.pessimisticLockMap + ", pessimisticLockAll" + this.pessimisticLockAll + ", deleteMode=" + (Object)((Object)this.deleteMode) + ", keyMatcherMap=" + this.keyMatcherMap + ", autoCheckingMap=" + this.autoCheckingMap + ", autoCheckingAll=" + this.autoCheckingAll + ", dissociateActionMap=" + this.dissociateActionMap + ", optimisticLockLambdaMap=" + this.optimisticLockLambdaMap + '}';
        }

        private Map<ImmutableType, KeyMatcher> keyMatcherMap(Map<ImmutableType, Map<String, Set<ImmutableProp>>> map) {
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<ImmutableType, KeyMatcher> keyMatcherMap = new LinkedHashMap<ImmutableType, KeyMatcher>();
            for (Map.Entry<ImmutableType, Map<String, Set<ImmutableProp>>> e : map.entrySet()) {
                ImmutableType type = e.getKey();
                LinkedHashMap<String, Set<ImmutableProp>> groupMap = new LinkedHashMap<String, Set<ImmutableProp>>(type.getKeyMatcher().toMap());
                groupMap.putAll(e.getValue());
                keyMatcherMap.put(type, KeyMatcher.of((ImmutableType)type, groupMap));
            }
            return keyMatcherMap;
        }
    }

    static class ExceptionTranslatorCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.ListNode<ExceptionTranslator<?>> listNode;

        ExceptionTranslatorCfg(AbstractCommandImpl.Cfg prev, ExceptionTranslator<?> translator) {
            super(prev);
            ExceptionTranslatorCfg p = prev.as(ExceptionTranslatorCfg.class);
            this.listNode = new AbstractCommandImpl.ListNode(p != null ? p.listNode : null, translator);
        }
    }

    static class OptimisticLockLambdaCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableType, UnloadedVersionBehavior> behaviorMapNode;
        final AbstractCommandImpl.MapNode<ImmutableType, UserOptimisticLock<Object, Table<Object>>> lamdadaMapNode;

        public OptimisticLockLambdaCfg(AbstractCommandImpl.Cfg prev, ImmutableType type, UnloadedVersionBehavior behavior, UserOptimisticLock<Object, Table<Object>> block) {
            super(prev);
            if (!type.isEntity()) {
                throw new IllegalArgumentException("Cannot set the optimistic lock lambda for the type \"" + type + "\" because it is not entity");
            }
            OptimisticLockLambdaCfg p = prev.as(OptimisticLockLambdaCfg.class);
            this.behaviorMapNode = new AbstractCommandImpl.MapNode<ImmutableType, UnloadedVersionBehavior>(p != null ? p.behaviorMapNode : null, type, behavior);
            this.lamdadaMapNode = new AbstractCommandImpl.MapNode<ImmutableType, UserOptimisticLock<Object, Table<Object>>>(p != null ? p.lamdadaMapNode : null, type, block);
        }
    }

    static class PessimisticLockCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableType, Boolean> mapNode;
        final Boolean defaultValue;

        public PessimisticLockCfg(AbstractCommandImpl.Cfg prev, boolean defaultValue) {
            super(prev);
            PessimisticLockCfg p = prev.as(PessimisticLockCfg.class);
            this.mapNode = p != null ? p.mapNode : null;
            this.defaultValue = defaultValue;
        }

        public PessimisticLockCfg(AbstractCommandImpl.Cfg prev, Class<?> entityType, boolean checking) {
            super(prev);
            ImmutableType type = ImmutableType.get(entityType);
            PessimisticLockCfg p = prev.as(PessimisticLockCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode<ImmutableType, Boolean>(p != null ? p.mapNode : null, type, checking);
            this.defaultValue = p != null && p.defaultValue != false;
        }
    }

    static class TargetTransferModeCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableProp, TargetTransferMode> mapNode;
        final TargetTransferMode defaultMode;

        public TargetTransferModeCfg(AbstractCommandImpl.Cfg prev, TargetTransferMode defaultMode) {
            super(prev);
            TargetTransferModeCfg p = prev.as(TargetTransferModeCfg.class);
            this.mapNode = p != null ? p.mapNode : null;
            this.defaultMode = defaultMode;
        }

        public TargetTransferModeCfg(AbstractCommandImpl.Cfg prev, ImmutableProp prop, TargetTransferMode mode) {
            super(prev);
            TargetTransferModeCfg p;
            Annotation annotation = prop.getAssociationAnnotation();
            if (annotation instanceof OneToOne) {
                OneToOne oneToOne = (OneToOne)annotation;
                if (!oneToOne.mappedBy().isEmpty()) {
                    throw new IllegalArgumentException("In order to set target transfer mode, the one-to-one property \"" + prop + "\" must be inverse property(mappedBy)");
                }
            } else if (!(annotation instanceof OneToMany)) {
                throw new IllegalArgumentException("Cannot set the target transfer mode of the property \"" + prop + "\" because it is neither one-to-one property and one-to-many property");
            }
            this.mapNode = new AbstractCommandImpl.MapNode<ImmutableProp, TargetTransferMode>((p = prev.as(TargetTransferModeCfg.class)) != null ? p.mapNode : null, prop, mode);
            this.defaultMode = p != null ? p.defaultMode : TargetTransferMode.AUTO;
        }
    }

    static class KeyOnlyAsReferenceCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableProp, Boolean> mapNode;
        final boolean defaultValue;

        public KeyOnlyAsReferenceCfg(AbstractCommandImpl.Cfg prev, boolean defaultValue) {
            super(prev);
            KeyOnlyAsReferenceCfg p = prev.as(KeyOnlyAsReferenceCfg.class);
            this.mapNode = p != null ? p.mapNode : null;
            this.defaultValue = defaultValue;
        }

        public KeyOnlyAsReferenceCfg(AbstractCommandImpl.Cfg prev, ImmutableProp prop, boolean asReference) {
            super(prev);
            if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" is not association property");
            }
            KeyOnlyAsReferenceCfg p = prev.as(KeyOnlyAsReferenceCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode<ImmutableProp, Boolean>(p != null ? p.mapNode : null, prop, asReference);
            this.defaultValue = p != null && p.defaultValue;
        }
    }

    static class IdOnlyAsReferenceCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableProp, Boolean> mapNode;
        final boolean defaultValue;

        IdOnlyAsReferenceCfg(AbstractCommandImpl.Cfg prev, boolean defaultValue) {
            super(prev);
            IdOnlyAsReferenceCfg p = prev.as(IdOnlyAsReferenceCfg.class);
            this.mapNode = p != null ? p.mapNode : null;
            this.defaultValue = defaultValue;
        }

        IdOnlyAsReferenceCfg(AbstractCommandImpl.Cfg prev, ImmutableProp prop, boolean asReference) {
            super(prev);
            if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" is not association property");
            }
            IdOnlyAsReferenceCfg p = prev.as(IdOnlyAsReferenceCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode<ImmutableProp, Boolean>(p != null ? p.mapNode : null, prop, asReference);
            this.defaultValue = p == null || p.defaultValue;
        }
    }

    static class IdOnlyAutoCheckingCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableProp, Boolean> mapNode;
        final boolean defaultValue;

        public IdOnlyAutoCheckingCfg(AbstractCommandImpl.Cfg prev, boolean defaultValue) {
            super(prev);
            IdOnlyAutoCheckingCfg p = prev.as(IdOnlyAutoCheckingCfg.class);
            this.mapNode = p != null ? p.mapNode : null;
            this.defaultValue = defaultValue;
        }

        public IdOnlyAutoCheckingCfg(AbstractCommandImpl.Cfg prev, ImmutableProp prop, boolean lock) {
            super(prev);
            if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" is not association property");
            }
            IdOnlyAutoCheckingCfg p = prev.as(IdOnlyAutoCheckingCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode<ImmutableProp, Boolean>(p != null ? p.mapNode : null, prop, lock);
            this.defaultValue = p != null && p.defaultValue;
        }
    }

    static class UpsertMaskCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableType, UpsertMask<?>> mapNode;

        UpsertMaskCfg(AbstractCommandImpl.Cfg prev, UpsertMask<?> mask) {
            super(prev);
            Objects.requireNonNull(mask, "mask cannot be null");
            UpsertMaskCfg p = prev.as(UpsertMaskCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode(p != null ? p.mapNode : null, mask.getType(), mask);
        }
    }

    static class KeyGroupsCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableType, Map<String, Set<ImmutableProp>>> mapNode;

        public KeyGroupsCfg(AbstractCommandImpl.Cfg prev, String group, Collection<ImmutableProp> keyProps) {
            super(prev);
            if (group == null) {
                group = "";
            }
            if (keyProps.isEmpty()) {
                throw new IllegalArgumentException("keyProps cannot be empty");
            }
            ImmutableType type = null;
            LinkedHashMap map = new LinkedHashMap();
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : keyProps) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' of key group \"" + group + "\" cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' of key group \"" + group + "\" cannot be key property because it is version property");
                }
                if (!prop.isColumnDefinition()) {
                    throw new IllegalArgumentException("'" + prop + "' of key group \"" + group + "\" cannot be key property because it is not property with column definition");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties of key group \"" + group + "\"must belong to one type");
                }
                set.add(prop);
            }
            map.put(group, set);
            KeyGroupsCfg p = prev.as(KeyGroupsCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode<Object, LinkedHashMap<ImmutableType, Map<String, Set<ImmutableProp>>>>((AbstractCommandImpl.MapNode<Object, LinkedHashMap<ImmutableType, Map<String, Set<ImmutableProp>>>>)(p != null ? p.mapNode : null), type, map);
        }
    }

    static class AssociatedModeCfg
    extends AbstractCommandImpl.Cfg {
        final AbstractCommandImpl.MapNode<ImmutableProp, AssociatedSaveMode> mapNode;
        @Nullable
        final AssociatedSaveMode defaultMode;

        public AssociatedModeCfg(AbstractCommandImpl.Cfg prev, @Nullable AssociatedSaveMode defaultMode) {
            super(prev);
            AssociatedModeCfg p = prev.as(AssociatedModeCfg.class);
            this.mapNode = p != null ? p.mapNode : null;
            this.defaultMode = defaultMode != null ? defaultMode : AssociatedSaveMode.REPLACE;
        }

        public AssociatedModeCfg(AbstractCommandImpl.Cfg prev, ImmutableProp prop, AssociatedSaveMode mode) {
            super(prev);
            if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
                throw new IllegalArgumentException("Cannot specify the associated save mode for the property \"" + prop + "\" that is not an ORM association");
            }
            AssociatedModeCfg p = prev.as(AssociatedModeCfg.class);
            this.mapNode = new AbstractCommandImpl.MapNode<ImmutableProp, AssociatedSaveMode>(p != null ? p.mapNode : null, prop, mode);
            this.defaultMode = p != null ? p.defaultMode : AssociatedSaveMode.REPLACE;
        }
    }

    static class ModeCfg
    extends AbstractCommandImpl.Cfg {
        final SaveMode mode;

        public ModeCfg(AbstractCommandImpl.Cfg prev, SaveMode mode) {
            super(prev);
            this.mode = mode != null ? mode : SaveMode.UPSERT;
        }
    }
}

