/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.base;

import java.time.temporal.Temporal;
import java.util.Date;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

class BaseTableExpression<T>
implements ExpressionImplementor<T>,
Ast {
    private final ExpressionImplementor<T> raw;
    private final BaseTableOwner baseTableOwner;

    BaseTableExpression(ExpressionImplementor<T> raw, BaseTableOwner baseTableOwner) {
        if (raw instanceof BaseTableExpression) {
            raw = ((BaseTableExpression)raw).raw;
        }
        this.raw = raw;
        this.baseTableOwner = baseTableOwner;
    }

    BaseTableOwner getBaseTableOwner() {
        return this.baseTableOwner;
    }

    @Override
    public Class<T> getType() {
        return this.raw.getType();
    }

    @Override
    public int precedence() {
        return this.raw.precedence();
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        AstContext ctx = visitor.getAstContext();
        ctx.pushStatement(this.baseTableOwner.baseTable.getQuery().getMutableQuery());
        ((Ast)((Object)this.raw)).accept(visitor);
        ctx.popStatement();
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        AstContext ctx = builder.assertSimple().getAstContext();
        ctx.pushStatement(this.baseTableOwner.baseTable.getQuery().getMutableQuery());
        BaseSelectionMapper mapper = ctx.getBaseSelectionMapper(this.baseTableOwner);
        assert (mapper != null);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(mapper.getAlias())).sql(".c")).sql(Integer.toString(mapper.expressionIndex()));
        ctx.popStatement();
    }

    @Override
    public boolean hasVirtualPredicate() {
        return ((Ast)((Object)this.raw)).hasVirtualPredicate();
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        return ((Ast)((Object)this.raw)).resolveVirtualPredicate(ctx);
    }

    static class Tp<T extends Temporal & Comparable<?>>
    extends Cmp<T>
    implements TemporalExpressionImplementor<T> {
        Tp(ExpressionImplementor<T> raw, BaseTableOwner baseTableOwner) {
            super(raw, baseTableOwner);
        }
    }

    static class Dt<T extends Date>
    extends Cmp<T>
    implements DateExpressionImplementor<T> {
        Dt(ExpressionImplementor<T> raw, BaseTableOwner baseTableOwner) {
            super(raw, baseTableOwner);
        }
    }

    static class Num<N extends Number>
    extends Cmp<N>
    implements NumericExpressionImplementor<N> {
        Num(ExpressionImplementor<N> raw, BaseTableOwner baseTableOwner) {
            super(raw, baseTableOwner);
        }
    }

    static class Str
    extends Cmp<String>
    implements StringExpressionImplementor {
        Str(ExpressionImplementor<String> raw, BaseTableOwner baseTableOwner) {
            super(raw, baseTableOwner);
        }
    }

    static class Cmp<T extends Comparable<?>>
    extends BaseTableExpression<T>
    implements ComparableExpressionImplementor<T> {
        Cmp(ExpressionImplementor<T> raw, BaseTableOwner baseTableOwner) {
            super(raw, baseTableOwner);
        }
    }
}

