/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableKind;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSelections;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedBaseQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;

public abstract class AbstractBaseTableSymbol
implements BaseTableSymbol {
    private final TypedBaseQueryImplementor<?> query;
    protected final List<Selection<?>> selections;
    protected final byte[] kotlinSelectionTypes;
    protected final BaseTableKind kind;
    protected final BaseTableSymbol recursive;
    protected final TableLike<?> parent;
    private final WeakJoinHandle handle;
    private final JoinType joinType;

    protected AbstractBaseTableSymbol(TypedBaseQueryImplementor<?> query, List<Selection<?>> selections, byte[] kotlinSelectionTypes, BaseTableKind kind) {
        this.query = query;
        this.selections = this.wrapSelections(selections);
        this.kotlinSelectionTypes = kotlinSelectionTypes;
        this.kind = kind;
        this.parent = null;
        this.handle = null;
        this.joinType = JoinType.INNER;
        this.recursive = null;
    }

    protected AbstractBaseTableSymbol(BaseTableSymbol base, TableLike<?> parent, WeakJoinHandle handle, JoinType joinType, BaseTableSymbol recursive) {
        this.query = base.getQuery();
        this.selections = this.wrapSelections(base.getSelections());
        this.kotlinSelectionTypes = ((AbstractBaseTableSymbol)base).kotlinSelectionTypes;
        this.kind = ((AbstractBaseTableSymbol)base).kind;
        this.parent = Objects.requireNonNull(parent, "parent cannot be null");
        this.handle = Objects.requireNonNull(handle, "handle cannot be null");
        this.joinType = joinType;
        this.recursive = recursive;
    }

    private List<Selection<?>> wrapSelections(List<Selection<?>> selections) {
        return AbstractBaseTableSymbol.wrapSelections(selections, this);
    }

    public byte[] getKotlinSelectionTypes() {
        return this.kotlinSelectionTypes;
    }

    public static List<Selection<?>> wrapSelections(List<Selection<?>> selections, BaseTable baseTable) {
        int size = selections.size();
        ArrayList wrappedSelections = new ArrayList(selections.size());
        for (int i = 0; i < size; ++i) {
            Selection<?> wrappedSelection = BaseTableSelections.of(selections.get(i), baseTable, i);
            wrappedSelections.add(wrappedSelection);
        }
        return Collections.unmodifiableList(wrappedSelections);
    }

    @Override
    public ConfigurableBaseQueryImpl<?> getQuery() {
        if (this.query instanceof MergedBaseQueryImpl) {
            return ((MergedBaseQueryImpl)this.query).firstQuery();
        }
        return (ConfigurableBaseQueryImpl)this.query;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    @Override
    public TableLike<?> getParent() {
        return this.parent;
    }

    @Override
    public WeakJoinHandle getWeakJoinHandle() {
        return this.handle;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public boolean isCte() {
        return this.kind != BaseTableKind.DERIVED;
    }

    @Override
    public boolean isRecursiveCte() {
        return this.kind == BaseTableKind.RECURSIVE_CTE;
    }

    @Override
    public BaseTableSymbol getRecursive() {
        return this.recursive;
    }

    public abstract AbstractBaseTableSymbol query(TypedBaseQueryImplementor<?> var1);

    protected final String suffix() {
        return this.kind == BaseTableKind.RECURSIVE_CTE ? "(RecursiveCTE)" : (this.kind == BaseTableKind.CTE ? "(CTE)" : "");
    }

    public static <T extends BaseTable> T validateCte(T baseTable, boolean cte) {
        if (((AbstractBaseTableSymbol)baseTable).kind == BaseTableKind.DERIVED == cte) {
            throw new IllegalStateException("BaseQuery does not support calling `asBaseTable`/`asCteBaseTable` multiple times with different parameters.");
        }
        return baseTable;
    }
}

