/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ScalarProviderUtils;
import org.babyfish.jimmer.sql.ast.impl.util.ArrayUtils;
import org.babyfish.jimmer.sql.collection.TypedList;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Variables {
    public static Object process(@Nullable Object value, @NotNull ImmutableProp prop, @NotNull JSqlClientImplementor sqlClient) {
        return Variables.process(value, prop, true, sqlClient);
    }

    public static Object process(@Nullable Object value, @NotNull ImmutableProp prop, boolean applyScalarProvider, @NotNull JSqlClientImplementor sqlClient) {
        SingleColumn singleColumn;
        Storage storage;
        if (value instanceof DbLiteral) {
            return value;
        }
        if (prop.isReference(TargetLevel.ENTITY)) {
            if (value != null) {
                value = ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getId());
            }
            prop = prop.getTargetType().getIdProp();
        }
        if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return new DbLiteral.DbValue(prop, Variables.handleDateTime(value, sqlClient.getZoneId()), false);
        }
        if (applyScalarProvider) {
            ScalarProvider scalarProvider = sqlClient.getScalarProvider(prop);
            if (scalarProvider != null && value != null) {
                try {
                    value = ScalarProviderUtils.toSql(value, scalarProvider, sqlClient.getDialect());
                }
                catch (Exception ex) {
                    throw new ExecutionException("The value \"" + value + "\" cannot be converted by the scalar provider \"" + scalarProvider + "\"");
                }
            }
            if (value == null) {
                return new DbLiteral.DbNull(scalarProvider != null ? ScalarProviderUtils.getSqlType(scalarProvider, sqlClient.getDialect()) : prop.getReturnClass());
            }
            if (scalarProvider != null) {
                return scalarProvider.isJsonScalar() ? new DbLiteral.DbValue(prop, value, true) : Variables.handleDateTime(value, sqlClient.getZoneId());
            }
        }
        if (value == null) {
            return new DbLiteral.DbNull(prop.getReturnClass());
        }
        if (value instanceof Collection && prop.isScalar(TargetLevel.ENTITY)) {
            TypedList arr = (TypedList)Array.newInstance(Classes.boxTypeOf((Class)prop.getElementClass()), ((Collection)value).size());
            ((Collection)value).toArray((T[])arr);
            value = arr;
        }
        if (value.getClass().isArray() && (storage = prop.getStorage(sqlClient.getMetadataStrategy())) instanceof SingleColumn && (singleColumn = (SingleColumn)storage).getSqlElementType() != null) {
            value = new TypedList(singleColumn.getSqlElementType(), ArrayUtils.toObject(value));
        }
        return Variables.handleDateTime(value, sqlClient.getZoneId());
    }

    public static Object process(@Nullable Object value, @NotNull Class<?> type, @NotNull JSqlClientImplementor sqlClient) {
        ScalarProvider scalarProvider = sqlClient.getScalarProvider(type);
        if (value == null) {
            return new DbLiteral.DbNull(scalarProvider != null ? ScalarProviderUtils.getSqlType(scalarProvider, sqlClient.getDialect()) : type);
        }
        if (scalarProvider != null) {
            try {
                return ScalarProviderUtils.toSql(value, scalarProvider, sqlClient.getDialect());
            }
            catch (Exception e) {
                throw new ExecutionException("Cannot convert \"" + value + "\" by \"" + scalarProvider.getClass().getName() + "\"");
            }
        }
        return Variables.handleDateTime(value, sqlClient.getZoneId());
    }

    private static Object handleDateTime(Object value, ZoneId zoneId) {
        if (value instanceof Instant) {
            return Timestamp.from((Instant)value);
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.from(((LocalDateTime)value).atZone(zoneId).toInstant());
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return Time.valueOf((LocalTime)value);
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        return value;
    }
}

