/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ConcatExpression;
import org.babyfish.jimmer.sql.ast.impl.LPadExpression;
import org.babyfish.jimmer.sql.ast.impl.LTrimExpression;
import org.babyfish.jimmer.sql.ast.impl.LeftExpression;
import org.babyfish.jimmer.sql.ast.impl.LengthExpression;
import org.babyfish.jimmer.sql.ast.impl.LikePredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.LowerExpression;
import org.babyfish.jimmer.sql.ast.impl.ParameterUtils;
import org.babyfish.jimmer.sql.ast.impl.PositionExpression;
import org.babyfish.jimmer.sql.ast.impl.RPadExpression;
import org.babyfish.jimmer.sql.ast.impl.RTrimExpression;
import org.babyfish.jimmer.sql.ast.impl.ReplaceExpression;
import org.babyfish.jimmer.sql.ast.impl.ReverseExpression;
import org.babyfish.jimmer.sql.ast.impl.RightExpression;
import org.babyfish.jimmer.sql.ast.impl.SubstringExpression;
import org.babyfish.jimmer.sql.ast.impl.TrimExpression;
import org.babyfish.jimmer.sql.ast.impl.UpperExpression;
import org.jetbrains.annotations.NotNull;

public interface StringExpressionImplementor
extends StringExpression,
ComparableExpressionImplementor<String> {
    @Override
    default public Class<String> getType() {
        return String.class;
    }

    @Override
    @NotNull
    default public Predicate like(@NotNull String pattern, @NotNull LikeMode likeMode) {
        return LikePredicate.of(this, ParameterUtils.validate("like", "pattern", pattern), false, Objects.requireNonNull(likeMode, "`likeMode` cannot be null"));
    }

    @Override
    @NotNull
    default public Predicate ilike(@NotNull String pattern, @NotNull LikeMode likeMode) {
        return LikePredicate.of(this, ParameterUtils.validate("ilike", "pattern", pattern), true, Objects.requireNonNull(likeMode, "`likeMode` cannot be null"));
    }

    @Override
    default public StringExpression upper() {
        return new UpperExpression(this);
    }

    @Override
    default public StringExpression lower() {
        return new LowerExpression(this);
    }

    @Override
    default public StringExpression trim() {
        return new TrimExpression(this);
    }

    @Override
    default public StringExpression ltrim() {
        return new LTrimExpression(this);
    }

    @Override
    default public StringExpression rtrim() {
        return new RTrimExpression(this);
    }

    @Override
    default public NumericExpression<Integer> length() {
        return new LengthExpression(this);
    }

    @Override
    default public StringExpression concat(String ... others) {
        return this.concat((Expression[])Arrays.stream(others).filter(it -> it != null && !it.isEmpty()).map(Literals::string).toArray(StringExpression[]::new));
    }

    @Override
    @NotNull
    default public StringExpression concat(Expression<String> ... others) {
        List<Expression<String>> exprs = Arrays.stream(others).filter(Objects::nonNull).collect(Collectors.toList());
        if (exprs.isEmpty()) {
            return this;
        }
        return new ConcatExpression(this, exprs);
    }

    @Override
    default public StringExpression substring(Expression<Integer> start, Expression<Integer> length) {
        return new SubstringExpression(this, start, length);
    }

    @Override
    @NotNull
    default public StringExpression coalesce(String defaultValue) {
        return this.coalesceBuilder().or(defaultValue).build();
    }

    @Override
    @NotNull
    default public StringExpression coalesce(Expression<String> defaultExpr) {
        return ((CoalesceBuilder.Str)this.coalesceBuilder().or((Expression)defaultExpr)).build();
    }

    @Override
    default public  @NotNull CoalesceBuilder.Str coalesceBuilder() {
        return new CoalesceBuilder.Str(this);
    }

    @Override
    default public StringExpression replace(String target, String replacement) {
        return new ReplaceExpression(this, Objects.requireNonNull(target, "target cannot be null"), Objects.requireNonNull(replacement, "replacement cannot be null"));
    }

    @Override
    default public StringExpression reverse() {
        return new ReverseExpression(this);
    }

    @Override
    default public StringExpression lpad(int length, String padString) {
        return this.lpad(Literals.number(length), padString);
    }

    @Override
    default public StringExpression lpad(Expression<Integer> length, String padString) {
        return new LPadExpression(this, Objects.requireNonNull(length, "length cannot be null"), Literals.string(Objects.requireNonNull(padString, "padString cannot be null")));
    }

    @Override
    default public StringExpression rpad(int length, String padString) {
        return this.rpad(Literals.number(length), padString);
    }

    @Override
    default public StringExpression rpad(Expression<Integer> length, String padString) {
        return new RPadExpression(this, Objects.requireNonNull(length, "length cannot be null"), Literals.string(Objects.requireNonNull(padString, "padString cannot be null")));
    }

    @Override
    default public NumericExpression<Integer> position(String substring, Expression<Integer> start) {
        return new PositionExpression(Literals.string(Objects.requireNonNull(substring, "substring cannot be null")), this, start);
    }

    @Override
    default public StringExpression left(Expression<Integer> length) {
        return new LeftExpression(this, Objects.requireNonNull(length, "length cannot be null"));
    }

    @Override
    default public StringExpression right(Expression<Integer> length) {
        return new RightExpression(this, Objects.requireNonNull(length, "length cannot be null"));
    }
}

