/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NativeBuilder;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.PredicateImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

public class NativeBuilderImpl<T>
implements NativeBuilder<T> {
    protected final Class<T> type;
    private final String sql;
    private final List<Expression<?>> expressions = new ArrayList();
    private final List<Expression<?>> values = new ArrayList();

    NativeBuilderImpl(Class<T> type, String sql) {
        this.type = type;
        this.sql = sql;
    }

    public static <T> NativeBuilder<T> any(Class<T> type, String sql) {
        if (String.class == type) {
            return new Str(sql);
        }
        if (Boolean.TYPE == type || Boolean.class == type) {
            return new Prd(sql);
        }
        if (Number.class.isAssignableFrom(type)) {
            return new Num<T>(type, sql);
        }
        if (Comparable.class.isAssignableFrom(type)) {
            return new Cmp<T>(type, sql);
        }
        return new NativeBuilderImpl<T>(type, sql);
    }

    public static NativeBuilder.Str string(String sql) {
        return new Str(sql);
    }

    public static <T extends Comparable<?>> NativeBuilder.Cmp<T> comparable(Class<T> type, String sql) {
        if (Number.class.isAssignableFrom(type)) {
            return new Num<T>(type, sql);
        }
        return new Cmp<T>(type, sql);
    }

    public static <N extends Number> NativeBuilder.Num<N> numeric(Class<N> type, String sql) {
        return new Num<N>(type, sql);
    }

    public static NativeBuilder.Prd predicate(String sql) {
        return new Prd(sql);
    }

    @Override
    @NotNull
    public NativeBuilder<T> expression(@NotNull Expression<?> expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        this.expressions.add(expression);
        return this;
    }

    @Override
    @NotNull
    public NativeBuilder<T> value(@NotNull Object value) {
        Objects.requireNonNull(value, "value cannot be null");
        if (value instanceof Expression) {
            throw new IllegalArgumentException("value() cannot accept expression, please call expression()");
        }
        this.values.add(Literals.any(value));
        return this;
    }

    protected final List<Object> parts() {
        return NativeBuilderImpl.parts(this.sql, this.expressions, this.values);
    }

    public static List<Object> parts(String sql, List<?> expressions, List<?> values) {
        ArrayList<Object> parts = new ArrayList<Object>();
        int size = sql.length();
        int start = 0;
        boolean isStr = false;
        int usedExpressionCount = 0;
        int usedValueCount = 0;
        block4: for (int i = 0; i < size; ++i) {
            char nextNext;
            char c = sql.charAt(i);
            if (c == '\'') {
                isStr = !isStr;
                continue;
            }
            if (isStr || c != '%' || i + 1 >= size) continue;
            char next = sql.charAt(i + 1);
            char c2 = nextNext = i + 2 < size ? sql.charAt(i + 2) : (char)'\u0000';
            if (Character.isLetter(nextNext) || Character.isDigit(nextNext)) continue;
            switch (next) {
                case 'e': {
                    if (start < i) {
                        parts.add(sql.substring(start, i));
                    }
                    start = i + 2;
                    if (usedExpressionCount >= expressions.size()) {
                        throw new IllegalArgumentException("Not enough expressions");
                    }
                    parts.add(expressions.get(usedExpressionCount++));
                    continue block4;
                }
                case 'v': {
                    if (start < i) {
                        parts.add(sql.substring(start, i));
                    }
                    start = i + 2;
                    if (usedValueCount >= values.size()) {
                        throw new IllegalArgumentException("Not enough values");
                    }
                    parts.add(values.get(usedValueCount++));
                }
            }
        }
        if (usedExpressionCount < expressions.size()) {
            throw new IllegalArgumentException("Too many expressions");
        }
        if (usedValueCount < values.size()) {
            throw new IllegalArgumentException("Too many values");
        }
        if (start < size) {
            parts.add(sql.substring(start));
        }
        return parts;
    }

    @Override
    @NotNull
    public Expression<T> build() {
        return new AnyExpression(this.type, this.parts());
    }

    private static class Str
    extends NativeBuilderImpl<String>
    implements NativeBuilder.Str {
        Str(String sql) {
            super(String.class, sql);
        }

        @Override
        @NotNull
        public NativeBuilder.Str expression(@NotNull Expression<?> expression) {
            return (NativeBuilder.Str)super.expression((Expression)expression);
        }

        @Override
        @NotNull
        public NativeBuilder.Str value(@NotNull Object value) {
            return (NativeBuilder.Str)super.value(value);
        }

        @Override
        @NotNull
        public StringExpression build() {
            return new StrExpression(this.parts());
        }
    }

    private static class Prd
    extends NativeBuilderImpl<Boolean>
    implements NativeBuilder.Prd {
        Prd(String sql) {
            super(Boolean.class, sql);
        }

        @Override
        @NotNull
        public NativeBuilder.Prd expression(@NotNull Expression<?> expression) {
            return (NativeBuilder.Prd)super.expression((Expression)expression);
        }

        @Override
        @NotNull
        public NativeBuilder.Prd value(@NotNull Object value) {
            return (NativeBuilder.Prd)super.value(value);
        }

        @Override
        @NotNull
        public Predicate build() {
            return new PrdExpression(this.parts());
        }
    }

    private static class Num<N extends Number>
    extends Cmp<N>
    implements NativeBuilder.Num<N> {
        Num(Class<N> type, String sql) {
            super(type, sql);
        }

        @Override
        @NotNull
        public NativeBuilder.Num<N> expression(@NotNull Expression<?> expression) {
            return (NativeBuilder.Num)super.expression((Expression)expression);
        }

        @Override
        @NotNull
        public NativeBuilder.Num<N> value(@NotNull Object value) {
            return (NativeBuilder.Num)super.value(value);
        }

        @Override
        @NotNull
        public NumericExpression<N> build() {
            return new NumExpression(this.type, this.parts());
        }
    }

    private static class Cmp<T extends Comparable<?>>
    extends NativeBuilderImpl<T>
    implements NativeBuilder.Cmp<T> {
        Cmp(Class<T> type, String sql) {
            super(type, sql);
        }

        @Override
        @NotNull
        public NativeBuilder.Cmp<T> expression(@NotNull Expression<?> expression) {
            return (NativeBuilder.Cmp)super.expression((Expression)expression);
        }

        @Override
        @NotNull
        public NativeBuilder.Cmp<T> value(@NotNull Object value) {
            return (NativeBuilder.Cmp)super.value(value);
        }

        @Override
        @NotNull
        public ComparableExpression<T> build() {
            return new CmpExpression(this.type, this.parts());
        }
    }

    private static class AnyExpression<T>
    extends AbstractExpression<T> {
        private final Class<T> type;
        private final List<Object> parts;

        private AnyExpression(Class<T> type, List<Object> parts) {
            this.type = type;
            this.parts = parts;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public int precedence() {
            return 0;
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
            for (Object part : this.parts) {
                if (!(part instanceof Ast)) continue;
                ((Ast)part).accept(visitor);
            }
        }

        @Override
        public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
            for (Object part : this.parts) {
                if (part instanceof Ast) {
                    this.renderChild((Ast)part, builder);
                    continue;
                }
                builder.sql((String)part);
            }
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return AnyExpression.hasVirtualPredicate(this.parts);
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            ListIterator<Object> itr = this.parts.listIterator();
            while (itr.hasNext()) {
                Object newPart;
                Object part = itr.next();
                if (part == (newPart = ctx.resolveVirtualPredicate(part))) continue;
                if (newPart == null) {
                    throw new IllegalArgumentException("Native SQL Expression does not support virtual predicate");
                }
                itr.set(newPart);
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnyExpression any = (AnyExpression)o;
            return this.type.equals(any.type) && this.parts.equals(any.parts);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.parts);
        }
    }

    private static class PrdExpression
    extends AnyExpression<Boolean>
    implements PredicateImplementor {
        private PrdExpression(List<Object> parts) {
            super(Boolean.class, parts);
        }
    }

    private static class CmpExpression<T extends Comparable<?>>
    extends AnyExpression<T>
    implements ComparableExpressionImplementor<T> {
        private CmpExpression(Class<T> type, List<Object> parts) {
            super(type, parts);
        }
    }

    private static class TemporalExpression<T extends Temporal & Comparable<?>>
    extends CmpExpression<T>
    implements TemporalExpressionImplementor<T> {
        private TemporalExpression(Class<T> type, List<Object> parts) {
            super(type, parts);
        }
    }

    private static class DateExpression<T extends Date>
    extends CmpExpression<T>
    implements DateExpressionImplementor<T> {
        private DateExpression(Class<T> type, List<Object> parts) {
            super(type, parts);
        }
    }

    private static class NumExpression<N extends Number>
    extends AnyExpression<N>
    implements NumericExpressionImplementor<N> {
        private NumExpression(Class<N> type, List<Object> parts) {
            super(type, parts);
        }
    }

    private static class StrExpression
    extends AnyExpression<String>
    implements StringExpressionImplementor {
        StrExpression(List<Object> parts) {
            super(String.class, parts);
        }
    }

    private static class Dt<T extends Date>
    extends Cmp<T>
    implements NativeBuilder.Dt<T> {
        Dt(Class<T> type, String sql) {
            super(type, sql);
        }

        @Override
        @NotNull
        public NativeBuilder.Dt<T> expression(@NotNull Expression<?> expression) {
            return (NativeBuilder.Dt)super.expression((Expression)expression);
        }

        @Override
        @NotNull
        public NativeBuilder.Dt<T> value(@NotNull Object value) {
            return (NativeBuilder.Dt)super.value(value);
        }

        @Override
        @NotNull
        public DateExpression<T> build() {
            return new DateExpression(this.type, this.parts());
        }
    }
}

