/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ScalarProviderUtils;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.TemporalExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.LiteralExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TupleExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.Variables;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.exception.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class Literals {
    private Literals() {
    }

    public static StringExpression string(String value) {
        return new Str(value);
    }

    public static <N extends Number> NumericExpression<N> number(N value) {
        return new Num<N>(value);
    }

    public static <T extends Date> DateExpression<T> date(T value) {
        return new Dt<T>(value);
    }

    public static <T extends Temporal & Comparable<?>> TemporalExpression<T> temporal(T value) {
        return new Tp<T>(value);
    }

    public static <T extends Comparable<?>> ComparableExpression<T> comparable(T value) {
        if (value instanceof String) {
            return Literals.string((String)((Object)value));
        }
        if (value instanceof Number) {
            return Literals.number((Number)((Object)value));
        }
        if (value instanceof Date) {
            return Literals.date((Date)value);
        }
        if (value instanceof Temporal) {
            return Literals.temporal((Temporal)((Object)value));
        }
        return new Cmp<T>(value);
    }

    public static <T> Expression<T> any(T value) {
        if (value instanceof String) {
            return Literals.string((String)value);
        }
        if (value instanceof Number) {
            return Literals.number((Number)((Object)((Comparable)value)));
        }
        if (value instanceof Date) {
            return Literals.date((Date)value);
        }
        if (value instanceof Temporal) {
            return Literals.temporal((Temporal)((Object)((Comparable)value)));
        }
        if (value instanceof Comparable) {
            return Literals.comparable((Comparable)value);
        }
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return new Any<T>(value);
    }

    public static void bind(Expression<?> mayBeLiteral, Expression<?> expression) {
        if (!(mayBeLiteral instanceof Any)) {
            return;
        }
        if (expression instanceof PropExpression) {
            ((Any)mayBeLiteral).setMatchedProp(((PropExpressionImplementor)expression).getProp());
        } else if (expression instanceof TupleExpressionImplementor) {
            TupleExpressionImplementor tupleExpr = (TupleExpressionImplementor)expression;
            int size = tupleExpr.size();
            ImmutableProp[] props = new ImmutableProp[size];
            boolean hasProp = false;
            for (int i = 0; i < size; ++i) {
                Selection<?> expr = tupleExpr.get(i);
                if (!(expr instanceof PropExpression)) continue;
                props[i] = ((PropExpressionImplementor)expr).getProp();
                hasProp = true;
            }
            if (hasProp) {
                ((Any)mayBeLiteral).setMatchedProps(props);
            }
        }
    }

    public static Collection<?> convert(Collection<?> literals, Expression<?> expression, JSqlClientImplementor sqlClient) {
        if (literals == null || literals.isEmpty()) {
            return literals;
        }
        if (expression instanceof PropExpression) {
            ImmutableProp prop = ((PropExpressionImplementor)expression).getProp();
            ScalarProvider scalarProvider = sqlClient.getScalarProvider(prop);
            if (scalarProvider == null) {
                return literals;
            }
            ArrayList<Object> newLiterals = new ArrayList<Object>(literals.size());
            for (Object literal : literals) {
                try {
                    newLiterals.add(literal != null ? ScalarProviderUtils.toSql(literal, scalarProvider, sqlClient.getDialect()) : null);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Cannot convert the value \"" + literal + "\" of prop \"" + prop + "\" by scalar provider \"" + scalarProvider.getClass().getName() + "\"", ex);
                }
            }
            return newLiterals;
        }
        if (expression instanceof TupleExpressionImplementor) {
            TupleExpressionImplementor tupleExpr = (TupleExpressionImplementor)expression;
            int size = tupleExpr.size();
            ImmutableProp[] props = new ImmutableProp[size];
            ScalarProvider[] scalarProviders = new ScalarProvider[size];
            boolean hasScalarProvider = false;
            for (int i = 0; i < size; ++i) {
                ImmutableProp prop;
                ScalarProvider scalarProvider;
                Selection<?> expr = tupleExpr.get(i);
                if (!(expr instanceof PropExpression) || (scalarProvider = sqlClient.getScalarProvider(prop = ((PropExpressionImplementor)expr).getProp())) == null) continue;
                props[i] = prop;
                scalarProviders[i] = scalarProvider;
                hasScalarProvider = true;
            }
            if (!hasScalarProvider) {
                return literals;
            }
            ArrayList<TupleImplementor> newLiterals = new ArrayList<TupleImplementor>(literals.size());
            for (Object literal : literals) {
                newLiterals.add(((TupleImplementor)literal).convert((value, index) -> {
                    ScalarProvider scalarProvider;
                    if (value != null && (scalarProvider = scalarProviders[index]) != null) {
                        try {
                            return ScalarProviderUtils.toSql(literal, scalarProvider, sqlClient.getDialect());
                        }
                        catch (Exception ex) {
                            throw new ExecutionException("Cannot convert the tuple item[index] of prop \"" + props[index] + "\" by scalar provider \"" + scalarProvider.getClass().getName() + "\"", ex);
                        }
                    }
                    return value;
                }));
            }
            return newLiterals;
        }
        return literals;
    }

    private static class Str
    extends Any<String>
    implements StringExpressionImplementor {
        public Str(String value) {
            super(value);
        }
    }

    private static class Num<N extends Number>
    extends Any<N>
    implements NumericExpressionImplementor<N> {
        public Num(N value) {
            super(value);
        }
    }

    private static class Dt<T extends Date>
    extends Any<T>
    implements DateExpressionImplementor<T> {
        public Dt(T value) {
            super(value);
        }
    }

    private static class Tp<T extends Temporal & Comparable<?>>
    extends Any<T>
    implements TemporalExpressionImplementor<T> {
        public Tp(T value) {
            super(value);
        }
    }

    private static class Cmp<T extends Comparable<?>>
    extends Any<T>
    implements ComparableExpressionImplementor<T> {
        public Cmp(T value) {
            super(value);
        }
    }

    static class Any<T>
    extends AbstractExpression<T>
    implements LiteralExpressionImplementor<T> {
        private final T value;
        private ImmutableProp matchedProp;
        private ImmutableProp[] matchedProps;

        public Any(T value) {
            if (value == null) {
                throw new IllegalArgumentException("The value of literal expression cannot be null.Except for `eq` and `ne`, most SQL expressions cannot be constructed based on using null, in order to avoid this problem:\n- java users can\n   Change `whereIf(<cond>, <expression>)` to whereIf(<cond>, () -> <expression>)\n- kotlin users can\n   Change `if (value !== null) where(<expression>)` to `value?.let { where(<expression>) }`");
            }
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Class<T> getType() {
            return this.value.getClass();
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
        }

        @Override
        public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
            if (builder instanceof BatchSqlBuilder) {
                ((BatchSqlBuilder)builder).rawVariable(this.finalValue(builder.sqlClient()));
            } else {
                ((SqlBuilder)builder).variable(this.finalValue(builder.sqlClient()));
            }
        }

        private Object finalValue(JSqlClientImplementor sqlClient) {
            if (this.matchedProp != null) {
                ScalarProvider scalarProvider = sqlClient.getScalarProvider(this.matchedProp);
                if (scalarProvider != null) {
                    try {
                        return ScalarProviderUtils.toSql(this.value, scalarProvider, sqlClient.getDialect());
                    }
                    catch (Exception ex) {
                        throw new ExecutionException("Cannot convert the value \"" + this.value + "\" of prop \"" + this.matchedProp + "\" by the scalar provider \"" + scalarProvider.getClass().getName() + "\"", ex);
                    }
                }
            } else if (this.matchedProps != null) {
                return ((TupleImplementor)this.value).convert((it, index) -> {
                    ImmutableProp prop = this.matchedProps[index];
                    ScalarProvider scalarProvider = sqlClient.getScalarProvider(prop);
                    if (scalarProvider != null) {
                        try {
                            return ScalarProviderUtils.toSql(it, scalarProvider, sqlClient.getDialect());
                        }
                        catch (Exception ex) {
                            throw new ExecutionException("Cannot convert the tuple item[" + index + "] of prop \"" + this.matchedProps[index] + "\" by the scalar provider \"" + scalarProvider.getClass().getName() + "\"", ex);
                        }
                    }
                    return it;
                });
            }
            return Variables.process(this.value, this.getType(), sqlClient);
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return false;
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            return this;
        }

        @Override
        public int precedence() {
            return 0;
        }

        public void setMatchedProp(ImmutableProp matchedProp) {
            if (this.matchedProp != null && this.matchedProp != matchedProp) {
                throw new IllegalStateException("The matched property of current literal expression has been configured, is the current literal expression is shared by difference parts of SQL DSL?");
            }
            this.matchedProp = matchedProp;
        }

        public void setMatchedProps(ImmutableProp[] matchedProps) {
            if (this.matchedProps != null && this.matchedProps != matchedProps) {
                throw new IllegalStateException("The matched properties of current literal expression has been configured, is the current literal expression is shared by difference parts of SQL DSL?");
            }
            this.matchedProps = matchedProps;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Any any = (Any)o;
            return this.value.equals(any.value) && Objects.equals(this.matchedProp, any.matchedProp) && Arrays.equals(this.matchedProps, any.matchedProps);
        }

        public int hashCode() {
            int result = Objects.hash(this.value, this.matchedProp);
            result = 31 * result + Arrays.hashCode(this.matchedProps);
            return result;
        }
    }
}

