/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Collection;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.jetbrains.annotations.NotNull;

class InCollectionPredicate
extends AbstractPredicate {
    private Expression<?> expression;
    private final Collection<?> values;
    private final boolean nullable;
    private final boolean negative;

    public InCollectionPredicate(Expression<?> expression, Collection<?> values, boolean nullable, boolean negative) {
        this.expression = expression;
        this.values = values;
        this.nullable = nullable;
        this.negative = negative;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        Ast.of(this.expression).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        ComparisonPredicates.renderIn(this.nullable, this.negative, this.expression, this.values, builder);
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return InCollectionPredicate.hasVirtualPredicate(this.expression);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.expression = ctx.resolveVirtualPredicate(this.expression);
        return this;
    }

    @Override
    public Predicate not() {
        return new InCollectionPredicate(this.expression, this.values, this.nullable, !this.negative);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InCollectionPredicate)) {
            return false;
        }
        InCollectionPredicate that = (InCollectionPredicate)o;
        return this.negative == that.negative && this.expression.equals(that.expression) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.values, this.negative);
    }
}

