/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Date;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NativeBuilder;
import org.babyfish.jimmer.sql.ast.impl.CaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NativeBuilderImpl;
import org.babyfish.jimmer.sql.ast.impl.SimpleCaseBuilder;
import org.jetbrains.annotations.NotNull;

public class ExpressionFactories {
    private ExpressionFactories() {
    }

    public static <F> F of(Class<F> factoryType) {
        if (factoryType == Expression.StringFactory.class) {
            return (F)Str.INSTANCE;
        }
        if (factoryType == Expression.NumericFactory.class) {
            return (F)Num.INSTANCE;
        }
        if (factoryType == Expression.ComparableFactory.class) {
            return (F)Cmp.INSTANCE;
        }
        if (factoryType == Expression.AnyFactory.class) {
            return (F)Any.INSTANCE;
        }
        throw new IllegalStateException("Unknown factory type \"" + factoryType.getName() + "\"");
    }

    private static class Str
    implements Expression.StringFactory {
        static final Str INSTANCE = new Str();

        private Str() {
        }

        @Override
        @NotNull
        public NativeBuilder.Str sqlBuilder(String sql) {
            return NativeBuilderImpl.string(sql);
        }

        @Override
        public <C> @NotNull SimpleCaseBuilder.Str<C> caseBuilder(C value) {
            return this.caseBuilder(Literals.any(value));
        }

        @Override
        public <C> @NotNull SimpleCaseBuilder.Str<C> caseBuilder(Expression<C> expression) {
            return new SimpleCaseBuilder.Str(expression);
        }

        @Override
        public @NotNull CaseBuilder.Str caseBuilder() {
            return new CaseBuilder.Str();
        }
    }

    private static class Num
    implements Expression.NumericFactory {
        static final Num INSTANCE = new Num();

        private Num() {
        }

        @Override
        public <N extends Number> @NotNull NativeBuilder.Num<N> sqlBuilder(Class<N> type, String sql) {
            return NativeBuilderImpl.numeric(type, sql);
        }

        @Override
        public <C, N extends Number> @NotNull SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> type, C value) {
            return this.caseBuilder(type, Literals.any(value));
        }

        @Override
        public <C, N extends Number> @NotNull SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> type, Expression<C> expression) {
            return new SimpleCaseBuilder.Num(type, (Expression<?>)expression);
        }

        @Override
        public <N extends Number> @NotNull CaseBuilder.Num<N> caseBuilder(Class<N> type) {
            return new CaseBuilder.Num<N>(type);
        }
    }

    private static class Cmp
    implements Expression.ComparableFactory {
        static final Cmp INSTANCE = new Cmp();

        private Cmp() {
        }

        @Override
        public <T extends Comparable<?>> @NotNull NativeBuilder.Cmp<T> sqlBuilder(Class<T> type, String sql) {
            return NativeBuilderImpl.comparable(type, sql);
        }

        @Override
        public <C, T extends Comparable<?>> @NotNull SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> type, C value) {
            return this.caseBuilder(type, Literals.any(value));
        }

        @Override
        public <C, T extends Comparable<?>> @NotNull SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> type, Expression<C> expression) {
            return new SimpleCaseBuilder.Cmp(type, expression);
        }

        @Override
        public <T extends Comparable<?>> @NotNull CaseBuilder.Cmp<T> caseBuilder(Class<T> type) {
            return new CaseBuilder.Cmp<T>(type);
        }
    }

    private static class Any
    implements Expression.AnyFactory {
        static final Any INSTANCE = new Any();

        private Any() {
        }

        @Override
        @NotNull
        public <T> NativeBuilder<T> sqlBuilder(Class<T> type, String sql) {
            return NativeBuilderImpl.any(type, sql);
        }

        @Override
        @NotNull
        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> type, C value) {
            return this.caseBuilder(type, Literals.any(value));
        }

        @Override
        @NotNull
        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> type, Expression<C> expression) {
            return new SimpleCaseBuilder(type, expression);
        }

        @Override
        @NotNull
        public <T> CaseBuilder<T> caseBuilder(Class<T> type) {
            return new CaseBuilder<T>(type);
        }
    }

    private static class Dt
    implements Expression.DateFactory {
        private Dt() {
        }

        @Override
        public <T extends Date> @NotNull NativeBuilder.Dt<T> sqlBuilder(Class<T> type, String sql) {
            return null;
        }

        @Override
        public <C, T extends Date> @NotNull SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> type, C value) {
            return null;
        }

        @Override
        public <C, T extends Date> @NotNull SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> type, Expression<C> expression) {
            return null;
        }

        @Override
        public <T extends Date> @NotNull CaseBuilder.Cmp<T> caseBuilder(Class<T> type) {
            return null;
        }
    }
}

