/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Date;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

class DateDiffExpression<T extends Date>
extends AbstractExpression<Float>
implements NumericExpressionImplementor<Float> {
    private DateExpression<T> raw;
    private Expression<T> other;
    private final SqlTimeUnit timeUnit;

    DateDiffExpression(DateExpression<T> raw, Expression<T> other, SqlTimeUnit timeUnit) {
        this.raw = raw;
        this.other = other;
        this.timeUnit = timeUnit;
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return DateDiffExpression.hasVirtualPredicate(this.raw) || DateDiffExpression.hasVirtualPredicate(this.other);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.raw = ctx.resolveVirtualPredicate(this.raw);
        this.other = ctx.resolveVirtualPredicate(this.other);
        return this;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.raw)).accept(visitor);
        ((Ast)((Object)this.other)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.sqlClient().getDialect().renderTimeDiff(builder, this.precedence(), (Ast)((Object)this.raw), (Ast)((Object)this.other), this.timeUnit);
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    public int precedence() {
        return 0;
    }
}

