/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.DateExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.TemporalExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

public class CoalesceBuilder<T> {
    private List<Expression<T>> expressions = new ArrayList<Expression<T>>();

    CoalesceBuilder(Expression<T> expression) {
        this.expressions.add(expression);
    }

    public CoalesceBuilder<T> or(Expression<T> expr) {
        if (((ExpressionImplementor)this.expressions.get(0)).getType() != ((ExpressionImplementor)expr).getType()) {
            throw new IllegalArgumentException("The branches of coalesce must belong to same type");
        }
        this.expressions.add(expr);
        return this;
    }

    public CoalesceBuilder<T> or(T value) {
        return this.or((T)Literals.any(value));
    }

    public Expression<T> build() {
        ArrayList<Expression<?>> clonedList;
        if (this.expressions.get(0) instanceof Expr) {
            clonedList = new ArrayList(((Expr)this.expressions.get(0)).expressions);
            clonedList.addAll(this.expressions.subList(1, this.expressions.size()));
        } else {
            clonedList = new ArrayList<Expression<T>>(this.expressions);
        }
        Class javaClass = ((ExpressionImplementor)this.expressions.get(0)).getType();
        if (String.class == javaClass) {
            return new StrExpr(clonedList);
        }
        if (javaClass.isPrimitive() || Number.class.isAssignableFrom(javaClass)) {
            return new NumExpr(clonedList);
        }
        if (Comparable.class.isAssignableFrom(javaClass)) {
            return new CmpExpr(clonedList);
        }
        return new Expr(clonedList);
    }

    private static class Expr<T>
    extends AbstractExpression<T> {
        private List<Expression<?>> expressions;

        @Override
        public Class<T> getType() {
            return ((ExpressionImplementor)this.expressions.get(0)).getType();
        }

        @Override
        public int precedence() {
            return 0;
        }

        public Expr(List<Expression<?>> expressions) {
            this.expressions = expressions;
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
            for (Expression<?> expression : this.expressions) {
                ((Ast)((Object)expression)).accept(visitor);
            }
        }

        @Override
        public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
            if (this.expressions.size() == 1) {
                this.renderChild((Ast)((Object)this.expressions.get(0)), builder);
            } else {
                ((AbstractSqlBuilder)builder.sql("coalesce")).enter(AbstractSqlBuilder.ScopeType.LIST);
                for (Expression<?> expression : this.expressions) {
                    builder.separator();
                    this.renderChild((Ast)((Object)expression), builder);
                }
                builder.leave();
            }
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return Expr.hasVirtualPredicate(this.expressions);
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            this.expressions = ctx.resolveVirtualPredicates(this.expressions);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Expr expr = (Expr)o;
            return this.expressions.equals(expr.expressions);
        }

        public int hashCode() {
            return Objects.hash(this.expressions);
        }
    }

    private static class StrExpr
    extends Expr<String>
    implements StringExpressionImplementor {
        public StrExpr(List<Expression<?>> expressions) {
            super(expressions);
        }
    }

    private static class NumExpr<N extends Number>
    extends Expr<N>
    implements NumericExpressionImplementor<N> {
        public NumExpr(List<Expression<?>> expressions) {
            super(expressions);
        }
    }

    private static class CmpExpr<T extends Comparable<?>>
    extends Expr<T>
    implements ComparableExpressionImplementor<T> {
        public CmpExpr(List<Expression<?>> expressions) {
            super(expressions);
        }
    }

    public static class Cmp<T extends Comparable<?>>
    extends CoalesceBuilder<T> {
        Cmp(Expression<T> expression) {
            super(expression);
        }

        @Override
        public Cmp<T> or(Expression<T> expr) {
            return (Cmp)super.or(expr);
        }

        @Override
        public Cmp<T> or(T value) {
            return (Cmp)super.or(value);
        }

        @Override
        public ComparableExpression<T> build() {
            return (ComparableExpression)super.build();
        }
    }

    public static class Tp<T extends Temporal & Comparable<?>>
    extends Cmp<T> {
        Tp(Expression<T> expression) {
            super(expression);
        }

        @Override
        public Tp<T> or(Expression<T> expr) {
            return (Tp)super.or((Expression)expr);
        }

        @Override
        public Tp<T> or(T value) {
            return (Tp)super.or(value);
        }

        @Override
        public TemporalExpression<T> build() {
            return (TemporalExpression)super.build();
        }
    }

    public static class Dt<T extends Date>
    extends Cmp<T> {
        Dt(Expression<T> expression) {
            super(expression);
        }

        @Override
        public Dt<T> or(Expression<T> expr) {
            return (Dt)super.or((Expression)expr);
        }

        @Override
        public Dt<T> or(T value) {
            return (Dt)super.or(value);
        }

        @Override
        public DateExpression<T> build() {
            return (DateExpression)super.build();
        }
    }

    public static class Num<N extends Number>
    extends Cmp<N> {
        Num(Expression<N> expression) {
            super(expression);
        }

        @Override
        public Num<N> or(Expression<N> expr) {
            return (Num)super.or((Expression)expr);
        }

        @Override
        public Num<N> or(N value) {
            return (Num)super.or(value);
        }

        @Override
        public NumericExpression<N> build() {
            return (NumericExpression)super.build();
        }
    }

    public static class Str
    extends Cmp<String> {
        Str(Expression<String> expression) {
            super(expression);
        }

        public Str or(Expression<String> expr) {
            return (Str)super.or((Expression)expr);
        }

        public Str or(String value) {
            return (Str)super.or(value);
        }

        @Override
        public StringExpression build() {
            return (StringExpression)super.build();
        }
    }
}

